/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

public class GetOpt {
    private int optind = 0;
    private String optarg;
    private String[] argv;
    private int argc;
    private String optionString;
    static int MINUS_POSITION = 0;
    static int OPTION_POSITION = 1;
    static int AFTER_OPTION_POSITION = 2;

    public GetOpt(String[] argv, String optionString) {
        this.argv = argv;
        this.optionString = optionString;
        this.argc = argv == null ? 0 : argv.length;
    }

    public int getNextOption() throws IllegalArgumentException {
        this.optarg = null;
        if (this.optind >= this.argc || this.argv[this.optind].length() < 2 || this.argv[this.optind].charAt(MINUS_POSITION) != '-') {
            return -1;
        }
        char currentOption = this.argv[this.optind].charAt(OPTION_POSITION);
        if (!this.isValidOption(currentOption)) {
            ++this.optind;
            throw new IllegalArgumentException("Illegal Option -- " + currentOption);
        }
        if (this.isOptionArgAllowedByOption(currentOption)) {
            if (this.argv[this.optind].length() != 2) {
                this.optarg = this.argv[this.optind].substring(AFTER_OPTION_POSITION);
                ++this.optind;
            } else if (this.optind + 1 >= this.argc) {
                ++this.optind;
                if (this.isOptionArgMandatoryByOption(currentOption)) {
                    throw new IllegalArgumentException("Option requires an argument:" + currentOption);
                }
            } else if (this.argv[this.optind + 1].charAt(MINUS_POSITION) == '-' && this.isValidOption(this.argv[this.optind + 1].charAt(OPTION_POSITION))) {
                ++this.optind;
                if (this.isOptionArgMandatoryByOption(currentOption)) {
                    throw new IllegalArgumentException("Option -- " + currentOption + " requires an argument");
                }
            } else {
                this.optarg = this.argv[++this.optind];
                ++this.optind;
            }
        } else if (this.argv[this.optind].length() == 2) {
            ++this.optind;
        } else {
            throw new IllegalArgumentException("Option -- " + currentOption + " does not take an argument");
        }
        return currentOption;
    }

    public String getOptionArg() {
        return this.optarg;
    }

    private boolean isValidOption(char c) {
        return c != ':' && this.optionString.indexOf(c) != -1;
    }

    private boolean isOptionArgMandatoryByOption(char option) {
        char x = option;
        return this.isValidOption(option) && this.optionString.length() > this.optionString.indexOf(option) + 1 && this.optionString.charAt(this.optionString.indexOf(option) + 1) == ':';
    }

    public int getNextOptionIndex() {
        return this.optind;
    }

    private boolean isOptionArgAllowedByOption(char option) {
        char x = option;
        return this.isValidOption(option) && this.optionString.length() > this.optionString.indexOf(option) + 1 && (this.optionString.charAt(this.optionString.indexOf(option) + 1) == ':' || this.optionString.charAt(this.optionString.indexOf(option) + 1) == ';');
    }
}

