/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.who;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import net.jxta.credential.Credential;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;

public class who
extends ShellApp {
    private ShellEnv myEnv;

    public int startApp(String[] args) {
        int i = 0;
        boolean pretty = false;
        boolean viewpg = false;
        ShellObject obj = null;
        PeerGroup group = null;
        MembershipService membership = null;
        MimeMediaType displayAs = null;
        this.myEnv = this.getEnv();
        if (args != null) {
            i = 0;
            while (i < args.length) {
                if (!args[i].equals("-p")) {
                    return this.syntaxError();
                }
                pretty = true;
                ++i;
            }
        }
        obj = this.myEnv.get("stdgroup");
        try {
            displayAs = pretty ? new MimeMediaType("text/plain") : new MimeMediaType("text/xml");
            group = (PeerGroup)obj.getObject();
            membership = group.getMembershipService();
            Enumeration eachCred = membership.getCurrentCredentials();
            while (eachCred.hasMoreElements()) {
                Credential aCred = (Credential)eachCred.nextElement();
                StructuredTextDocument doc = (StructuredTextDocument)aCred.getDocument(displayAs);
                StringWriter out = new StringWriter();
                doc.sendToWriter((Writer)out);
                this.println(((Object)out).toString());
            }
        }
        catch (Exception e) {
            this.println("# who : Failed due to " + e.toString());
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public int syntaxError() {
        this.println("error: who [-p]");
        return 1;
    }

    public void stopApp() {
    }

    public String getDescription() {
        return "Display credential information";
    }

    public void help() {
        this.println("NAME");
        this.println("     who - display credential information");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     who [-p]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("who displays the set of credentials associated with this");
        this.println("peer for the current peer group.");
        this.println("");
        this.println("OPTIONS");
        this.println("");
        this.println("     [-p]  pretty print credential information");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA>who -p");
        this.println(" ");
        this.println("This example displays a pretty printed credential ");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    setinfo peers");
    }
}

