/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.wc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.jxta.document.Advertisement;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.impl.shell.GetOpt;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class wc
extends ShellApp {
    protected ShellEnv env;
    protected boolean showLines;
    protected boolean showWords;
    protected boolean showChars;
    static /* synthetic */ Class class$net$jxta$document$Advertisement;
    static /* synthetic */ Class class$net$jxta$document$Document;

    public void stopApp() {
    }

    /*
     * WARNING - void declaration
     */
    public int startApp(String[] args) {
        try {
            Object objContent;
            ShellObject obj = null;
            String name = null;
            this.env = this.getEnv();
            if (args == null) {
                this.showChars = true;
                this.showWords = true;
                this.showLines = true;
                this.readStdin();
                return 0;
            }
            this.showChars = false;
            this.showWords = false;
            this.showLines = false;
            GetOpt getopt = new GetOpt(args, "clw");
            try {
                int c;
                while ((c = getopt.getNextOption()) != -1) {
                    void var5_6;
                    switch (var5_6) {
                        case 99: {
                            this.showChars = true;
                            break;
                        }
                        case 108: {
                            this.showLines = true;
                            break;
                        }
                        case 119: {
                            this.showWords = true;
                            break;
                        }
                        default: {
                            this.println("Error: option not supported.");
                            return 1;
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.println("Usage: " + this.syntax());
                return 1;
            }
            int pos = getopt.getNextOptionIndex();
            if (pos == 0) {
                this.showChars = true;
                this.showWords = true;
                this.showLines = true;
            }
            if (pos < args.length) {
                name = args[pos];
                obj = this.env.get(name);
                if (obj == null) {
                    this.println("wc: cannot access " + name);
                    return Integer.MAX_VALUE;
                }
            } else {
                this.readStdin();
                return 0;
            }
            if ((class$net$jxta$document$Advertisement == null ? (class$net$jxta$document$Advertisement = wc.class$("net.jxta.document.Advertisement")) : class$net$jxta$document$Advertisement).isInstance(objContent = obj.getObject())) {
                try {
                    this.readAdvertisement((Advertisement)objContent);
                    return 0;
                }
                catch (Exception e) {
                    this.println("wc: exception reading Advertisement. " + e.toString());
                    return Integer.MAX_VALUE;
                }
            }
            if ((class$net$jxta$document$Document == null ? (class$net$jxta$document$Document = wc.class$("net.jxta.document.Document")) : class$net$jxta$document$Document).isInstance(objContent)) {
                try {
                    this.readDocument((Document)objContent);
                    return 0;
                }
                catch (Exception e) {
                    this.println("wc: exception reading Document. " + e.toString());
                    return Integer.MAX_VALUE;
                }
            }
            this.println("wc: cannot read this kind of object.");
            return Integer.MAX_VALUE;
        }
        catch (Exception ex) {
            this.println("wc: exception " + ex.toString());
            ex.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    protected void readStdin() throws IOException {
        String inData = null;
        inData = this.inputPipe == this.consin ? this.readStdinConsole() : this.readStdinPipe();
        this.wcCount(inData);
    }

    protected String readStdinConsole() throws IOException {
        String moreData;
        String inData = "";
        while ((moreData = this.waitForInput()) != null && !moreData.equals(".")) {
            inData = inData + moreData + "\n";
        }
        return inData;
    }

    protected String readStdinPipe() throws IOException {
        String moreData;
        String inData = this.waitForInput();
        while ((moreData = this.pollInput()) != null) {
            inData = inData + moreData;
        }
        return inData;
    }

    protected void readAdvertisement(Advertisement adv) throws Exception {
        Document doc = adv.getDocument(new MimeMediaType("text/xml"));
        this.readDocument(doc);
    }

    protected void readDocument(Document doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        doc.sendToStream((OutputStream)out);
        this.wcCount(out.toString());
    }

    protected void wcCount(String inData) {
        int numLines = 0;
        int numWords = 0;
        int numChars = inData.length();
        boolean newWord = true;
        int i = 0;
        while (i < inData.length()) {
            char c = inData.charAt(i);
            if (c == '\n') {
                ++numLines;
                newWord = true;
            } else if (Character.isWhitespace(c)) {
                newWord = true;
            } else if (newWord) {
                newWord = false;
                ++numWords;
            }
            ++i;
        }
        String lineStr = String.valueOf(numLines);
        String wordStr = String.valueOf(numWords);
        String charStr = String.valueOf(numChars);
        String spaces = "        ";
        String result = "";
        int justOff = 6;
        if (this.showLines) {
            result = result + spaces.substring(0, justOff - lineStr.length()) + lineStr;
            justOff = 7;
        }
        if (this.showWords) {
            result = result + spaces.substring(0, justOff - wordStr.length()) + wordStr;
            justOff = 7;
        }
        if (this.showChars) {
            result = result + spaces.substring(0, justOff - charStr.length()) + charStr;
        }
        this.println(result);
    }

    protected String syntax() {
        return "wc [-c -l -w] [<objectName>]";
    }

    public String getDescription() {
        return "Count the number of lines, words, and chars in an object";
    }

    public void help() {
        this.println("NAME");
        this.println("     wc  - count the number of lines, words, and chars in an object");
        this.println("");
        this.println("SYNOPSIS");
        this.println("");
        this.println("     " + this.syntax());
        this.println("");
        this.println("DESCRIPTION");
        this.println("");
        this.println("'wc' counts the number of newlines, whitespace-separated words, ");
        this.println("and characters in the given shell object, or in the standard");
        this.println("input pipe if no object is specified.  It writes one line of");
        this.println("counts to the output pipe.  The counts are written in the");
        this.println("order: lines, words, characters.");
        this.println("");
        this.println("By default, wc writes all three counts.  Options can specify");
        this.println("that only certain counts be written.  Options do not undo");
        this.println("others previously given, so 'wc -c -l' writes both the");
        this.println("character count and the line count.");
        this.println("");
        this.println("If no object is specifed on the command line, wc will read from");
        this.println("stdin.  If stdin is the console, you may type in lines of text.");
        this.println("Enter a '.' all by itself at the beginning of a line to finish.");
        this.println("");
        this.println("OPTIONS");
        this.println("");
        this.println("  -c   Write the character count.");
        this.println("  -l   Write the line count.");
        this.println("  -w   Write the word count.");
        this.println("");
        this.println("EXAMPLES");
        this.println("");
        this.println("    JXTA>wc myfile");
        this.println("         18      52     675");
        this.println("");
        this.println("    JXTA>cat myfile | wc -w");
        this.println("         52");
        this.println("");
        this.println("The first example displays the number of lines, words, and chars");
        this.println("in myfile.  The second displays only the number of lines.");
        this.println("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

