/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.uninstjar;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellCmds;

public class uninstjar
extends ShellApp {
    protected Vector instJarList;
    protected ShellCmds cmds;

    public int startApp(String[] args) {
        if (args.length == 0) {
            return this.syntaxError();
        }
        this.cmds = new ShellCmds(this);
        this.instJarList = this.cmds.getInstJars();
        if (this.instJarList.isEmpty()) {
            return this.noJarsInstalledError();
        }
        if (args[0].equals("-all")) {
            Vector toRemoveList = (Vector)this.instJarList.clone();
            this.uninstallJars(toRemoveList);
        } else {
            Vector toRemoveList = new Vector();
            int i = 0;
            int max = this.instJarList.size() - 1;
            while (i < args.length) {
                block16: {
                    if (args[i].equals("-i")) {
                        if (++i >= args.length) {
                            this.println("Error: Missing index argument!");
                            break;
                        }
                        try {
                            int index = Integer.parseInt(args[i]);
                            if (index < 0 || index > max) {
                                this.println("Error: '" + index + "' out of range [0.." + max + "]!");
                                break block16;
                            }
                            toRemoveList.addElement(this.instJarList.elementAt(index));
                        }
                        catch (NumberFormatException e) {
                            this.println("Error: '" + args[i] + "' is not a valid number!");
                        }
                    } else if (args[i].equals("-f")) {
                        if (++i >= args.length) {
                            this.println("Error: Missing file argument!");
                            break;
                        }
                        File file = new File(args[i]);
                        if (this.instJarList.contains(file)) {
                            toRemoveList.addElement(file);
                        } else {
                            this.println("Error: '" + file + "' not found!");
                        }
                    } else {
                        this.println("Error: Unknown parameter '" + args[i] + "'!");
                    }
                }
                ++i;
            }
            this.uninstallJars(toRemoveList);
        }
        this.cmds.setInstJars(this.instJarList);
        return 0;
    }

    private int syntaxError() {
        this.println("Usage: uninstjar <-all | -f jar-file | -i index> [<-f jar-file | -i index> [...]]");
        return 1;
    }

    private int noJarsInstalledError() {
        this.println("Error: No jar-files installed!");
        return Integer.MAX_VALUE;
    }

    protected void uninstallJar(File file) {
        this.instJarList.removeElement(file);
    }

    protected void uninstallJars(Vector list) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            this.uninstallJar((File)e.nextElement());
        }
    }

    public String getDescription() {
        return "Uninstalls jar-files previously installed with 'instjar'";
    }

    public void help() {
        this.println("NAME");
        this.println("     uninstjar - uninstalls one or more jar-files previously");
        this.println("     installed with the command 'instjar'.");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     uninstjar <-all | -f file | -i index> [<-f file | -i index> [...]]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("This command uninstalls previously installed jar-files containing");
        this.println("additional Shell commands. Once uninstalled, the commands placed");
        this.println("in that jar-file are no longer available to the Shell.");
        this.println("An arbirtary number of jar-files to uninstall can be supplied.");
        this.println("Either through supplying the path to the jar-file itself or through");
        this.println("their indices, which can be obtained through invoking 'instjars'");
        this.println("with no arguments. The list of installed urls is stored in the environment");
        this.println("variable 'instjars'.");
        this.println("So uninstalling means removing the corresponding entry from this");
        this.println("environment variable.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("To uninstall a jar-file by supplying the path:");
        this.println("    JXTA>uninstjar -f c:/userlib/usrcmds.jar");
        this.println(" ");
        this.println("To uninstall a jar-file by its index first list all installed");
        this.println("jar-files with 'instjar':");
        this.println("    JXTA> instjar");
        this.println("    0 c:/userlib/usrcmds.jar");
        this.println("    1 c:/userlib/toolcmds.jar");
        this.println("Now uninstall a jar-file with its index:");
        this.println("    JXTA>uninstjar -i 1");
        this.println(" ");
        this.println("To uninstall all jar-files:");
        this.println("    JXTA>uninstjar -all");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    instjar ");
    }
}

