/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.sqlshell;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.shell.GetOpt;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellConsole;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellInputPipe;
import net.jxta.impl.shell.ShellObject;
import net.jxta.impl.shell.ShellOutputPipe;
import net.jxta.impl.shell.bin.history.HistoryQueue;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;

public class sqlshell
extends ShellApp
implements Runnable {
    public static final String ThisShell = "sqlshell";
    public static final String PromptString = "JXTA-SQL> ";
    public static final String History = "History";
    public static final String ParentShell = "parentShell";
    private static int shellInstance;
    private boolean gotMyOwnFrame = false;
    private ShellConsole cons = null;
    private Thread thread = null;
    private boolean gotParent = false;
    private ShellEnv parentEnv = null;
    private String shellRootEnvName = null;
    private BufferedReader scriptReader = null;
    private String pipecmd = null;
    private boolean printPrompt = true;
    static /* synthetic */ Class class$net$jxta$impl$shell$bin$history$HistoryQueue;

    public boolean isRootShell() {
        return !this.gotParent;
    }

    public int startApp(String[] args) {
        super.startApp(args);
        if (this.handleOptions(args) != 0) {
            return Integer.MAX_VALUE;
        }
        this.handleEnvironment();
        return this.handleFrame();
    }

    /*
     * WARNING - void declaration
     */
    private int handleOptions(String[] args) {
        try {
            int c;
            GetOpt getopt = new GetOpt(args, "sf:");
            block6: while ((c = getopt.getNextOption()) != -1) {
                void var3_4;
                switch (var3_4) {
                    case 102: {
                        if (this.initScriptFile(getopt.getOptionArg())) continue block6;
                        this.println("SQL Shell: cannot access " + args[1]);
                        return Integer.MAX_VALUE;
                    }
                    case 115: {
                        this.gotMyOwnFrame = true;
                        break;
                    }
                    default: {
                        this.println(" SQL Shell : Error -- this should have never happened");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.println("Illegal option");
            this.println("usage : Shell [-f filename] [-s] ");
        }
        return 0;
    }

    private void handleEnvironment() {
        if (null != this.getEnv()) {
            System.out.println("Child (sql) shell");
            this.gotParent = true;
            this.parentEnv = this.getEnv();
            this.setEnv(new ShellEnv(this.parentEnv));
            this.shellRootEnvName = this.parentEnv.createName();
            this.parentEnv.add(this.shellRootEnvName, new ShellObject("Child SQL Shell", this));
            ShellObject old = this.parentEnv.get(ThisShell);
            if (old != null) {
                this.getEnv().add(ParentShell, old);
            }
        } else {
            System.out.println("Top level (sql) shell");
            this.gotMyOwnFrame = true;
            this.setEnv(new ShellEnv());
            ShellObject shellObject = this.getEnv().add("stdgroup", new ShellObject("Default Group", this.group));
        }
        this.getEnv().add(ThisShell, new ShellObject("SQL Shell", this));
        this.getEnv().add("SHELL", new ShellObject("SQL Shell", this));
    }

    private int handleFrame() {
        if (this.gotMyOwnFrame) {
            String myName = "JXTA SQL Shell - " + shellInstance++;
            this.cons = new ShellConsole(myName, 30, 80);
            ShellInputPipe defaultInputPipe = new ShellInputPipe(this.group, this.cons);
            this.getEnv().add("stdin", new ShellObject("Default InputPipe", defaultInputPipe));
            this.getEnv().add("consin", new ShellObject("Default Console InputPipe", defaultInputPipe));
            this.setInputPipe(defaultInputPipe);
            this.setInputConsPipe(defaultInputPipe);
            ShellOutputPipe defaultOutputPipe = new ShellOutputPipe(this.group, this.cons);
            this.getEnv().add("stdout", new ShellObject("Default OutputPipe", defaultOutputPipe));
            this.getEnv().add("consout", new ShellObject("Default Console OutputPipe", defaultOutputPipe));
            this.setOutputPipe(defaultOutputPipe);
            this.setOutputConsPipe(defaultOutputPipe);
            this.thread = new Thread((Runnable)this, myName);
            this.thread.start();
            return -1;
        }
        if (this.pipecmd != null) {
            this.processCmd(this.pipecmd);
        } else {
            this.runShell();
        }
        return 0;
    }

    public void stopApp() {
        if (this.parentEnv != null) {
            this.parentEnv.remove(this.shellRootEnvName);
        }
        if (this.gotMyOwnFrame) {
            this.cons.destroy();
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
        super.stopApp();
    }

    public void run() {
        try {
            if (null != this.pipecmd) {
                this.startApp(new String[0]);
            } else {
                this.runShell();
            }
        }
        catch (Throwable all) {
            System.out.flush();
            System.err.println("Uncaught Exception in sqlShell");
            all.printStackTrace(System.err);
        }
    }

    private void initPipe(ShellEnv penv, String cmd) {
        String myName = "JXTA SQL Shell - " + shellInstance++;
        this.setEnv(penv);
        this.pipecmd = cmd;
        this.thread = new Thread((Runnable)this, myName);
        this.thread.start();
    }

    private void runShell() {
        if (this.scriptReader == null) {
            this.consprintln("=====================================");
            this.consprintln("=== Welcome to the JXTA SQL Shell ===");
            this.consprintln("=====================================");
            this.info();
        }
        this.startupFile();
        while (true) {
            String cmd = null;
            if (this.stopped) break;
            try {
                if (this.scriptReader == null) {
                    if (this.printPrompt) {
                        this.consprint(PromptString);
                    }
                    cmd = this.waitForInput();
                } else {
                    cmd = this.scriptReader.readLine();
                }
                if (cmd == null) {
                    return;
                }
            }
            catch (IOException e) {
                System.err.println("SQL Shell is reconnecting to console");
                this.setInputPipe(this.consin);
            }
            this.processMultipleCmd(cmd);
        }
    }

    private boolean initScriptFile(String fn) {
        try {
            this.scriptReader = new BufferedReader(new FileReader(fn));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void startupFile() {
        try {
            BufferedReader scriptReader = new BufferedReader(new FileReader(".jsqlshrc"));
            if (scriptReader == null) {
                return;
            }
            String cmd = scriptReader.readLine();
            while (cmd != null) {
                this.processMultipleCmd(cmd);
                cmd = scriptReader.readLine();
            }
            scriptReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processMultipleCmd(String cmd) {
        StringTokenizer tokens = new StringTokenizer(cmd, ";");
        HistoryQueue queue = this.getHistoryQueue();
        this.printPrompt = true;
        if (queue != null) {
            queue.addCommand(cmd);
        }
        while (tokens.hasMoreElements()) {
            this.processPipeCmd(tokens.nextToken());
        }
    }

    private HistoryQueue getHistoryQueue() {
        String[] exclude;
        ShellObject obj = this.getEnv().get(History);
        HistoryQueue queue = null;
        if (obj != null) {
            Object object;
            if ((class$net$jxta$impl$shell$bin$history$HistoryQueue == null ? (class$net$jxta$impl$shell$bin$history$HistoryQueue = sqlshell.class$("net.jxta.impl.shell.bin.history.HistoryQueue")) : class$net$jxta$impl$shell$bin$history$HistoryQueue).isInstance(object = obj.getObject())) {
                queue = (HistoryQueue)object;
            }
        } else if (this.cons != null && (exclude = new String[]{this.cons.getCursorDownName(), this.cons.getCursorUpName()})[0] != null && exclude[1] != null) {
            queue = new HistoryQueue(exclude);
            this.getEnv().add(History, new ShellObject(History, queue));
        }
        return queue;
    }

    private void processPipeCmd(String cmd) {
        Vector<String> cmds = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(cmd, "|");
        while (tokens.hasMoreElements()) {
            cmds.addElement(tokens.nextToken());
        }
        PeerGroup pg = (PeerGroup)this.getEnv().get("stdgroup").getObject();
        InputPipe stdin = (InputPipe)this.getEnv().get("stdin").getObject();
        OutputPipe stdout = (OutputPipe)this.getEnv().get("stdout").getObject();
        InputPipe pipein = null;
        OutputPipe pipeout = null;
        InputPipe lastin = stdin;
        Thread willDependOn = null;
        int i = 0;
        while (i < cmds.size() - 1) {
            PipeAdvertisement padv = null;
            try {
                padv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
                padv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)pg.getPeerGroupID()));
                pipein = this.pipes.createInputPipe(padv);
                pipeout = this.pipes.createOutputPipe(padv, -1L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            ShellEnv pipeenv = new ShellEnv(this.getEnv());
            pipeenv.add("stdout", new ShellObject("Default OutputPipe", pipeout));
            pipeenv.add("stdin", new ShellObject("Default InputPipe", lastin));
            pipeenv.add("stdgroup", new ShellObject("Default Peer Group", pg));
            sqlshell pipeShell = (sqlshell)this.loadApp(null, ThisShell, pipeenv);
            pipeShell.dependsOn = willDependOn;
            pipeShell.initPipe(pipeenv, (String)cmds.elementAt(i));
            willDependOn = pipeShell.thread;
            lastin = pipein;
            ++i;
        }
        this.getEnv().add("stdout", new ShellObject("Default OutputPipe", stdout));
        ShellObject oldin = this.getEnv().get("stdin");
        this.getEnv().add("stdin", new ShellObject("Default InputPipe", lastin));
        this.dependsOn = willDependOn;
        this.processCmd((String)cmds.lastElement());
        this.dependsOn = null;
        this.getEnv().add("stdin", oldin);
    }

    private void processCmd(String cmd) {
        String app;
        this.currentcmdline = new String(cmd);
        System.out.println("Command from processCmd: " + cmd);
        int index = cmd.indexOf("=");
        String var = null;
        if (index > 0) {
            var = cmd.substring(0, index).trim();
            cmd = cmd.substring(index + 1);
        }
        if (this.getEnv().contains("echo")) {
            this.consprintln(cmd);
        }
        if ((app = this.getAppName(cmd)) == null) {
            return;
        }
        String[] args = this.oldCommandParser(cmd);
        ShellApp appl = this.loadApp(var, app, this.getEnv());
        if (null != appl) {
            this.run(appl, args);
        }
    }

    private String[] newCommandParser(String cmd) {
        return null;
    }

    private String getAppName(String cmd) {
        String appname;
        StringTokenizer st = new StringTokenizer(cmd);
        try {
            appname = st.nextToken();
        }
        catch (Exception e) {
            appname = null;
        }
        return appname;
    }

    private String[] oldCommandParser(String cmd) {
        StringTokenizer tokens = new StringTokenizer(cmd);
        int size = tokens.countTokens();
        if (size < 1) {
            return null;
        }
        String[] args = new String[size - 1];
        tokens.nextToken();
        int index = 0;
        try {
            while (tokens.hasMoreElements()) {
                args[index] = tokens.nextToken();
                ++index;
            }
        }
        catch (Exception e) {
            return null;
        }
        return args;
    }

    private ShellApp loadApp(String var, String appName, ShellEnv env2) {
        ShellApp app = null;
        if (this.cons != null) {
            if (appName.equals("clear")) {
                this.cons.clear();
                return null;
            }
            if (appName.equals(this.cons.getCursorUpName())) {
                HistoryQueue queue = this.getHistoryQueue();
                if (queue != null) {
                    this.cons.setCommandLine(null, queue.getNextCommand());
                }
                this.printPrompt = false;
                return null;
            }
            if (appName.equals(this.cons.getCursorDownName())) {
                HistoryQueue queue = this.getHistoryQueue();
                if (queue != null) {
                    this.cons.setCommandLine(null, queue.getPreviousCommand());
                }
                this.printPrompt = false;
                return null;
            }
            if (appName.startsWith("!")) {
                try {
                    int number = Integer.valueOf(appName.substring(1));
                    HistoryQueue queue = this.getHistoryQueue();
                    if (queue != null) {
                        queue.removeLastCommand();
                        this.cons.setCommandLine(PromptString, queue.getCommand(number));
                        this.printPrompt = false;
                        return null;
                    }
                }
                catch (Exception iox) {
                    // empty catch block
                }
            }
        }
        this.printPrompt = true;
        try {
            int periodAt = appName.lastIndexOf(46);
            String appLeafName = 0 != periodAt ? appName.substring(periodAt + 1) : appName;
            String appClassName = "net.jxta.impl.shell.bin." + appName + "." + appLeafName;
            Class<?> appClass = Class.forName(appClassName);
            app = (ShellApp)appClass.newInstance();
            app.setEnv(env2);
            ShellObject obj = env2.get("stdgroup");
            app.setGroup((PeerGroup)obj.getObject());
            app.dependsOn = this.dependsOn;
            app.setInputConsPipe(this.getInputConsPipe());
            app.setOutputConsPipe(this.getOutputConsPipe());
            obj = env2.get("stdin");
            app.setInputPipe((InputPipe)obj.getObject());
            obj = env2.get("stdout");
            app.setOutputPipe((OutputPipe)obj.getObject());
            app.setReturnVariable(var);
        }
        catch (Throwable e) {
            this.println("command not found '" + appName + "'");
            return null;
        }
        app.init(this.getGroup(), null, null);
        return app;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(ShellApp app, String[] args) {
        try {
            int result = app.startApp(args);
            if (0 != result && -1 == result) return;
        }
        catch (Throwable e) {
            this.println("Exception in command.");
            StringWriter theStackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(theStackTrace));
            this.print(theStackTrace.toString());
            this.println(" ");
        }
    }

    public String getDescription() {
        return "JXTA SQL Shell command interpreter";
    }

    public void help() {
        this.println("NAME");
        this.println("     sqlhell  - JXTA SQL Shell command interpreter");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     sqlshell ");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.info();
        this.println(" ");
        this.println(" ");
        this.println(" ");
        this.println("SEE ALSO");
    }

    public void info() {
        this.println(" ");
        this.println("The JXTA SQL Shell provides an interactive environment to the JXTA    ");
        this.println("To exit the Shell, use the 'exit' command, or Control-D.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ThisShell = ThisShell;
        PromptString = PromptString;
        History = History;
        ParentShell = ParentShell;
        shellInstance = 1;
    }
}

