/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.share;

import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peergroup.PeerGroup;

public class share
extends ShellApp {
    private DiscoveryService disco = null;
    ShellEnv env;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("Usage: share <StructuredDocument>");
        return 1;
    }

    public int startApp(String[] args) {
        if (args == null || args.length != 1) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        this.disco = this.group.getDiscoveryService();
        String name = args[0];
        ShellObject obj = this.env.get("stdgroup");
        PeerGroup group = (PeerGroup)obj.getObject();
        obj = this.env.get(name);
        if (obj == null) {
            this.println("share: cannot access " + name);
            return Integer.MAX_VALUE;
        }
        Object doc = null;
        Advertisement adv = null;
        try {
            adv = (Advertisement)obj.getObject();
            this.publishAdv(adv);
        }
        catch (Exception e) {
            this.println("share: " + name + " is not a proper Document");
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    private void publishAdv(Advertisement adv) {
        try {
            this.disco.publish(adv, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDescription() {
        return "Share an advertisement";
    }

    public void help() {
        this.println("NAME");
        this.println("     share - share an advertisement");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     share <advertisement>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("share an advertisement document in the current peer group.");
        this.println("The document is made visible to all the members of the peer group.");
        this.println("Advertisements are XML documents that can represent any JXTA objects");
        this.println("advertisement, environment variables). Documents are searched");
        this.println("either in the local peer cache or remotely via the 'search' command.");
        this.println(" ");
        this.println("OPTIONS");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA>share mydoc ");
        this.println(" ");
        this.println("This example shares the document 'mydoc' into the current peer group.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    peers search");
    }
}

