/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.recv;

import net.jxta.endpoint.Message;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.pipe.InputPipe;

public class recv
extends ShellApp {
    ShellEnv env;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("Usage: recv [-t timeout] <InputPipe>");
        return 1;
    }

    public int startApp(String[] args) {
        if (args == null || args.length > 3) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        int timeout = -1;
        if (args[0].equals("-t")) {
            try {
                timeout = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                this.println("Timeout must be a number");
                return 1;
            }
        }
        String pipe = null;
        pipe = timeout >= 0 ? args[2] : args[0];
        ShellObject obj = this.env.get(pipe);
        if (obj == null) {
            this.println("recv: cannot access " + pipe);
            return Integer.MAX_VALUE;
        }
        InputPipe ip = null;
        try {
            ip = (InputPipe)obj.getObject();
        }
        catch (Exception e) {
            this.println("wait: " + pipe + " is not an InputPipe");
            this.println(e.toString());
            return Integer.MAX_VALUE;
        }
        Message msg = null;
        boolean counter = false;
        try {
            msg = timeout == -1 ? ip.poll(0) : ip.poll(timeout);
        }
        catch (InterruptedException woken) {
            Thread.interrupted();
        }
        if (msg == null) {
            this.println("recv has not received any message");
            return Integer.MAX_VALUE;
        }
        this.println("recv has received a message");
        ShellObject old = this.env.add(this.getReturnVariable(), new ShellObject("Message from  " + pipe, msg));
        return 0;
    }

    public String getDescription() {
        return "Receive a message from a pipe";
    }

    public void help() {
        this.println("NAME");
        this.println("     recv - receive a message from a pipe");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     recv [-t timeout] <input pipe>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'recv' receives a message from an input pipe. The input pipe needs");
        this.println("to have been previously created. A timeout in seconds can be given.");
        this.println("If no timeout is given, the call will block until a message is");
        this.println("received. A timeout of zero corresponds to a non-blocking call.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> pipeadv = mkadv -p");
        this.println("    JXTA> inpipe = mkpipe -i pipeadv");
        this.println("    JXTA> msg = recv inpipe");
        this.println("    JXTA> data = get msg mytag");
        this.println(" ");
        this.println("This example creates a pipe advertisement 'pipeadv'");
        this.println("create an input pipe 'inpipe' and receive a message 'msg'");
        this.println("The body of the message associated with the tag 'mytag' is");
        this.println("retreived from the message via the 'get' command.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    mkmsg put get send mkadv mkpipe");
    }
}

