/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.peers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.id.ID;
import net.jxta.impl.shell.GetOpt;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;

public class peers
extends ShellApp {
    private ShellEnv env;
    private static int i = 0;
    private DiscoveryService discovery = null;
    private EndpointService endpoint = null;
    private int threshold = 10;
    private String pid = null;
    private String attr = null;
    private String val = null;
    private boolean nflag = false;
    private boolean rflag = false;
    private boolean lflag = false;
    private boolean aflag = false;
    private boolean vflag = false;
    private boolean pflag = false;

    public void stopApp() {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int startApp(String[] args) {
        this.env = this.getEnv();
        this.discovery = this.group.getDiscoveryService();
        this.endpoint = this.group.getEndpointService();
        getopt = new GetOpt(args, "rflp:n:a:v:");
        try {
            block13: while (true) lbl-1000:
            // 8 sources

            {
                if ((c = getopt.getNextOption()) == -1) {
                    if ((this.attr == null || this.val == null) && (this.aflag || this.vflag)) {
                        this.println("You must specify both attribute, and value");
                        this.println("defaulting to generic retrieval");
                        this.attr = null;
                        this.val = null;
                    }
                    if (!this.rflag && !this.pflag) {
                        return this.getLocal(this.attr, this.val);
                    }
                    return this.discover(this.pid, this.attr, this.val);
                }
                switch (var3_3) {
                    case 112: {
                        this.pid = getopt.getOptionArg();
                        this.pflag = true;
                        ** break;
                    }
                    case 114: {
                        this.rflag = true;
                        ** break;
                    }
                    case 108: {
                        this.lflag = true;
                        ** break;
                    }
                    case 102: {
                        try {
                            this.discovery.flushAdvertisements(null, 0);
                            this.removeEnv();
                            this.discovery.publish((Advertisement)this.group.getPeerAdvertisement(), 0);
                            return 0;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    case 110: {
                        this.nflag = true;
                        this.threshold = Integer.parseInt(getopt.getOptionArg());
                        ** break;
                    }
                    case 97: {
                        this.aflag = true;
                        this.attr = getopt.getOptionArg();
                        ** break;
                    }
                    case 118: {
                        this.vflag = true;
                        this.val = getopt.getOptionArg();
                        if (this.val.length() != 1 || this.val.indexOf("*") == -1) continue block13;
                        this.println("* is not allowed, you must specify at least one char");
                        return 0;
                    }
                }
                this.println("Error: peers this should have never happened");
            }
        }
        catch (Exception ex) {
            this.println("Illegal option");
            this.shortHelp();
            return 0;
        }
    }

    private int discover(String address, String attr, String val) {
        this.discovery.getRemoteAdvertisements(address, 0, attr, val, this.threshold, null);
        this.println("peer discovery message sent");
        return 0;
    }

    private Enumeration getEndpointAddresses(PeerAdvertisement peerAdv) {
        TextElement endpParam = (TextElement)peerAdv.getServiceParam((ID)PeerGroup.endpointClassID);
        if (endpParam == null) {
            return null;
        }
        Enumeration endps = endpParam.getChildren("Addr");
        if (endps == null || !endps.hasMoreElements()) {
            return null;
        }
        Vector<EndpointAddress> addrs = new Vector<EndpointAddress>();
        while (endps.hasMoreElements()) {
            String saddr = "";
            try {
                saddr = ((TextElement)endps.nextElement()).getTextValue();
                addrs.addElement(this.endpoint.newEndpointAddress(saddr));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (addrs.size() == 0) {
            return null;
        }
        return addrs.elements();
    }

    private int getLocal(String attr, String val) {
        Enumeration res;
        try {
            res = this.discovery.getLocalAdvertisements(0, attr, val);
        }
        catch (Exception e) {
            this.println("nothing stored");
            return 0;
        }
        int j = 0;
        Enumeration endps = null;
        while (res.hasMoreElements()) {
            PeerAdvertisement peer = (PeerAdvertisement)res.nextElement();
            endps = this.getEndpointAddresses(peer);
            if (endps == null || !endps.hasMoreElements()) {
                try {
                    this.discovery.flushAdvertisements(peer.getPeerID().toString(), 0);
                }
                catch (IOException e) {}
                continue;
            }
            EndpointAddress endp = null;
            try {
                endp = (EndpointAddress)endps.nextElement();
            }
            catch (Exception ez1) {
                // empty catch block
            }
            this.env.add("peer" + j, new ShellObject("stored local peer advertisement", peer));
            String name = peer.getName();
            if (name.equals("")) {
                name = "Anonymous Peer";
            }
            if (this.lflag) {
                this.println("peer" + j + ": ID = " + peer.getPeerID().getUniqueValue() + " name = " + name + " addr = " + endp);
            } else {
                this.println("peer" + j + ": name = " + name);
            }
            if (this.nflag && ++j == this.threshold) break;
        }
        return 0;
    }

    public String getDescription() {
        return "Discover peers";
    }

    public void shortHelp() {
        this.println("NAME");
        this.println("     peers - discover peers ");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     peers [-p peerid name attribute] ");
        this.println("           [-n n] limit the number of responses to n from a single peer");
        this.println("           [-r] discovers peers using propagate");
        this.println("           [-l] displays peer id as a hex string");
        this.println("           [-a] specify Attribute name to limit discovery to");
        this.println("           [-v] specify Attribute value to limit discovery to. wild card is allowed");
        this.println("           [-f] flush peer advertisements");
    }

    public void help() {
        this.shortHelp();
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("use \"peers\" to discover other peers within a peer group or at a");
        this.println("specified peer location. Running \"peers\" command with no options lists");
        this.println("only the peers already known by the peer (cached). The '-r' option is used");
        this.println("to send a propagate request to find new peers.");
        this.println("peers stores results in the local cache, and inserts ");
        this.println("advertisement(s) into the environment, using the default");
        this.println("naming: peerX where X is a growing integer number.");
        this.println(" ");
        this.println("OPTIONS");
        this.println("-p peerid");
        this.println("     discovers peers at a given peer location");
        this.println("-r");
        this.println("     discovers peers using remote propagation");
        this.println("-l");
        this.println("     displays peer id as a hex string");
        this.println("-a");
        this.println("     specify Attribute name to limit discovery to");
        this.println("-v");
        this.println("     specify Attribute value to limit discovery to");
        this.println("-n");
        this.println("     limit the number of responses to n from a single peer");
        this.println("-f");
        this.println("     flush peer advertisements");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA>peers -r");
        this.println("or");
        this.println("    JXTA>peers -r -aName -vluxor* ");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    whoami chpgrp join groups");
    }

    private void removeEnv() {
        String peerenv = "peer0";
        int i = 0;
        while (this.env.contains(peerenv)) {
            this.env.remove(peerenv);
            peerenv = "peer" + ++i;
        }
    }
}

