/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.peerinfo;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.shell.GetOpt;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.peer.PeerInfoService;
import net.jxta.protocol.PeerInfoResponseMessage;

public class peerinfo
extends ShellApp {
    private ShellEnv env;
    private PeerInfoService pip = null;
    private ID pid = ID.nullID;
    private boolean pflag = false;
    private boolean rflag = false;
    private boolean lflag = false;
    private boolean fflag = false;

    public void stopApp() {
    }

    /*
     * WARNING - void declaration
     */
    public int startApp(String[] args) {
        this.env = this.getEnv();
        this.pip = this.group.getPeerInfoService();
        GetOpt getopt = new GetOpt(args, "flrp:");
        try {
            int c;
            while ((c = getopt.getNextOption()) != -1) {
                void var3_3;
                switch (var3_3) {
                    case 112: {
                        try {
                            URL peerid = new URL(getopt.getOptionArg());
                            this.pid = IDFactory.fromURL((URL)peerid);
                        }
                        catch (MalformedURLException badID) {
                            throw new IllegalArgumentException("Bad peerid ID");
                        }
                        catch (UnknownServiceException badID) {
                            throw new IllegalArgumentException("Unusable ID");
                        }
                        this.pflag = true;
                        break;
                    }
                    case 114: {
                        this.rflag = true;
                        break;
                    }
                    case 102: {
                        this.fflag = true;
                        break;
                    }
                    case 108: {
                        this.lflag = true;
                        break;
                    }
                    default: {
                        this.println("Error: peerinfo this should have never happened");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.println("Illegal option");
            this.help();
        }
        try {
            if (this.rflag) {
                return this.getRemote(this.pid);
            }
            if (this.lflag) {
                return this.getSelf();
            }
            if (this.fflag) {
                if (this.pflag) {
                    return this.flush(this.pid);
                }
                return this.flush(null);
            }
            if (this.pflag) {
                return this.getLocal(this.pid);
            }
            return this.getLocal(null);
        }
        catch (Throwable caught) {
            StringWriter theStackTrace = new StringWriter();
            caught.printStackTrace(new PrintWriter(theStackTrace));
            this.print(theStackTrace.toString());
            return Integer.MAX_VALUE;
        }
    }

    private int flush(ID address) throws Throwable {
        this.pip.flushAdvertisements(address);
        return 0;
    }

    private int getRemote(ID address) throws Throwable {
        this.pip.getRemotePeerInfo(address, null);
        this.println("peer info message sent");
        return 0;
    }

    private int getSelf() throws Throwable {
        PeerInfoResponseMessage resp = null;
        try {
            resp = this.pip.getPeerInfoService();
        }
        catch (Exception e) {
            this.println("nothing stored");
            throw e;
        }
        this.env.add("peerinfo0", new ShellObject("stored local peerinfo response", resp));
        this.println("stored peerinfo0");
        return 0;
    }

    private int getLocal(ID pid) throws Throwable {
        Enumeration res;
        try {
            res = this.pip.getLocalPeerInfo(pid);
        }
        catch (Exception e) {
            this.println("nothing stored");
            throw e;
        }
        int j = 1;
        while (res.hasMoreElements()) {
            PeerInfoResponseMessage peer = (PeerInfoResponseMessage)res.nextElement();
            String pname = "peerinfo" + j;
            this.env.add(pname, new ShellObject("stored local peerinfo response", peer));
            this.println("stored " + pname);
            ++j;
        }
        return 0;
    }

    public String getDescription() {
        return "Get information about peers";
    }

    public void help() {
        this.println("NAME");
        this.println("     peerinfo - get information about peers ");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     peerinfo ");
        this.println("           [-p peerid] ");
        this.println("           [-r] gets information about peers remotely");
        this.println("           [-l] return local peer info");
        this.println("           [-f] flush peer info");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("use to get information about other peers within a peer group or at a");
        this.println("specified peer location. The default peerinfo option lists");
        this.println("only the peerinfo already known by the peer. The '-r' option is used");
        this.println("to send a propagate request to find information about new peers.");
        this.println("peerinfo stores results in the local cache, and inserts ");
        this.println("advertisement(s) into the environment, using the default");
        this.println("naming: peerinfoX where X is a growing integer number.");
        this.println(" ");
        this.println("OPTIONS");
        this.println("-p peerid");
        this.println("     gets peer info at a given peer location");
        this.println("-r");
        this.println("     gets info about remote peers");
        this.println("-l");
        this.println("     return local peer info");
        this.println("-f");
        this.println("     flush locally cached peer info");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA>peerinfo -r");
        this.println(" ");
        this.println("    refresh info about the peers in the current peer group");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    ");
    }
}

