/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.more;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class more
extends ShellApp {
    private ShellEnv env;
    private int count = 0;
    private static final int MAX_CONSOLE = 20;

    public void stopApp() {
    }

    public int startApp(String[] args) {
        try {
            String name = null;
            this.env = this.getEnv();
            if (null == args || args.length > 1) {
                this.println("Synopsis :");
                this.println("more <var>");
                return 1;
            }
            if (args.length == 1) {
                name = args[0];
                ShellObject obj = this.env.get(name);
                if (obj == null) {
                    this.println("more: cannot access " + name);
                    return Integer.MAX_VALUE;
                }
                try {
                    this.moreAdvertisement((Advertisement)obj.getObject());
                    return 0;
                }
                catch (Exception e) {
                    try {
                        this.moreStructuredDocument((StructuredDocument)obj.getObject());
                        return 0;
                    }
                    catch (Exception e2) {
                        this.println("more: cannot read this kind of object");
                        return Integer.MAX_VALUE;
                    }
                }
            }
            this.moreStdin();
            return 0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    private void moreStructuredDocument(StructuredDocument doc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            doc.sendToStream((OutputStream)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pagein(out.toString());
    }

    private void moreAdvertisement(Advertisement adv) {
        StringWriter out = new StringWriter();
        try {
            StructuredTextDocument doc = (StructuredTextDocument)adv.getDocument(new MimeMediaType("text/plain"));
            doc.sendToWriter((Writer)out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pagein(out.toString());
    }

    private void moreStdin() {
        try {
            String entry;
            while ((entry = this.waitForInput()) != null) {
                this.pagein(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pagein(String data) {
        StringTokenizer tokens = new StringTokenizer(data, "\n");
        Object line = null;
        try {
            block2: while (true) {
                if (!tokens.hasMoreElements()) {
                    return;
                }
                while (true) {
                    if (this.count >= 20) {
                        this.count = 0;
                        this.println("-----More-----");
                        String entry = this.consWaitForInput();
                        if (!entry.equals("q")) continue block2;
                        return;
                    }
                    this.println(tokens.nextToken());
                    ++this.count;
                }
                break;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public String getDescription() {
        return "Page through a Shell object";
    }

    public void help() {
        this.println("NAME");
        this.println("     more  - page through a Shell object");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     more [<doc>]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'more' is a Shell command that pages through the content ");
        this.println("of an object stored in environment variable. The name of the");
        this.println("is provided as an argument. If no argument is supplied, the");
        this.println("command takes its inputs from the 'stdin' shell pipe.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> cat myfile | more");
        this.println(" ");
        this.println("This command pipes the content of the variable 'myfile' into the");
        this.println("'more' command and displays it to the Shell console.");
        this.println(" ");
        this.println("SEE ALSO");
    }

    static {
        MAX_CONSOLE = 20;
    }
}

