/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.mkpipe;

import java.io.IOException;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;

public class mkpipe
extends ShellApp {
    ShellEnv env;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("usage: mkpipe -i|o pipeAdv");
        return 1;
    }

    public int startApp(String[] args) {
        if (args == null || args.length != 2) {
            return this.syntaxError();
        }
        if (!args[0].equals("-i") && !args[0].equals("-o")) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        ShellObject obj = this.env.get(args[1]);
        if (obj == null) {
            this.println("cat: cannot access " + args[1]);
            return Integer.MAX_VALUE;
        }
        PipeAdvertisement adv = null;
        try {
            adv = (PipeAdvertisement)obj.getObject();
        }
        catch (Exception e) {
            this.println("mkpipe: " + args[1] + " is not an PipeAdvertisement");
            return Integer.MAX_VALUE;
        }
        if (adv == null) {
            this.println("mkpipe: " + args[1] + " is empty");
            return Integer.MAX_VALUE;
        }
        if (args[0].equals("-i")) {
            InputPipe ip = null;
            try {
                ip = this.pipes.createInputPipe(adv);
            }
            catch (IOException e) {
                this.println("mkpipe: cannot create an InputPipe onto " + args[1]);
                return Integer.MAX_VALUE;
            }
            ShellObject old = this.env.add(this.getReturnVariable(), new ShellObject("InputPipe of " + args[1], ip));
        } else {
            OutputPipe op = null;
            try {
                op = this.pipes.createOutputPipe(adv, -1L);
            }
            catch (IOException e) {
                this.println("mkpipe: cannot create an OutputPipe onto " + args[1]);
                return Integer.MAX_VALUE;
            }
            ShellObject old = this.env.add(this.getReturnVariable(), new ShellObject("OutputPipe of " + args[1], op));
        }
        return 0;
    }

    public String getDescription() {
        return "Create a pipe";
    }

    public void help() {
        this.println("NAME");
        this.println("     mkpipe - create a pipe");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     mkpipe -i|o <pipe advertisement>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'mkpipe' creates an input pipe or an output pipe from a given");
        this.println("pipe advertisement document. In order for pipes to communicate");
        this.println("an input and output pipe needs to be created with the same");
        this.println("pipe advertisement. PipeServiceService advertisements are structured documents that");
        this.println("contains at least the unique pipe Id. The pipe Id uniquely");
        this.println("identifies a pipe in the JXTA world. Pipes are not localized");
        this.println("or binded to a physical peer. PipeServiceService connections are established");
        this.println("by searching for pipe advertisements and resolving dynamically");
        this.println("the location of an input pipe object binded to that advertisement.");
        this.println("An input pipe can be binded to the same pipe advertisement on");
        this.println("multiple peers transparently to the output pipe. The output pipe");
        this.println("does not need to known on which physical peer the input pipe is");
        this.println("located. To communicate with the pipe, the output pipe needs");
        this.println("to search for the input pipe that binds that advertisement.");
        this.println(" ");
        this.println("OPTIONS");
        this.println(" ");
        this.println("  -i create an input pipe");
        this.println("  -o create an output pipe");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> pipeadv = mkadv -p");
        this.println("    JXTA> inpipe = mkpipe -i pipeadv");
        this.println("    JXTA> msg = recv inpipe");
        this.println("    JXTA> data = get msg mytag");
        this.println(" ");
        this.println("This example creates a pipe advertisement 'pipeadv'");
        this.println("create an input pipe 'inpipe' and receive a message 'msg'");
        this.println("The body of the message associated with the tag 'mytag' is");
        this.println("retreived from the message via the 'get' command.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    mkmsg put get send recv mkadv");
    }
}

