/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.join;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.document.Advertisement;
import net.jxta.document.StructuredDocument;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerGroupAdvertisement;

public class join
extends ShellApp {
    private ShellEnv env;
    private String name = null;
    private String advDoc = null;
    private PeerGroupAdvertisement adv = null;
    private PeerGroupAdvertisement origAdv = null;
    private ShellObject obj = null;
    private PeerGroup parent = null;
    private boolean beRendezvous = false;
    static /* synthetic */ Class class$net$jxta$document$StructuredDocument;

    public int startApp(String[] args) {
        PeerGroup pg;
        this.env = this.getEnv();
        int i = 0;
        this.name = null;
        String credDoc = null;
        StructuredDocument creds = null;
        i = 0;
        while (i < args.length) {
            if (args[i].equals("-d")) {
                this.advDoc = args[++i];
            } else if (args[i].equals("-c")) {
                credDoc = args[++i];
            } else if (args[i].equals("-r")) {
                this.beRendezvous = true;
            } else {
                this.name = args[i];
            }
            ++i;
        }
        if (this.advDoc != null) {
            this.obj = this.env.get("rootgroup");
            if (this.obj == null) {
                this.obj = this.env.get("stdgroup");
            }
            this.parent = (PeerGroup)this.obj.getObject();
            this.obj = this.env.get(this.advDoc);
            if (this.obj == null) {
                this.println("join: cannot access " + this.advDoc);
                return Integer.MAX_VALUE;
            }
            try {
                this.adv = (PeerGroupAdvertisement)this.obj.getObject();
                this.name = this.adv.getName();
                if (null != this.env.get("PG@" + this.name) && null != this.env.get("PG#" + this.name)) {
                    this.println("A group named '" + this.name + "' already exists.");
                    this.println("The new group from '" + this.advDoc + "' cannot be ");
                    this.println("joined by the JXTA shell until next restart.");
                    return 1;
                }
                pg = this.parent.newGroup((Advertisement)this.adv);
            }
            catch (Exception e) {
                this.println("join: " + this.name + " is not a proper PeerGroup advertisement");
                StringWriter theStackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(theStackTrace));
                this.print(theStackTrace.toString());
                return 1;
            }
            if (this.env != null) {
                this.env.add("PG#" + this.name, new ShellObject("PeerGroup", pg));
            } else {
                this.println("lost the parent Shell frame, this is bad !");
                return 1;
            }
        }
        if (this.name == null) {
            pg = (PeerGroup)this.env.get("stdgroup").getObject();
            String cname = pg.getPeerGroupAdvertisement().getName();
            Enumeration e = this.env.elements();
            while (e.hasMoreElements()) {
                String group = (String)e.nextElement();
                if (group.indexOf("PG#") != -1) {
                    this.println(" Unjoined Group : " + group.substring(3));
                }
                if (group.indexOf("PG@") == -1) continue;
                this.print(" Joined Group   : " + group.substring(3));
                if (cname.equals(group.substring(3))) {
                    this.println("       (current)");
                    continue;
                }
                this.println(" ");
            }
            return 0;
        }
        ShellObject obj = this.env.get("PG#" + this.name);
        if (obj == null) {
            this.println("The peergroup '" + this.name + "' does not exist, use '-d group#' if you discovered the group,");
            this.println("or you may already have joined this group.");
            return 1;
        }
        PeerGroup npg = (PeerGroup)obj.getObject();
        if (npg == null) {
            this.println("Sorry this peergroup does not exist. You need to create it");
            return 1;
        }
        if (this.beRendezvous) {
            this.println("Starting rdv");
            npg.getRendezVousService().startRendezVous();
        } else {
            this.println("Stopping rdv");
            npg.getRendezVousService().stopRendezVous();
        }
        if (null != credDoc) {
            if (!(class$net$jxta$document$StructuredDocument == null ? (class$net$jxta$document$StructuredDocument = join.class$("net.jxta.document.StructuredDocument")) : class$net$jxta$document$StructuredDocument).isAssignableFrom((obj = this.env.get(credDoc)).getObjectClass())) {
                this.println("Provided Credential was not a Structured Document");
                this.println("Group was joined, but login was not incorrect.");
                return Integer.MAX_VALUE;
            }
            creds = (StructuredDocument)obj.getObject();
        }
        try {
            AuthenticationCredential authCred = new AuthenticationCredential(npg, null, creds);
            this.println("Enter the identity you want to use when joining this peergroup (nobody)");
            MembershipService membership = npg.getMembershipService();
            Authenticator auth = membership.apply(authCred);
            this.completeAuth(auth);
            if (!auth.isReadyForJoin()) {
                this.println("Failure in authentication.");
                this.println("Group was not joined. Does not know how to complete authenticator");
                return Integer.MAX_VALUE;
            }
            membership.join(auth);
        }
        catch (Exception all) {
            this.println("Failure in authentication.");
            this.println("Group was not joined. Login was incorrect.");
            return Integer.MAX_VALUE;
        }
        this.env.remove("PG#" + this.name);
        this.env.add("PG@" + this.name, new ShellObject("PeerGroup", npg));
        obj = this.env.get("rootgroup");
        if (obj == null) {
            obj = this.env.get("stdgroup");
            PeerGroup pg2 = (PeerGroup)obj.getObject();
            this.env.add("rootgroup", new ShellObject("PeerGroup", pg2));
        }
        this.env.add("stdgroup", new ShellObject("PeerGroup", npg));
        return 0;
    }

    public void stopApp() {
    }

    private void completeAuth(Authenticator auth) throws Exception {
        Method[] methods = auth.getClass().getMethods();
        Vector<Method> authMethods = new Vector<Method>();
        int eachMethod = 0;
        while (eachMethod < methods.length) {
            if (methods[eachMethod].getName().startsWith("setAuth") && Modifier.isPublic(methods[eachMethod].getModifiers())) {
                int doInsert = 0;
                while (doInsert <= authMethods.size()) {
                    int insertHere = -1;
                    if (doInsert == authMethods.size()) {
                        insertHere = doInsert;
                    } else if (methods[eachMethod].getName().compareTo(((Method)authMethods.elementAt(doInsert)).getName()) <= 0) {
                        insertHere = doInsert;
                    }
                    if (-1 != insertHere) {
                        authMethods.insertElementAt(methods[eachMethod], insertHere);
                        break;
                    }
                    ++doInsert;
                }
            }
            ++eachMethod;
        }
        int eachAuthMethod = 0;
        while (eachAuthMethod < authMethods.size()) {
            Method doingMethod = (Method)authMethods.elementAt(eachAuthMethod);
            String authStepName = doingMethod.getName().substring(7);
            this.print(authStepName + " : ");
            String input = this.waitForInput();
            Object[] params = new Object[]{input};
            doingMethod.invoke((Object)auth, params);
            ++eachAuthMethod;
        }
    }

    public int syntaxError() {
        this.println("Usage: join [-r] [-c <credential>] (-d <adv> | <name>) ");
        return 1;
    }

    public String getDescription() {
        return "Join a peer group";
    }

    public void help() {
        this.println("NAME");
        this.println("     join - join a peer group");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     join [-r] [-c <credential>] (-d <adv> | <name>) ");
        this.println("     ");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("The 'join' command is used to join a peergroup that was created");
        this.println("via a 'mkpgrp' command or using an advertisement that was previously discovered.");
        this.println("In order to join a group, the group needs to have been discovered or");
        this.println("created first.");
        this.println("If no argument is given, join lists all the existing groups and their");
        this.println("status (join, unjoined) and the current group on the local peer.");
        this.println("After a group was joined successfully, the 'PG@<group name>'");
        this.println("environment variable is created. This variable holds the group info.");
        this.println("When joining a new peer group, the new peer group is advertised in");
        this.println("the 'NetPeerGroup'. No hierarchy of peer groups is supported.");
        this.println("Upon joining the peer group depending on the membership authentication");
        this.println("required, the user will be asked for the identity he/she wants to have");
        this.println("in the peer group. An identity is used to assign credential");
        this.println("to users when accessing peer group ressouces. Each peer group");
        this.println("can define their own set of identities available in the peer group.");
        this.println("The identities available for a peer group can be found in the peer");
        this.println("group advertisement via the 'cat' command in the service");
        this.println("section:");
        this.println(" ");
        this.println(" <Svc>");
        this.println("  <MCID>urn:jxta:uuid-DEADBEEFDEAFBABAFEEDBABE0000000505</MCID>");
        this.println("  <Parm>");
        this.println("   <login>myjxtauser:PAQ:</login>");
        this.println("   <login>myjxtasuperuser:PAXXQ:</login>");
        this.println("  </Parm>");
        this.println("  </Svc>");
        this.println("  ");
        this.println("The preceeding shows the two identity 'myjxtauser' and ");
        this.println("'myjxtasuperuser' allowed in this peer group. These identities");
        this.println("require a password.");
        this.println(" ");
        this.println("For example");
        this.println(" ");
        this.println("    JXTA> join mygroup");
        this.println("     identity:tra");
        this.println("     passwd:XXXXX");
        this.println("    JXTA>");
        this.println(" ");
        this.println("OPTIONS");
        this.println("");
        this.println("     [-r] sets the peer as a rendezvous for this group (default is not a");
        this.println("          rendezvous.");
        this.println("     [-d adv]  specify a shell variable holding a  peergroup advertisement");
        this.println("     [-c credential]  specify a credential to join the peer group");
        this.println("      <name> specify the name for an already created peer group");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("      JXTA>mygroupadv = mkadv -g mygroup");
        this.println("      JXTA>mkpgrp -d mygroupadv mygroup");
        this.println("      JXTA>join mygroup");
        this.println(" ");
        this.println(" This creates a new peer group which is cloning the services");
        this.println(" of the parent peer group ('NetPeerGroup'). You can find the services of the");
        this.println(" current peergroup via the command 'whoami -g'. The new group");
        this.println(" is given the name 'mygroup'. Before you can do anything with");
        this.println(" the group you need to join the group via the 'join' command.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("      mkadv mkpgrp leave chpgrp who");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

