/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.importfile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class importfile
extends ShellApp {
    ShellEnv env;
    String envName;
    boolean noenv = false;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("Usage: importfile -f <filename> [<env>]");
        return 1;
    }

    public int startApp(String[] args) {
        int i = 0;
        if (args == null || args.length > 3) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        String filename = null;
        if (!args[i].equals("-f")) {
            return this.syntaxError();
        }
        filename = args[i + 1];
        i = 2;
        if (args.length != i + 1) {
            this.noenv = true;
        } else {
            this.envName = args[i];
        }
        return this.importfileFile(filename);
    }

    private File openFile(String fn) {
        try {
            return new File(fn);
        }
        catch (RuntimeException e) {
            this.println("importfile: cannot open file " + fn);
            return null;
        }
    }

    private InputStream getInput(File f) {
        try {
            return new FileInputStream(f);
        }
        catch (Exception e) {
            this.println("importfile: cannot open the file for reading");
            return null;
        }
    }

    private int importfileFile(String fn) {
        File file = this.openFile(fn);
        if (file == null) {
            return 0;
        }
        InputStream ip = this.getInput(file);
        if (ip == null) {
            return 0;
        }
        byte[] buffer = null;
        try {
            buffer = new byte[(int)file.length()];
            int res = ip.read(buffer);
            ip.close();
            if (buffer.length > 65536) {
                this.println("importfile: file too big > 64Kb");
                return Integer.MAX_VALUE;
            }
        }
        catch (Exception e) {
            this.println("importfile: cannot read the file");
            return Integer.MAX_VALUE;
        }
        ip = new ByteArrayInputStream(buffer);
        StructuredDocument doc = null;
        try {
            if (buffer[0] == 60 && buffer[1] == 63 && buffer[2] == 120 && buffer[3] == 109 && buffer[4] == 108) {
                doc = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)new MimeMediaType("text/xml"), (InputStream)ip);
                ip.close();
            } else {
                String newDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ShellDoc>\n<Item>\n" + new String(buffer) + "\n</Item>\n</ShellDoc>";
                ip = new ByteArrayInputStream(newDoc.getBytes());
                doc = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)new MimeMediaType("text/xml"), (InputStream)ip);
                ip.close();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return Integer.MAX_VALUE;
        }
        if (this.noenv) {
            try {
                StringWriter out = new StringWriter();
                ((StructuredTextDocument)doc).sendToWriter((Writer)out);
                this.println(out.toString());
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            ShellObject old = this.env.add(this.envName, new ShellObject("StructuredDocument", doc));
        }
        return 0;
    }

    public String getDescription() {
        return "Import an external file";
    }

    public void help() {
        this.println("NAME");
        this.println("     importfile - import an external file ");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     importfile -f <filename> [<env>]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println("'importfile' imports an external file into a StructuredDocument");
        this.println("object stored in a Shell environment variable. The name of the");
        this.println("environment variable is specified as an argument.");
        this.println("'importfile' is the reverse operation of 'exportfile'");
        this.println(" ");
        this.println("EXAMPLE");
        this.println("    JXTA> importfile -f /home/tra/myfile myfile");
        this.println("    JXTA> cat myfile");
        this.println(" ");
        this.println("This command imports the file '/home/tra/myfile' into the");
        this.println("'myfile' environment variable");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("        exportfile ");
    }
}

