/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.get;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.NoSuchElementException;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.document.BinaryDocument;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class get
extends ShellApp {
    ShellEnv env;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("usage: get <msg> <name>");
        return 1;
    }

    public int startApp(String[] args) {
        if (args == null || args.length != 2) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        ShellObject obj = this.env.get(args[0]);
        if (obj == null) {
            this.println("get: cannot access " + args[0]);
            return Integer.MAX_VALUE;
        }
        Message msg = null;
        try {
            msg = (Message)obj.getObject();
        }
        catch (Exception e) {
            this.println("get: " + args[0] + " is not a Message");
            return Integer.MAX_VALUE;
        }
        if (msg == null) {
            this.println("get: " + args[0] + " is empty");
            return Integer.MAX_VALUE;
        }
        String name = args[1];
        InputStream ip = null;
        StructuredDocument doc = null;
        try {
            MessageElement elem = msg.getElement(name);
            msg.removeElement(elem);
            ip = elem.getStream();
            try {
                doc = StructuredDocumentFactory.newStructuredDocument((MimeMediaType)elem.getType(), (InputStream)ip);
                ShellObject old = this.env.add(this.getReturnVariable(), new ShellObject("StructuredDocument", doc));
                return 0;
            }
            catch (NoSuchElementException notadoc) {
                ip = elem.getStream();
                ByteArrayOutputStream op = new ByteArrayOutputStream();
                int aChar = 0;
                do {
                    if (-1 == (aChar = ip.read())) continue;
                    op.write(aChar);
                } while (aChar >= 0);
                BinaryDocument bdoc = new BinaryDocument(op.toByteArray());
                ShellObject old = this.env.add(this.getReturnVariable(), new ShellObject("BinaryDocument", bdoc));
                return 0;
            }
        }
        catch (Exception e) {
            this.println("get: failed with an exception ");
            StringWriter theStackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(theStackTrace));
            this.print(theStackTrace.toString());
            return Integer.MAX_VALUE;
        }
    }

    public String getDescription() {
        return "Get data from a pipe message";
    }

    public void help() {
        this.println("NAME");
        this.println("     get - get data from a pipe message");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println("     get <msg> <tag>");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'get' retrieve the tag body of a message. JXTA messages are");
        this.println("composed a set of tag body, each identified with an unique tag name");
        this.println("A message tag name is supplied to command to specify which tag body");
        this.println("to extract.");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> pipeadv = mkadv -p");
        this.println("    JXTA> inpipe = mkpipe -i pipeadv");
        this.println("    JXTA> msg = recv inpipe");
        this.println("    JXTA> data = get msg mytag");
        this.println(" ");
        this.println("This example creates a pipe advertisement 'pipeadv',");
        this.println("creates an input pipe 'inpipe', and receives a message 'msg'.");
        this.println("The tag body of the message associated with the tag 'mytag' is");
        this.println("retreived from the message via the 'get' command.");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("    mkmsg put send recv mkadv mkpipe");
    }
}

