/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.exportfile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class exportfile
extends ShellApp {
    ShellEnv env;
    boolean stdout = false;

    public void stopApp() {
    }

    private int syntaxError() {
        this.println("Usage: exportfile -f <filename> <variable>");
        return 1;
    }

    public int startApp(String[] args) {
        String filename = null;
        int i = 0;
        String name = null;
        if (args == null || args.length > 3) {
            return this.syntaxError();
        }
        this.env = this.getEnv();
        if (this.group == null) {
            this.println("exportfile: group is null");
            return Integer.MAX_VALUE;
        }
        if (!args[0].equals("-f")) {
            return this.syntaxError();
        }
        filename = args[1];
        i = 2;
        if (args.length != i + 1) {
            return this.exportfileStdin(filename);
        }
        name = args[i];
        ShellObject obj = this.env.get(name);
        if (obj == null) {
            this.println("exportfile: cannot access " + name);
            return Integer.MAX_VALUE;
        }
        try {
            if (obj.getObject() instanceof StructuredTextDocument) {
                return this.exportfileStructuredDocument((StructuredTextDocument)obj.getObject(), filename);
            }
            return this.exportfileStructuredDocument((StructuredTextDocument)((Advertisement)obj.getObject()).getDocument(new MimeMediaType("text/xml")), filename);
        }
        catch (Exception e) {
            this.println("exportfile: cannot export this kind of object");
            return Integer.MAX_VALUE;
        }
    }

    private File openFile(String fn) {
        try {
            return new File(fn);
        }
        catch (RuntimeException e) {
            this.println("exportfile: cannot open file " + fn);
            return null;
        }
    }

    private OutputStream getOutput(File f) {
        try {
            return new FileOutputStream(f);
        }
        catch (Exception e) {
            this.println("exportfile: cannot open the file for writing");
            return null;
        }
    }

    private int exportfileStructuredDocument(StructuredTextDocument doc, String fn) {
        File file = this.openFile(fn);
        if (file == null) {
            return 0;
        }
        OutputStream op = this.getOutput(file);
        if (op == null) {
            return 0;
        }
        try {
            doc.sendToStream(op);
            op.close();
        }
        catch (Exception e) {
            this.println("exportfile: I/O error");
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    private int exportfileStdin(String fn) {
        File file = this.openFile(fn);
        if (file == null) {
            return 0;
        }
        OutputStream op = this.getOutput(file);
        if (op == null) {
            return 0;
        }
        try {
            String entry = this.waitForInput();
            do {
                op.write(entry.getBytes());
            } while ((entry = this.pollInput()) != null);
            op.close();
            return 0;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public String getDescription() {
        return "Export to an external file";
    }

    public void help() {
        this.println("NAME");
        this.println("     exportfile - export to an external file ");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     exportfile -f <filename> [<env>]");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'exportfile' exports the content of a Shell environment variable");
        this.println("into an external file. The exported object is stored in the");
        this.println("supplied filename argument.");
        this.println("If no variable name is given, the 'stdin' pipe is used to read");
        this.println("data and saved them into the file.");
        this.println("'exportfile' is the reverse operation of 'importfile'");
        this.println("The Shell environment variable is not deleted after the");
        this.println("the file is created");
        this.println(" ");
        this.println("EXAMPLE");
        this.println("    JXTA> exportfile -f /home/tra/myfile myfile");
        this.println(" ");
        this.println("This command saves into the file '/home/tra/myfile' the content");
        this.println("of the 'myfile' environment variable");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("        importfile ");
    }
}

