/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.env;

import java.util.Enumeration;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;

public class env
extends ShellApp {
    private ShellEnv myEnv;

    private void display(String objName) {
        if (this.myEnv == null) {
            return;
        }
        ShellObject obj = this.myEnv.get(objName);
        if (obj == null) {
            return;
        }
        this.println(objName + " = " + obj.getName() + " (" + obj.getObjectClass().toString() + ")");
    }

    public int startApp(String[] args) {
        this.myEnv = this.getEnv();
        Enumeration enumeration = this.myEnv.elements();
        while (enumeration.hasMoreElements()) {
            try {
                String objName = (String)enumeration.nextElement();
                this.display(objName);
            }
            catch (Exception e) {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public void stopApp() {
    }

    public String getDescription() {
        return "Display environment variable";
    }

    public void help() {
        this.println("NAME");
        this.println("     env  - display environment variable");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     env");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.println("'env' displays all the defined environment");
        this.println("variables in the Shell seesion.");
        this.println(" ");
        this.println("The following environment variables are defined by default:");
        this.println(" consin    = Default Console InputPipe");
        this.println(" consout   = Default Console OutputPipe");
        this.println(" stdout    = Default OutputPipe");
        this.println(" stdin     = Default InputPipe");
        this.println(" Shell     = Root Shell");
        this.println(" stdgroup  = Default peer group");
        this.println(" rootgroup = Default NetPeerGroup");
        this.println(" ");
        this.println("Shell environement variables are defined as a result of executing");
        this.println("Shell commands. The '=' operator can be used to assign");
        this.println("value to a particular variable. For example `myenv = mkmsg` will");
        this.println("assign a new message object to the 'myenv' environment variable");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> env");
        this.println(" ");
        this.println("This command will display all environment variables");
        this.println(" ");
        this.println("SEE ALSO");
        this.println("     setenv Shell");
    }
}

