/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell.bin.Shell;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.shell.GetOpt;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellCmds;
import net.jxta.impl.shell.ShellConsole;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellInputPipe;
import net.jxta.impl.shell.ShellObject;
import net.jxta.impl.shell.ShellOutputPipe;
import net.jxta.impl.shell.bin.history.HistoryQueue;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;

public class Shell
extends ShellApp
implements Runnable {
    public static final String JXTA_SHELL_EMBEDDED_KEY = "JXTA_SHELL_EMBEDDED";
    public static final String ThisShell = "Shell";
    public static final String PromptString = "JXTA>";
    public static final String History = "History";
    public static final String ParentShell = "parentShell";
    private static int shellInstance;
    private boolean gotMyOwnFrame = false;
    private ShellConsole cons = null;
    private Thread thread = null;
    private boolean gotParent = false;
    private ShellEnv parentEnv = null;
    private String shellRootEnvName = null;
    private BufferedReader scriptReader = null;
    private String pipecmd = null;
    private boolean printPrompt = true;
    private boolean embedded = false;
    static /* synthetic */ Class class$net$jxta$impl$shell$bin$Shell$Shell;
    static /* synthetic */ Class class$net$jxta$impl$shell$bin$history$HistoryQueue;

    public Shell() {
    }

    public Shell(boolean embedded) {
        System.setProperty(JXTA_SHELL_EMBEDDED_KEY, "true");
    }

    public boolean isRootShell() {
        return !this.gotParent;
    }

    public ShellConsole getConsole() {
        return this.cons;
    }

    public void init(PeerGroup thisGroup, ID assignedID, Advertisement impl) {
        super.init(thisGroup, assignedID, impl);
    }

    /*
     * WARNING - void declaration
     */
    public int startApp(String[] args) {
        ShellObject old;
        super.startApp(args);
        try {
            int c;
            GetOpt getopt = new GetOpt(args, "sf:");
            block6: while ((c = getopt.getNextOption()) != -1) {
                void var3_4;
                switch (var3_4) {
                    case 102: {
                        if (this.initScriptFile(getopt.getOptionArg())) continue block6;
                        this.println("Shell: cannot access " + args[1]);
                        return Integer.MAX_VALUE;
                    }
                    case 115: {
                        this.gotMyOwnFrame = true;
                        break;
                    }
                    default: {
                        this.println(" Shell : Error -- this should have never happened");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.println("Illegal option");
            this.println("usage : Shell [-f filename] [-s] ");
        }
        if (null != this.getEnv()) {
            this.gotParent = true;
            this.parentEnv = this.getEnv();
            this.setEnv(new ShellEnv(this.parentEnv));
            this.shellRootEnvName = this.parentEnv.createName();
            this.parentEnv.add(this.shellRootEnvName, new ShellObject("Child Shell", this));
            old = this.parentEnv.get(ThisShell);
            if (old != null) {
                this.getEnv().add(ParentShell, old);
            }
            if (old.getObject() != null && (class$net$jxta$impl$shell$bin$Shell$Shell == null ? (class$net$jxta$impl$shell$bin$Shell$Shell = Shell.class$("net.jxta.impl.shell.bin.Shell.Shell")) : class$net$jxta$impl$shell$bin$Shell$Shell).isInstance(old.getObject())) {
                Shell parent = (Shell)old.getObject();
                this.cons = parent.getConsole();
            }
        } else {
            this.gotMyOwnFrame = true;
            this.setEnv(new ShellEnv());
            old = this.getEnv().add("stdgroup", new ShellObject("Default Group", this.group));
        }
        this.getEnv().add(ThisShell, new ShellObject("Root Shell", this));
        this.getEnv().add("SHELL", new ShellObject("Root Shell", this));
        if (this.gotMyOwnFrame) {
            String myName = "JXTA Shell - " + shellInstance++;
            this.cons = new ShellConsole(myName, 30, 80);
            ShellInputPipe defaultInputPipe = new ShellInputPipe(this.group, this.cons);
            this.getEnv().add("stdin", new ShellObject("Default InputPipe", defaultInputPipe));
            this.getEnv().add("consin", new ShellObject("Default Console InputPipe", defaultInputPipe));
            this.setInputPipe(defaultInputPipe);
            this.setInputConsPipe(defaultInputPipe);
            ShellOutputPipe defaultOutputPipe = new ShellOutputPipe(this.group, this.cons);
            this.getEnv().add("stdout", new ShellObject("Default OutputPipe", defaultOutputPipe));
            this.getEnv().add("consout", new ShellObject("Default Console OutputPipe", defaultOutputPipe));
            this.setOutputPipe(defaultOutputPipe);
            this.setOutputConsPipe(defaultOutputPipe);
            this.thread = new Thread((Runnable)this, myName);
            this.thread.start();
            return -1;
        }
        if (this.pipecmd != null) {
            this.processCmd(this.pipecmd);
        } else {
            this.runShell();
        }
        return 0;
    }

    public void stopApp() {
        if (this.parentEnv != null) {
            this.parentEnv.remove(this.shellRootEnvName);
        }
        if (this.gotMyOwnFrame) {
            this.cons.destroy();
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
        super.stopApp();
    }

    public void run() {
        try {
            if (null != this.pipecmd) {
                this.startApp(new String[0]);
            } else {
                this.runShell();
            }
        }
        catch (Throwable all) {
            System.out.flush();
            System.err.println("Uncaught Throwable in thread :" + Thread.currentThread().getName());
            all.printStackTrace(System.err);
        }
    }

    private void initPipe(ShellEnv penv, String cmd) {
        String myName = "JXTA Shell - " + shellInstance++;
        this.setEnv(penv);
        this.pipecmd = cmd;
        this.thread = new Thread((Runnable)this, myName);
        this.thread.start();
    }

    private void runShell() {
        if (this.scriptReader == null) {
            this.consprintln("=========================================================");
            this.consprintln("========= Welcome to the JXTAShell  Version 1.0 =========");
            this.consprintln("=========================================================");
            this.info();
        }
        this.startupFile();
        while (true) {
            String cmd = null;
            if (this.stopped) break;
            try {
                if (this.scriptReader == null) {
                    if (this.printPrompt) {
                        this.consprint(PromptString);
                    }
                    cmd = this.waitForInput();
                } else {
                    cmd = this.scriptReader.readLine();
                }
                if (cmd == null) {
                    return;
                }
            }
            catch (IOException e) {
                System.err.println("Shell is reconnecting to console");
                this.setInputPipe(this.consin);
            }
            this.processMultipleCmd(cmd);
        }
    }

    private boolean initScriptFile(String fn) {
        try {
            this.scriptReader = new BufferedReader(new FileReader(fn));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void startupFile() {
        try {
            BufferedReader scriptReader = new BufferedReader(new FileReader(".jshrc"));
            if (scriptReader == null) {
                return;
            }
            String cmd = scriptReader.readLine();
            while (cmd != null) {
                this.processMultipleCmd(cmd);
                cmd = scriptReader.readLine();
            }
            scriptReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processMultipleCmd(String cmd) {
        StringTokenizer tokens = new StringTokenizer(cmd, ";");
        HistoryQueue queue = this.getHistoryQueue();
        this.printPrompt = true;
        if (queue != null) {
            queue.addCommand(cmd);
        }
        while (tokens.hasMoreElements()) {
            this.processPipeCmd(tokens.nextToken());
        }
    }

    private HistoryQueue getHistoryQueue() {
        String[] exclude;
        ShellObject obj = this.getEnv().get(History);
        HistoryQueue queue = null;
        if (obj != null) {
            Object object;
            if ((class$net$jxta$impl$shell$bin$history$HistoryQueue == null ? (class$net$jxta$impl$shell$bin$history$HistoryQueue = Shell.class$("net.jxta.impl.shell.bin.history.HistoryQueue")) : class$net$jxta$impl$shell$bin$history$HistoryQueue).isInstance(object = obj.getObject())) {
                queue = (HistoryQueue)object;
            }
        } else if (this.cons != null && (exclude = new String[]{this.cons.getCursorDownName(), this.cons.getCursorUpName()})[0] != null && exclude[1] != null) {
            queue = new HistoryQueue(exclude);
            this.getEnv().add(History, new ShellObject(History, queue));
        }
        return queue;
    }

    private void processPipeCmd(String cmd) {
        Vector<String> cmds = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(cmd, "|");
        while (tokens.hasMoreElements()) {
            cmds.addElement(tokens.nextToken());
        }
        PeerGroup pg = (PeerGroup)this.getEnv().get("stdgroup").getObject();
        InputPipe stdin = (InputPipe)this.getEnv().get("stdin").getObject();
        OutputPipe stdout = (OutputPipe)this.getEnv().get("stdout").getObject();
        InputPipe pipein = null;
        OutputPipe pipeout = null;
        InputPipe lastin = stdin;
        Thread willDependOn = null;
        int i = 0;
        while (i < cmds.size() - 1) {
            PipeAdvertisement padv = null;
            try {
                padv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
                padv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)pg.getPeerGroupID()));
                pipein = this.pipes.createInputPipe(padv);
                pipeout = this.pipes.createOutputPipe(padv, -1L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            ShellEnv pipeenv = new ShellEnv(this.getEnv());
            pipeenv.add("stdout", new ShellObject("Default OutputPipe", pipeout));
            pipeenv.add("stdin", new ShellObject("Default InputPipe", lastin));
            pipeenv.add("stdgroup", new ShellObject("Default Peer Group", pg));
            Shell pipeShell = (Shell)this.loadApp(null, ThisShell, pipeenv);
            pipeShell.dependsOn = willDependOn;
            pipeShell.initPipe(pipeenv, (String)cmds.elementAt(i));
            willDependOn = pipeShell.thread;
            lastin = pipein;
            ++i;
        }
        this.getEnv().add("stdout", new ShellObject("Default OutputPipe", stdout));
        ShellObject oldin = this.getEnv().get("stdin");
        this.getEnv().add("stdin", new ShellObject("Default InputPipe", lastin));
        this.dependsOn = willDependOn;
        this.processCmd((String)cmds.lastElement());
        this.dependsOn = null;
        this.getEnv().add("stdin", oldin);
    }

    private void processCmd(String cmd) {
        String app;
        this.currentcmdline = new String(cmd);
        int index = cmd.indexOf("=");
        String var = null;
        if (index > 0) {
            var = cmd.substring(0, index).trim();
            cmd = cmd.substring(index + 1);
        }
        if (this.getEnv().contains("echo")) {
            this.consprintln(cmd);
        }
        if ((app = this.getAppName(cmd)) == null) {
            return;
        }
        String[] args = this.oldCommandParser(cmd);
        ShellApp appl = this.loadApp(var, app, this.getEnv());
        if (null != appl) {
            this.run(appl, args);
        }
    }

    private String[] newCommandParser(String cmd) {
        return null;
    }

    private String getAppName(String cmd) {
        String appname;
        StringTokenizer st = new StringTokenizer(cmd);
        try {
            appname = st.nextToken();
        }
        catch (Exception e) {
            appname = null;
        }
        return appname;
    }

    private String[] oldCommandParser(String cmd) {
        StringTokenizer tokens = new StringTokenizer(cmd);
        int size = tokens.countTokens();
        if (size < 1) {
            return null;
        }
        String[] args = new String[size - 1];
        tokens.nextToken();
        int index = 0;
        try {
            while (tokens.hasMoreElements()) {
                args[index] = tokens.nextToken();
                ++index;
            }
        }
        catch (Exception e) {
            return null;
        }
        return args;
    }

    private ShellApp loadApp(String var, String appName, ShellEnv env2) {
        ShellApp app = null;
        if (this.cons != null) {
            if (appName.equals("clear")) {
                this.cons.clear();
                return null;
            }
            if (appName.equals(this.cons.getCursorUpName())) {
                HistoryQueue queue = this.getHistoryQueue();
                if (queue != null) {
                    this.cons.setCommandLine(null, queue.getNextCommand());
                }
                this.printPrompt = false;
                return null;
            }
            if (appName.equals(this.cons.getCursorDownName())) {
                HistoryQueue queue = this.getHistoryQueue();
                if (queue != null) {
                    this.cons.setCommandLine(null, queue.getPreviousCommand());
                }
                this.printPrompt = false;
                return null;
            }
            if (appName.startsWith("!")) {
                try {
                    int number = Integer.valueOf(appName.substring(1));
                    HistoryQueue queue = this.getHistoryQueue();
                    if (queue != null) {
                        queue.removeLastCommand();
                        this.cons.setCommandLine(PromptString, queue.getCommand(number));
                        this.printPrompt = false;
                        return null;
                    }
                }
                catch (Exception iox) {
                    // empty catch block
                }
            }
        }
        this.printPrompt = true;
        try {
            int periodAt = appName.lastIndexOf(46);
            String appLeafName = 0 != periodAt ? appName.substring(periodAt + 1) : appName;
            ShellCmds cmds = new ShellCmds(this);
            app = cmds.getInstance(appLeafName);
            app.setEnv(env2);
            app.dependsOn = this.dependsOn;
            app.setInputConsPipe(this.getInputConsPipe());
            app.setOutputConsPipe(this.getOutputConsPipe());
            ShellObject obj = env2.get("stdin");
            app.setInputPipe((InputPipe)obj.getObject());
            obj = env2.get("stdout");
            app.setOutputPipe((OutputPipe)obj.getObject());
            app.setReturnVariable(var);
        }
        catch (Throwable e) {
            this.println("command not found '" + appName + "'");
            return null;
        }
        app.init((PeerGroup)env2.get("stdgroup").getObject(), null, null);
        return app;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(ShellApp app, String[] args) {
        try {
            int result = app.startApp(args);
            if (0 != result && -1 == result) return;
        }
        catch (Throwable e) {
            this.println("Exception in command.");
            StringWriter theStackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(theStackTrace));
            this.print(theStackTrace.toString());
            this.println(" ");
        }
    }

    public String getDescription() {
        return "JXTA Shell command interpreter";
    }

    public void help() {
        this.println("NAME");
        this.println("     Shell  - JXTA Shell command interpreter");
        this.println(" ");
        this.println("SYNOPSIS");
        this.println(" ");
        this.println("     Shell [-f filename] [-s] ");
        this.println(" ");
        this.println("DESCRIPTION");
        this.println(" ");
        this.info();
        this.println(" ");
        this.println(" ");
        this.println("Every Shell command is of the form <cmd>;..;<cmd>. The ';'");
        this.println("is used as command separator. Multiple commands can be entered");
        this.println("in one line. Pipelines can be created by combining the pipe stdout");
        this.println("of a command into the pipe stdin of another command using the");
        this.println("pipe '|' operator. For example the following command:");
        this.println(" ");
        this.println("      JXTA> cat env1 | more");
        this.println(" ");
        this.println("PipeServiceService the output of the command 'cat' into the stdin of the command");
        this.println("'more'. Arbitrary number of commands can be pipelined together within");
        this.println("a single Shell command. Currently '|' is the only pipe operator");
        this.println("supported.");
        this.println(" ");
        this.println("The '=' operator can be used to assign the value of a command ");
        this.println("output to an environment variable. For example :");
        this.println(" ");
        this.println("      JXTA> myadv = mkadv -p");
        this.println(" ");
        this.println("This command creates a new pipe advertisement and stores it in the");
        this.println("'myadv' environment variable.");
        this.println(" ");
        this.println("COMMANDS");
        this.println(" ");
        this.println("The Shell provides the following commands:");
        this.println(" ");
        this.println(" cat        Display the content of an environment variable");
        this.println(" chpgrp     Change the default peer group");
        this.println(" clear      Clear the shell's screen");
        this.println(" env        Display all environment variables ");
        this.println(" exit       Exit the Shell ");
        this.println(" exportfile Export a Shell variable into an external file");
        this.println(" get        Extract a message tag body from a pipe messsage ");
        this.println(" grep       Search for matching patterns");
        this.println(" groups     Discover and list peer groups ");
        this.println(" man        use man to display man pages about commands");
        this.println(" importfile Import an external file into a Shell variable");
        this.println(" join       Join a new peer group");
        this.println(" leave      Leave a peer group");
        this.println(" man        On-line man page about commands ");
        this.println(" mkadv      Make a new pipe or peer group advertisement  ");
        this.println(" mkmsg      Make a new pipe message");
        this.println(" mkpgrp     make a new peer group ");
        this.println(" mkpipe     Make a new pipe ");
        this.println(" more       Browse or page through a Shell object ");
        this.println(" peerconfig Peer configuration");
        this.println(" peerinfo   Get information about peers");
        this.println(" peers      Discover and list peers");
        this.println(" put        Put a new tag body into a pipe message");
        this.println(" recv       Receive a pipe message");
        this.println(" rdvstatus  Show connected rendezvous");
        this.println(" search     Search a shared advertisement in a peer group");
        this.println(" send       Send a pipe message");
        this.println(" setenv     Set the value of an environment variable");
        this.println(" share      Share an advertisement in a peer group");
        this.println(" Shell      Fork a new Shell");
        this.println(" talk       Instant messaging talk command");
        this.println(" version    Display version and build info");
        this.println(" wc         Count lines, words, and characters");
        this.println(" who        Display member identity in a peer group");
        this.println(" whoami     Display peer and peer group information");
        this.println(" ");
        this.println("OPTIONS");
        this.println(" ");
        this.println("    [-f filename] execute the script file");
        this.println("    [-s] fork a new Shell console in a new window");
        this.println(" ");
        this.println("EXAMPLE");
        this.println(" ");
        this.println("    JXTA> Shell -f /home/tra/batch");
        this.println(" ");
        this.println("This command executes the commands stored in the Shell script");
        this.println("file '/home/tra/myfile' in the current Shell environment.");
        this.println(" ");
        this.println("ENVIRONMENT");
        this.println(" ");
        this.println("The Java implementation of 'Shell' uses two system properties");
        this.println("to configure the use of graphics:");
        this.println(" SHELLNOWINDOW - if 'true' then no AWT window is created.");
        this.println(" SHELLFONTSIZE - Size in points for the font used in graphics window.");
        this.println(" ");
        this.println("The following environment variables are defined by default:");
        this.println(" consin    = Default Console InputPipe");
        this.println(" consout   = Default Console OutputPipe");
        this.println(" stdout    = Default OutputPipe");
        this.println(" stdin     = Default InputPipe");
        this.println(" Shell     = Root Shell");
        this.println(" stdgroup  = Default peer group");
        this.println(" rootgroup = Default NetPeerGroup");
        this.println(" ");
        this.println("FILES");
        this.println(" ");
        this.println("  $HOME/.jshrc");
        this.println(" ");
        this.println("       a default startup script can be setup that is executed");
        this.println("       when the Shell is invoked");
        this.println(" ");
        this.println("SEE ALSO");
    }

    public void info() {
        this.println(" ");
        this.println("The JXTA Shell provides an interactive environment to the JXTA    ");
        this.println("platform. The Shell provides basic commands to discover peers and  ");
        this.println("peergroups, to join and resign from peergroups, to create pipes");
        this.println("between peers, and to send pipe messages. The Shell provides environment ");
        this.println("variables that permit binding symbolic names to Jxta platform objects.      ");
        this.println("Environment variables allow Shell commands to exchange data between ");
        this.println("themselves. The shell command 'env' displays all defined environment ");
        this.println("variables in the current Shell session.");
        this.println(" ");
        this.println("The Shell creates a Jxta InputPipe (stdin) for reading input from ");
        this.println("the keyboard, and a Jxta OutputPipe (stdout) to display information");
        this.println("on the Shell console. All commands executed by the Shell have their");
        this.println("initial 'stdin' and 'stdout' set up to the Shell's stdin and stdout pipes.");
        this.println("The Shell also creates the environment variable 'stdgroup' that   ");
        this.println("contains the current JXTA PeerGroup in which the Shell and commands ");
        this.println("are executed.");
        this.println(" ");
        this.println("A new Shell can be forked within a Shell. The 'Shell -s'");
        this.println("command starts a new Shell with a new Shell window. The Shell can");
        this.println("also read a command script file via the 'Shell -f myfile'.");
        this.println(" ");
        this.println("A 'man' command is available to list the commands available.");
        this.println("Type 'man <command>' to get help about a particular command.");
        this.println("To exit the Shell, use the 'exit' command.");
    }

    public static boolean isEmbedded() {
        String value = System.getProperty(JXTA_SHELL_EMBEDDED_KEY);
        return value != null && value.equals("true");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JXTA_SHELL_EMBEDDED_KEY = JXTA_SHELL_EMBEDDED_KEY;
        ThisShell = ThisShell;
        PromptString = PromptString;
        History = History;
        ParentShell = ParentShell;
        shellInstance = 1;
    }
}

