/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class ZipClassLoader
extends ClassLoader {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$shell$ZipClassLoader == null ? (class$net$jxta$impl$shell$ZipClassLoader = ZipClassLoader.class$("net.jxta.impl.shell.ZipClassLoader")) : class$net$jxta$impl$shell$ZipClassLoader).getName());
    private static final int BUFFER_SIZE = 4096;
    protected Vector rcList;
    static /* synthetic */ Class class$net$jxta$impl$shell$ZipClassLoader;

    public ZipClassLoader(Vector fileList, ClassLoader parent) {
        super(parent);
        this.rcList = ZipClassLoader.convertToResourceContainers(fileList);
    }

    protected void add(ResourceContainer c) {
        this.rcList.addElement(c);
    }

    protected void remove(ResourceContainer c) {
        this.rcList.removeElement(c);
    }

    protected static Vector convertToResourceContainers(Vector fileList) {
        Vector<ResourceContainer> rcList = new Vector<ResourceContainer>(fileList.size());
        Enumeration e = fileList.elements();
        while (e.hasMoreElements()) {
            File f = (File)e.nextElement();
            try {
                rcList.addElement(ZipClassLoader.createResourceContainer(f));
            }
            catch (IOException ex) {
                if (!LOG.isEnabledFor(Priority.WARN)) continue;
                LOG.warn((Object)"Error occured", (Throwable)ex);
            }
        }
        return rcList;
    }

    protected static ResourceContainer createResourceContainer(File rscFile) throws IOException {
        if (rscFile.isDirectory()) {
            return new DirResourceContainer(rscFile);
        }
        return new ZipResourceContainer(new ZipFile(rscFile, 1));
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        try {
            Class<?> resultClass = super.loadClass(className, false);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Found system class '" + className + "'"));
            }
            return resultClass;
        }
        catch (ClassNotFoundException e) {
            byte[] classBytes = this.loadClassBytes(className);
            Class<?> resultClass = this.defineClass(className, classBytes, 0, classBytes.length);
            if (resultClass == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(resultClass);
            }
            return resultClass;
        }
    }

    protected byte[] loadClassBytes(String className) throws ClassNotFoundException {
        String classFileName = className.replace('.', '/') + ".class";
        byte[] classBytes = this.loadResourceBytes(classFileName);
        if (classBytes == null) {
            throw new ClassNotFoundException("class " + className);
        }
        return classBytes;
    }

    protected byte[] loadResourceBytes(String name) {
        block3: {
            Resource rsc = this.searchResource(name);
            try {
                if (rsc != null) {
                    return this.readBytes(rsc.getInputStream());
                }
            }
            catch (IOException ex) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)("Error occured while reading resource '" + rsc + "'"), (Throwable)ex);
            }
        }
        return null;
    }

    private byte[] readBytes(InputStream inStream) throws IOException {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(4096);
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = inStream.read(buffer);
            if (bytesRead == -1) continue;
            byteArray.write(buffer, 0, bytesRead);
        }
        byteArray.close();
        inStream.close();
        return byteArray.toByteArray();
    }

    public Enumeration searchResources(String path) {
        Vector rscList = new Vector();
        ZipClassLoader.searchResources(this.rcList, path, rscList);
        return rscList.elements();
    }

    protected static void searchResources(Vector rcList, String path, Vector rscList) {
        Enumeration e = rcList.elements();
        while (e.hasMoreElements()) {
            ResourceContainer rc = (ResourceContainer)e.nextElement();
            Enumeration rs = rc.findResources(path);
            while (rs.hasMoreElements()) {
                Resource rsc = (Resource)rs.nextElement();
                rscList.addElement(rsc);
            }
        }
    }

    public Resource searchResource(String name) {
        return ZipClassLoader.searchResource(this.rcList, name);
    }

    protected static Resource searchResource(Vector rcList, String name) {
        Enumeration e = rcList.elements();
        while (e.hasMoreElements()) {
            ResourceContainer c = (ResourceContainer)e.nextElement();
            Resource rsc = c.findResource(name);
            if (rsc == null) continue;
            return rsc;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BUFFER_SIZE = 4096;
    }

    static final class ZipResourceContainer
    extends ResourceContainer {
        ZipFile zipFile;

        public ZipResourceContainer(ZipFile zf) {
            this.zipFile = zf;
        }

        public String getName() {
            return this.zipFile.getName();
        }

        public Resource findResource(String name) {
            ZipEntry ze;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Searching zip-file '" + this.zipFile.getName() + "' for resources: name='" + name + "'"));
            }
            if ((ze = this.zipFile.getEntry(name)) != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Found entry: " + ze));
                }
                return new ZipResource(this, ze);
            }
            return null;
        }

        public Enumeration findResources(String path) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Searching zip-file '" + this.zipFile.getName() + "' for resources: path='" + path + "'"));
            }
            Vector<ZipResource> rscList = new Vector<ZipResource>();
            ZipEntry pathEntry = this.zipFile.getEntry(path);
            if (pathEntry == null) {
                return rscList.elements();
            }
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (!ze.getName().startsWith(path)) continue;
                rscList.addElement(new ZipResource(this, ze));
                if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                LOG.debug((Object)("Found entry: " + ze));
            }
            return rscList.elements();
        }

        public ZipFile getZipFile() {
            return this.zipFile;
        }
    }

    static final class DirResourceContainer
    extends ResourceContainer {
        File dir;

        public DirResourceContainer(File f) {
            if (!f.isDirectory()) {
                throw new IllegalArgumentException("'" + f + "' is not a directory");
            }
            this.dir = f;
        }

        public String getName() {
            return this.dir.getPath();
        }

        public Resource findResource(String name) {
            File f;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Searching directory '" + this.dir + "' for resource: name='" + name + "'"));
            }
            if ((f = new File(this.dir, name)).exists()) {
                if (f.isFile()) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Found file: " + name));
                    }
                } else {
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("Found directory: " + name));
                    }
                }
                return new FileResource(this, name);
            }
            return null;
        }

        public Enumeration findResources(String path) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Searching directory '" + this.dir + "' for resources: path='" + path + "'"));
            }
            File rootDir = new File(this.dir, path);
            Vector rscList = new Vector();
            if (rootDir.isDirectory() && rootDir.exists()) {
                this.listResources(path, rscList);
            }
            return rscList.elements();
        }

        private void listResources(String path, Vector rscList) {
            File root = new File(this.dir, path);
            if (!root.exists()) {
                return;
            }
            if (root.isFile()) {
                rscList.addElement(new FileResource(this, path));
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Found file: " + path));
                }
            } else {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Found directory: " + path));
                }
                rscList.addElement(new FileResource(this, path));
                String[] rootDirList = root.list();
                int i = 0;
                while (i < rootDirList.length) {
                    this.listResources(path + rootDirList[i], rscList);
                    ++i;
                }
            }
        }

        public File getDir() {
            return this.dir;
        }
    }

    static final class ZipResource
    extends Resource {
        private ZipEntry zipEntry;

        public ZipResource(ZipResourceContainer c, ZipEntry e) {
            super(c);
            this.zipEntry = e;
        }

        public String getName() {
            return this.zipEntry.getName();
        }

        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        public InputStream getInputStream() throws IOException {
            return ((ZipResourceContainer)this.container).getZipFile().getInputStream(this.zipEntry);
        }
    }

    static final class FileResource
    extends Resource {
        private String name;

        FileResource(DirResourceContainer c, String fn) {
            super(c);
            this.name = fn;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return this.absFile().isDirectory();
        }

        private File absFile() {
            return new File(((DirResourceContainer)this.container).getDir(), this.name);
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.absFile());
        }
    }

    public static abstract class Resource {
        protected ResourceContainer container;

        protected Resource(ResourceContainer c) {
            this.container = c;
        }

        public ResourceContainer getResourceContainer() {
            return this.container;
        }

        public abstract String getName();

        abstract boolean isDirectory();

        public abstract InputStream getInputStream() throws IOException;

        public String toString() {
            return "rc=" + this.container.getName() + ", rsc=" + this.getName();
        }

        public boolean equals(Object o) {
            if (o instanceof Resource) {
                Resource rsc = (Resource)o;
                return this.container.equals(rsc.container) && this.getName().equals(rsc.getName());
            }
            return false;
        }
    }

    public static abstract class ResourceContainer {
        public abstract String getName();

        public abstract Resource findResource(String var1);

        public abstract Enumeration findResources(String var1);
    }
}

