/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import java.util.Vector;
import net.jxta.endpoint.Message;

public class ShellMessageQueue {
    public static final int Max_Messages = 100;
    private Vector queue = new Vector(100);
    private boolean closeFlag = false;

    public synchronized void push(Message message) {
        if (this.closeFlag) {
            return;
        }
        this.queue.addElement(message);
        this.notifyAll();
    }

    public synchronized Message next() {
        if (this.queue.isEmpty()) {
            return null;
        }
        Message result = (Message)this.queue.firstElement();
        this.queue.removeElementAt(0);
        return result;
    }

    public synchronized Message poll(long timeOut) throws InterruptedException {
        if (timeOut < 0L) {
            throw new IllegalArgumentException("timeOut must be >= 0");
        }
        long realTimeOut = System.currentTimeMillis() + timeOut;
        do {
            Message result;
            if (null != (result = this.next())) {
                return result;
            }
            if (this.isClosed()) continue;
            this.wait(timeOut);
            result = this.next();
            if (null != result) {
                return result;
            }
            if (0L != timeOut && (timeOut = realTimeOut - System.currentTimeMillis()) <= 0L) break;
        } while (!this.isClosed());
        return null;
    }

    public Message waitForMessage() throws InterruptedException {
        return this.poll(0L);
    }

    public synchronized boolean isClosed() {
        return this.closeFlag;
    }

    public synchronized void close() {
        this.closeFlag = true;
        this.notifyAll();
    }

    public int getMaxNbOfMessages() {
        return this.queue.capacity();
    }

    public synchronized void setMaxNbOfMessages(int maxMsgs) {
        this.queue.ensureCapacity(maxMsgs);
    }

    static {
        Max_Messages = 100;
    }
}

