/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.impl.shell.ShellObject;

public final class ShellEnv {
    private Hashtable table;
    private int random;

    public ShellEnv() {
        this.table = new Hashtable();
        this.random = 1;
    }

    public ShellEnv(ShellEnv srcEnv) {
        this.table = (Hashtable)srcEnv.table.clone();
        this.random = srcEnv.random;
    }

    public synchronized String createName() {
        return "env" + Integer.toString(this.random++);
    }

    public synchronized ShellObject add(ShellObject obj) {
        return this.add(null, obj);
    }

    public synchronized ShellObject add(String name, ShellObject obj) {
        if (obj == null) {
            return null;
        }
        if (name == null) {
            name = this.createName();
        }
        try {
            ShellObject old = this.table.put(name, obj);
            return old;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized ShellObject get(String name) {
        if (name == null) {
            return null;
        }
        return (ShellObject)this.table.get(name);
    }

    public synchronized boolean contains(String name) {
        return this.table.containsKey(name);
    }

    public synchronized boolean contains(ShellObject obj) {
        return this.table.contains(obj);
    }

    public synchronized boolean rename(String oldName, String newName) {
        if (this.contains(newName)) {
            return false;
        }
        if (this.contains(oldName)) {
            Object obj = this.table.remove(oldName);
            try {
                Object old = this.table.put(newName, obj);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public synchronized boolean remove(String name) {
        return this.table.remove(name) != null;
    }

    public synchronized Enumeration elements() {
        return this.table.keys();
    }

    public String toString() {
        return this.table.toString();
    }
}

