/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import net.jxta.impl.shell.bin.Shell.Shell;

public class ShellConsole
implements Runnable,
KeyListener,
MouseListener {
    private static final int MAX_LINE = 256;
    private static volatile int wNumber;
    private static final String NOWINDOWFILENAME = "nowindow";
    private static final String NOWINDOWPROPNAME = "SHELLNOWINDOW";
    private TextArea text = null;
    private OutputStream opipe;
    private InputStream ipipe;
    private BufferedReader stdin = null;
    private BufferedWriter stdout = null;
    private StringBuffer line = new StringBuffer();
    private int textLength = 0;
    private int lineInsert = 0;
    private Frame f = null;
    private Thread thread = null;
    private String consoleName = null;

    public ShellConsole(int rows, int cols) {
        this("JXTA Shell", rows, cols);
    }

    public ShellConsole(String useName, int rows, int cols) {
        InputStream in = null;
        PrintStream out = null;
        this.consoleName = useName;
        boolean windowMode = true;
        if (windowMode) {
            boolean bl = windowMode = !Boolean.getBoolean(NOWINDOWPROPNAME);
        }
        if (windowMode) {
            try {
                this.text = new TextArea(null, rows, cols, 1);
                ++wNumber;
                int fontsize = 12;
                String fontsizeProp = System.getProperty("SHELLFONTSIZE");
                if (fontsizeProp != null) {
                    try {
                        fontsize = Integer.valueOf(fontsizeProp);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                this.text.setFont(new Font("DialogInput", 0, fontsize));
                this.text.setEditable(true);
                this.text.addKeyListener(this);
                this.text.addMouseListener(this);
                try {
                    this.opipe = new PipedOutputStream();
                    in = new PipedInputStream((PipedOutputStream)this.opipe);
                    PipedOutputStream pout = new PipedOutputStream();
                    out = new PrintStream(pout);
                    this.ipipe = new PipedInputStream(pout);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.thread = new Thread((Runnable)this, "JXTA Console-" + this.consoleName);
                this.thread.start();
                this.text.requestFocus();
                this.f = new Frame(this.consoleName);
                this.f.add((Component)this.text, "Center");
                this.f.pack();
                this.f.setLocation(wNumber * 15, wNumber * 15);
                this.f.setVisible(true);
                this.f.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        ShellConsole.this.f.dispose();
                        wNumber--;
                        if (wNumber <= 0 && !Shell.isEmbedded()) {
                            System.exit(0);
                        }
                    }
                });
            }
            catch (InternalError error) {
                windowMode = false;
            }
        }
        if (!windowMode) {
            in = System.in;
            out = System.out;
        }
        this.stdin = new BufferedReader(new InputStreamReader(in));
        this.stdout = new BufferedWriter(new OutputStreamWriter(out));
    }

    public String getConsoleName() {
        return this.consoleName;
    }

    public void destroy() {
        this.thread.interrupt();
        this.f.dispose();
    }

    public void keyPressed(KeyEvent e) {
        int val = e.getKeyCode();
        char ch = e.getKeyChar();
        int mod = e.getModifiers();
        this.text.setEditable(true);
        boolean ctrlDown = false;
        if ((mod & 2) > 0) {
            ctrlDown = true;
        }
        if (ctrlDown && val == 67) {
            return;
        }
        if (ctrlDown && val == 86) {
            this.paste();
            return;
        }
        if (ctrlDown && val == 68) {
            System.out.println("Control-D pressed, bye bye, have a nice day!");
            this.line.append("exit");
            this.readme(true);
            return;
        }
        if (ctrlDown && val == 76) {
            this.line.append("clear");
            this.readme(true);
            return;
        }
        this.handling(val, ch, mod);
        e.consume();
    }

    public void handling(int val, char ch, int modifiers) {
        switch (val) {
            case 8: {
                if (this.line.length() <= 0 || this.lineInsert < 1 || this.lineInsert > this.line.length()) break;
                String tmpLine = new String(this.line);
                this.line.setLength(this.lineInsert - 1);
                this.line.append(tmpLine.substring(this.lineInsert));
                --this.lineInsert;
                if (this.lineInsert < 0) {
                    this.lineInsert = 0;
                }
                this.text.replaceRange(this.line.toString(), this.textLength, this.textLength + this.line.length() + 1);
                this.text.setCaretPosition(this.textLength + this.lineInsert);
                break;
            }
            case 127: {
                if (this.line.length() <= 0 || this.lineInsert >= this.line.length()) break;
                String tmpLine = new String(this.line);
                this.line.setLength(this.lineInsert);
                this.line.append(tmpLine.substring(this.lineInsert + 1));
                this.text.replaceRange(this.line.toString(), this.textLength, this.textLength + this.line.length() + 1);
                this.text.setCaretPosition(this.textLength + this.lineInsert);
                break;
            }
            case 10: {
                this.readme(true);
                break;
            }
            case 85: {
                if ((modifiers & 2) > 0) {
                    int len = this.line.length();
                    this.text.replaceRange("", this.textLength, this.textLength + len);
                    this.line.setLength(0);
                    this.textLength = this.text.getText().length();
                    this.lineInsert = 0;
                    break;
                }
                this.process(ch);
                break;
            }
            case 37: 
            case 226: {
                --this.lineInsert;
                if (this.lineInsert < 0) {
                    this.lineInsert = 0;
                }
                this.text.setCaretPosition(this.textLength + this.lineInsert);
                break;
            }
            case 39: 
            case 227: {
                ++this.lineInsert;
                if (this.lineInsert > this.line.length()) {
                    this.lineInsert = this.line.length();
                }
                this.text.setCaretPosition(this.textLength + this.lineInsert);
                break;
            }
            case 38: 
            case 224: {
                int len = this.line.length();
                this.line.setLength(0);
                this.text.replaceRange(this.line.toString(), this.textLength, this.textLength + len);
                this.line.append(KeyEvent.getKeyText(38));
                this.readme(false);
                break;
            }
            case 40: 
            case 225: {
                int len = this.line.length();
                this.line.setLength(0);
                this.text.replaceRange(this.line.toString(), this.textLength, this.textLength + len);
                this.line.append(KeyEvent.getKeyText(40));
                this.readme(false);
                break;
            }
            default: {
                this.process(ch);
            }
        }
    }

    private void process(char ch) {
        if (ch >= ' ' && ch <= '~') {
            int max = this.text.getText().length();
            this.line.insert(this.lineInsert, ch);
            ++this.lineInsert;
            this.text.replaceRange(this.line.toString(), this.textLength, max);
            this.text.setCaretPosition(this.textLength + this.lineInsert);
        }
    }

    private void process(String str) {
        int max = this.text.getText().length();
        this.line.insert(this.lineInsert, str);
        this.lineInsert += str.length();
        this.text.replaceRange(this.line.toString(), this.textLength, max);
        this.text.setCaretPosition(this.textLength + this.lineInsert);
    }

    public synchronized void setCommandLine(String prompt, String cmd) {
        if (this.text != null) {
            int len = this.line.length();
            int max = this.text.getText().length();
            if (prompt != null) {
                this.text.replaceRange(prompt, this.textLength, max);
                max = this.textLength = this.text.getText().length();
                len = 0;
            }
            this.line.setLength(0);
            this.line.append(cmd);
            this.lineInsert = this.line.length();
            this.text.replaceRange(this.line.toString(), this.textLength, max);
            this.text.setCaretPosition(this.textLength + this.lineInsert);
        }
    }

    private synchronized void readme(boolean appendNewLine) {
        int len = this.line.length();
        this.line.append('\n');
        try {
            this.opipe.write(this.line.toString().getBytes());
            this.opipe.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.line.setLength(0);
        this.lineInsert = 0;
        if (appendNewLine) {
            this.text.append("\n");
            this.textLength = this.text.getText().length();
        }
        this.text.setCaretPosition(this.textLength + this.lineInsert);
    }

    private void paste() {
        Clipboard cb = this.text.getToolkit().getSystemClipboard();
        Transferable trans = cb.getContents(this);
        if (trans == null) {
            return;
        }
        String cbText = null;
        try {
            cbText = (String)trans.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            return;
        }
        if (cbText == null) {
            return;
        }
        String strLine = "";
        int i = 0;
        while (i < cbText.length()) {
            char ch = cbText.charAt(i);
            if (ch == '\n') {
                this.process(strLine);
                strLine = "";
                this.readme(true);
                if (i + 1 < cbText.length()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            } else {
                strLine = strLine + String.valueOf(ch);
            }
            ++i;
        }
        if (strLine.length() > 0) {
            this.process(strLine);
        }
    }

    public synchronized void print(String s) {
        this.text.append(s);
        this.textLength = this.text.getText().length();
        this.text.setCaretPosition(Integer.MAX_VALUE);
    }

    public synchronized void println(String s) {
        this.print(s + "\n");
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        try {
            int read;
            byte[] buff = new byte[256];
            while ((read = this.ipipe.read(buff)) != -1) {
                void var2_3;
                this.print(new String(buff, 0, (int)var2_3));
            }
        }
        catch (IOException e) {
        }
        catch (Throwable all) {
            System.out.flush();
            System.err.println("Uncaught Throwable in thread :" + Thread.currentThread().getName());
            all.printStackTrace(System.err);
            return;
        }
    }

    public String read() {
        try {
            return this.stdin.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void write(String msg) {
        try {
            this.stdout.write(msg);
            this.stdout.flush();
        }
        catch (Exception ex) {
            System.err.println("Error=" + this.textLength + msg.length());
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public synchronized void clear() {
        if (this.text == null) {
            return;
        }
        this.text.replaceRange("", 0, this.text.getText().length());
        this.text.setCaretPosition(Integer.MAX_VALUE);
        this.textLength = 0;
        this.line.setLength(0);
        this.lineInsert = 0;
        this.text.setCaretPosition(this.textLength + this.lineInsert);
    }

    public void mouseClicked(MouseEvent e) {
        this.text.setEditable(false);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.text.setEditable(false);
    }

    public void mouseReleased(MouseEvent e) {
        this.text.setEditable(false);
    }

    public String getCursorUpName() {
        if (this.text != null) {
            return KeyEvent.getKeyText(38);
        }
        return null;
    }

    public String getCursorDownName() {
        if (this.text != null) {
            return KeyEvent.getKeyText(40);
        }
        return null;
    }

    static {
        MAX_LINE = 256;
        wNumber = 0;
        NOWINDOWFILENAME = NOWINDOWFILENAME;
        NOWINDOWPROPNAME = NOWINDOWPROPNAME;
    }
}

