/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import net.jxta.impl.shell.ShellApp;
import net.jxta.impl.shell.ShellCmdLoader;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.impl.shell.ShellObject;
import net.jxta.impl.shell.ZipClassLoader;
import org.apache.log4j.Category;

public final class ShellCmds {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$shell$ShellCmds == null ? (class$net$jxta$impl$shell$ShellCmds = ShellCmds.class$("net.jxta.impl.shell.ShellCmds")) : class$net$jxta$impl$shell$ShellCmds).getName());
    public static final String INST_JARS = "instjars";
    public static final String PATH_SEPARATOR;
    static final String BIN_PACKAGE = "net.jxta.impl.shell.bin";
    static final String BIN_PATH = "net/jxta/impl/shell/bin/";
    static final int BIN_PATH_LEN;
    private final ShellApp app;
    static /* synthetic */ Class class$net$jxta$impl$shell$ShellCmds;

    public ShellCmds(ShellApp shellApp) {
        this.app = shellApp;
    }

    public static Vector decodeInstJars(String instJars) {
        Vector<File> pathList = new Vector<File>();
        StringTokenizer tok = new StringTokenizer(instJars, PATH_SEPARATOR, false);
        while (tok.hasMoreTokens()) {
            String fileName = tok.nextToken();
            File file = new File(fileName);
            pathList.addElement(file);
        }
        return pathList;
    }

    public static String encodeInstJars(Vector pathList) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int size = pathList.size();
        while (i < size) {
            buf.append(pathList.elementAt(i));
            if (i < size - 1) {
                buf.append(PATH_SEPARATOR);
            }
            ++i;
        }
        return buf.toString();
    }

    public void setInstJars(Vector pathList) {
        String instJars = ShellCmds.encodeInstJars(pathList);
        this.app.getEnv().add(INST_JARS, new ShellObject("Installed Jar Files", instJars));
    }

    public Vector getInstJars() {
        ShellEnv env2 = this.app.getEnv();
        if (env2.contains(INST_JARS)) {
            String instJars = (String)env2.get(INST_JARS).getObject();
            return ShellCmds.decodeInstJars(instJars);
        }
        return new Vector();
    }

    public String[] list() throws Exception {
        Vector pathList = this.getInstJars();
        ShellCmdLoader scl = new ShellCmdLoader(pathList, Class.forName("net.jxta.impl.shell.ShellApp").getClassLoader());
        Vector<String> cmds = new Vector<String>();
        Enumeration e = scl.findCommands();
        while (e.hasMoreElements()) {
            ZipClassLoader.Resource cmd = (ZipClassLoader.Resource)e.nextElement();
            String cmdName = this.extractCmdName(cmd);
            if (cmds.contains(cmdName)) continue;
            cmds.addElement(cmdName);
        }
        String[] cmdNames = cmds.toArray(new String[cmds.size()]);
        ShellCmds.sort(cmdNames, 0, cmdNames.length);
        return cmdNames;
    }

    private String extractCmdName(ZipClassLoader.Resource cmd) {
        String name = cmd.getName();
        int startIndex = name.indexOf(BIN_PATH);
        int delimIndex = name.indexOf(47, startIndex + BIN_PATH_LEN + 1);
        return name.substring(startIndex + BIN_PATH_LEN, delimIndex);
    }

    private static void sort(String[] a, int start, int end) {
        int len = end - start;
        if (len > 1) {
            int mid = start + len / 2;
            ShellCmds.sort(a, start, mid);
            ShellCmds.sort(a, mid, end);
            String[] tmp = new String[len];
            int j = 0;
            int i1 = start;
            int i2 = mid;
            while (j < len) {
                int res;
                tmp[j] = i1 == mid ? a[i2++] : (i2 == end ? a[i1++] : ((res = a[i1].toLowerCase().compareTo(a[i2].toLowerCase())) < 0 ? a[i1++] : a[i2++]));
                ++j;
            }
            System.arraycopy(tmp, 0, a, start, len);
        }
    }

    public ShellApp getInstance(String cmd) throws Exception {
        Vector pathList = this.getInstJars();
        ShellCmdLoader scl = new ShellCmdLoader(pathList, Class.forName("net.jxta.impl.shell.ShellApp").getClassLoader());
        Thread.currentThread().setContextClassLoader(scl);
        Class appClass = scl.loadClass("net.jxta.impl.shell.bin." + cmd + "." + cmd, true);
        ShellApp app = (ShellApp)appClass.newInstance();
        return app;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        INST_JARS = INST_JARS;
        PATH_SEPARATOR = System.getProperty("path.separator");
        BIN_PACKAGE = BIN_PACKAGE;
        BIN_PATH = BIN_PATH;
        BIN_PATH_LEN = BIN_PATH.length();
    }
}

