/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import net.jxta.impl.shell.ShellCmds;
import net.jxta.impl.shell.ZipClassLoader;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class ShellCmdLoader
extends ZipClassLoader {
    private static final String JAVA_CLASS_PATH = System.getProperty("java.class.path");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$shell$ShellCmdLoader == null ? (class$net$jxta$impl$shell$ShellCmdLoader = ShellCmdLoader.class$("net.jxta.impl.shell.ShellCmdLoader")) : class$net$jxta$impl$shell$ShellCmdLoader).getName());
    private static Vector sysCmdList = new Vector();
    static /* synthetic */ Class class$net$jxta$impl$shell$ShellCmdLoader;

    public ShellCmdLoader(Vector fileList, ClassLoader parent) {
        super(fileList, parent);
    }

    public Enumeration findCommands() {
        Vector cmdList = (Vector)sysCmdList.clone();
        ShellCmdLoader.findCommands(this.rcList, cmdList);
        return cmdList.elements();
    }

    protected static void findCommands(Vector rcList, Vector cmdList) {
        Vector rscList = new Vector();
        ZipClassLoader.searchResources(rcList, "net/jxta/impl/shell/bin/", rscList);
        Enumeration e = rscList.elements();
        while (e.hasMoreElements()) {
            ZipClassLoader.Resource rsc = (ZipClassLoader.Resource)e.nextElement();
            String cmdPath = rsc.getName();
            if (!ShellCmdLoader.isValidCmdPath(cmdPath) || cmdList.contains(rsc)) continue;
            cmdList.addElement(rsc);
            if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
            LOG.debug((Object)("Found command '" + rsc + "'"));
        }
    }

    protected static boolean isValidCmdPath(String path) {
        String cmdName;
        int index;
        if (path.startsWith("net/jxta/impl/shell/bin/") && (index = path.indexOf("/", ShellCmds.BIN_PATH_LEN)) != -1 && (cmdName = path.substring(ShellCmds.BIN_PATH_LEN, index)).length() != 0) {
            String cmdPath = path.substring(0, index) + "/" + cmdName + ".class";
            return cmdPath.equals(path);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("java.class.path=" + JAVA_CLASS_PATH));
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("path.separator=" + PATH_SEPARATOR));
        }
        Vector<File> classPath = new Vector<File>();
        StringTokenizer tok = new StringTokenizer(JAVA_CLASS_PATH, PATH_SEPARATOR, false);
        while (tok.hasMoreTokens()) {
            File file = new File(tok.nextToken());
            if (file.exists()) {
                classPath.addElement(file);
                continue;
            }
            if (!LOG.isEnabledFor(Priority.WARN)) continue;
            LOG.warn((Object)("'" + file + "' does not exist"));
        }
        Vector rcList = ZipClassLoader.convertToResourceContainers(classPath);
        ShellCmdLoader.findCommands(rcList, sysCmdList);
    }
}

