/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.id.ID;
import net.jxta.impl.shell.ShellEnv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeService;
import net.jxta.platform.Application;
import net.jxta.util.StringEnumeration;

public abstract class ShellApp
implements Application {
    public static final int appSpawned = -1;
    public static final int appNoError = 0;
    public static final int appParamError = 1;
    public static final int appMiscError = Integer.MAX_VALUE;
    protected PeerGroup group = null;
    protected PipeService pipes = null;
    protected Advertisement implAdv = null;
    protected Advertisement confAdv = null;
    protected ID id = null;
    private ShellEnv env = null;
    protected InputPipe inputPipe = null;
    protected OutputPipe outputPipe = null;
    protected InputPipe consin = null;
    protected OutputPipe consout = null;
    protected String returnVar = null;
    protected volatile boolean started = false;
    protected volatile boolean stopped = false;
    protected String currentcmdline = null;
    private Vector buffered = new Vector();
    private Vector consbuffer = new Vector();
    public Thread dependsOn = null;

    public void init(PeerGroup pg, ID assignedID, Advertisement impl) {
        this.setGroup(pg);
        this.setID(assignedID);
        this.setImplAdvertisement(impl);
        this.setConfAdvertisement(pg.getConfigAdvertisement());
    }

    public int startApp(String[] args) {
        this.started = true;
        return -1;
    }

    public void stopApp() {
        this.stopped = true;
    }

    public boolean isRootShell() {
        return true;
    }

    public final ShellEnv getEnv() {
        return this.env;
    }

    public final ShellEnv setEnv(ShellEnv e) {
        ShellEnv old = this.env;
        this.env = e;
        return old;
    }

    public final PeerGroup getGroup() {
        return this.group;
    }

    public final PeerGroup setGroup(PeerGroup g) {
        PeerGroup old = this.group;
        this.group = g;
        this.pipes = this.group.getPipeService();
        return old;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdv;
    }

    public Advertisement getConfAdvertisement() {
        return this.confAdv;
    }

    public ID getID() {
        return this.id;
    }

    public Advertisement setImplAdvertisement(Advertisement adv) {
        Advertisement old = this.implAdv;
        this.implAdv = adv;
        return old;
    }

    public Advertisement setConfAdvertisement(Advertisement adv) {
        Advertisement old = this.confAdv;
        this.confAdv = adv;
        return old;
    }

    public ID setID(ID id) {
        ID old = this.id;
        this.id = id;
        return old;
    }

    public final InputPipe getInputPipe() {
        return this.inputPipe;
    }

    public final InputPipe setInputPipe(InputPipe ip) {
        InputPipe old = this.inputPipe;
        this.inputPipe = ip;
        return old;
    }

    public final OutputPipe getOutputPipe() {
        return this.outputPipe;
    }

    public final OutputPipe setOutputPipe(OutputPipe op) {
        OutputPipe old = this.outputPipe;
        this.outputPipe = op;
        return old;
    }

    public final InputPipe getInputConsPipe() {
        return this.consin;
    }

    public final InputPipe setInputConsPipe(InputPipe ip) {
        InputPipe old = this.consin;
        this.consin = ip;
        return old;
    }

    public final OutputPipe getOutputConsPipe() {
        return this.consout;
    }

    public final OutputPipe setOutputConsPipe(OutputPipe op) {
        OutputPipe old = this.consout;
        this.consout = op;
        return old;
    }

    public void setReturnVariable(String v) {
        this.returnVar = v;
    }

    public String getReturnVariable() {
        return this.returnVar;
    }

    protected final void println(String line) {
        this.pipePrintln(this.outputPipe, line);
    }

    protected final void print(String line) {
        this.pipePrint(this.outputPipe, line);
    }

    protected final String pollInput() throws IOException {
        return this.pipePollInput(this.inputPipe, this.buffered);
    }

    protected final String waitForInput() throws IOException {
        return this.pipeWaitForInput(this.inputPipe, this.buffered, true);
    }

    protected final void consprint(String line) {
        this.pipePrint(this.consout, line);
    }

    protected final void consprintln(String line) {
        this.pipePrintln(this.consout, line);
    }

    protected final String consPollInput() throws IOException {
        return this.pipePollInput(this.consin, this.consbuffer);
    }

    protected final String consWaitForInput() throws IOException {
        return this.pipeWaitForInput(this.consin, this.consbuffer, false);
    }

    public String getDescription() {
        return "No description available for this ShellApp";
    }

    public void help() {
        this.println("No help available for this ShellApp");
    }

    private void pipePrint(OutputPipe pipe, String line) {
        if (null == pipe) {
            return;
        }
        String lineToSend = null;
        lineToSend = line.length() == 0 ? " " : line;
        Message msg = this.pipes.createMessage();
        try {
            msg.addElement(msg.newMessageElement("ShellOutputPipe", null, (InputStream)new ByteArrayInputStream(lineToSend.getBytes())));
            pipe.send(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void pipePrintln(OutputPipe pipe, String line) {
        this.pipePrint(pipe, line + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pipePollInput(InputPipe input, Vector lineBuffer) throws IOException {
        boolean onePoll = false;
        block13: while (true) {
            block19: {
                if (null == lineBuffer) break block19;
                Vector vector = lineBuffer;
                synchronized (vector) {
                    if (lineBuffer.size() <= 0) break block19;
                    try {
                        String val = (String)lineBuffer.elementAt(0);
                        lineBuffer.removeElementAt(0);
                        String string = val;
                        return string;
                    }
                    catch (Exception e) {
                    }
                }
            }
            if (input == null) {
                throw new IOException();
            }
            if (onePoll) {
                return null;
            }
            Message msg = null;
            try {
                msg = input.poll(1);
            }
            catch (InterruptedException woken) {
                // empty catch block
            }
            if (null == msg) {
                return null;
            }
            onePoll = true;
            StringEnumeration names = msg.getNames();
            block14: while (true) {
                if (!names.hasMoreElements()) continue block13;
                try {
                    String command;
                    String name = (String)names.nextElement();
                    if (!name.equals("ShellInputPipe") && !name.equals("ShellOutputPipe")) continue;
                    MessageElement elem = msg.getElement(name);
                    msg.removeElement(elem);
                    InputStream inputStream = elem.getStream();
                    BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
                    while (true) {
                        if (null == (command = inputReader.readLine())) continue block14;
                        if (null == lineBuffer) break;
                        Vector vector = lineBuffer;
                        synchronized (vector) {
                            lineBuffer.addElement(command);
                        }
                    }
                    return command;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            break;
        }
    }

    private String pipeWaitForInput(InputPipe input, Vector lineBuffer, boolean join2) throws IOException {
        String msg = null;
        while (!(null != (msg = this.pipePollInput(input, lineBuffer)) || this.stopped || join2 && null != this.dependsOn && !this.dependsOn.isAlive())) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
            }
        }
        return msg;
    }

    static {
        appSpawned = -1;
        appNoError = 0;
        appParamError = 1;
        appMiscError = Integer.MAX_VALUE;
    }
}

