/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.jxta.impl.shell.TestDBHandler;

public class MysqlDBHandler
extends Properties {
    private static boolean debug = false;
    public boolean use_c_pool = true;
    private int number_of_connections = 1;
    private LinkedList connectionqueue;

    public MysqlDBHandler() {
    }

    public MysqlDBHandler(String propfile) {
        this.loadProperties(propfile);
        this.connect();
    }

    public void connect() {
        this.connectionqueue = new LinkedList();
        this.initializeCQueue(this.number_of_connections);
    }

    private void initializeCQueue(int num_cons) {
        if (debug) {
            System.out.println("Initializing connection queue: ");
        }
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
        }
        catch (Exception E) {
            System.err.println("Unable to load driver.");
            E.printStackTrace();
        }
        int i = 0;
        while (i < num_cons) {
            this.connectionqueue.add(this.getconn());
            ++i;
        }
        if (debug) {
            System.out.println("done.");
        }
    }

    public static void setDebug() {
        debug = true;
    }

    public static void clearDebug() {
        debug = false;
    }

    public Connection getConnection() {
        if (debug) {
            System.out.println("Fetching connection from pool...");
        }
        if (this.use_c_pool) {
            Connection con;
            try {
                con = (Connection)this.connectionqueue.removeFirst();
            }
            catch (NoSuchElementException e) {
                System.out.println("No more connections in queue.  Fetch more.");
                con = this.getconn();
            }
            return con;
        }
        return this.getconn();
    }

    public void returnConnection(Connection con) {
        this.connectionqueue.add(con);
        if (debug) {
            System.out.println("Connection returned to queue...");
        }
    }

    private Connection getconn() {
        Connection con = null;
        String dbhost = this.getProperty("hostname");
        String dbinst = this.getProperty("instance");
        String dbport = this.getProperty("port");
        String dbuser = this.getProperty("user");
        String dbpass = this.getProperty("passwd");
        String URL2 = "jdbc:mysql://" + dbhost + ":" + dbport + "/jxtasearch?user=" + dbuser + "&password=" + dbpass;
        System.out.println("URL: " + URL2 + ", User: " + dbuser + ", Passwd: ********");
        try {
            con = DriverManager.getConnection(URL2, dbuser, dbpass);
            if (debug) {
                System.out.println("Connection opened.");
            }
        }
        catch (Exception e) {
            System.out.println("We are not connecting here...");
            e.printStackTrace();
        }
        return con;
    }

    public boolean closeAllConnections() {
        int queuesize = this.connectionqueue.size();
        int i = 0;
        boolean closed = false;
        while (i < queuesize) {
            Connection con = (Connection)this.connectionqueue.removeFirst();
            closed = this.closeConnection(con);
            if (!closed) break;
            ++i;
        }
        return closed;
    }

    public boolean closeConnection(Connection con) {
        boolean closed = false;
        try {
            con.close();
            closed = true;
            if (debug) {
                System.out.println("Connection closed.");
            }
        }
        catch (SQLException sqle) {
            System.out.println("Can't close the connection.");
            sqle.printStackTrace();
        }
        return closed;
    }

    public void makeSQLCommand(String sqlcmd) {
        Connection con = this.getConnection();
        try {
            Statement stmt = con.createStatement();
            stmt.executeQuery(sqlcmd);
            if (debug) {
                System.out.println("SQL Command: " + sqlcmd);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public void createTable(Connection con, String tablename, String fields) {
        String sqlcmd = "CREATE TABLE " + tablename + "(" + fields + ")";
        if (debug) {
            System.out.println(sqlcmd);
        }
        try {
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sqlcmd);
            if (debug) {
                System.out.println("Table " + tablename + " created");
            }
        }
        catch (SQLException sqle) {
            System.out.println("Unable to create table " + tablename);
            sqle.printStackTrace();
        }
    }

    public void useDatabase(String database) {
        Connection conn = this.getConnection();
        String entry = "USE " + database;
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(entry);
            stmt.close();
        }
        catch (SQLException sqle) {
            System.out.println("Problem with database " + database);
            sqle.printStackTrace();
        }
    }

    public void dropTable(Connection con, String tablename) {
        String sqlcmd = "DROP TABLE " + tablename;
        if (debug) {
            System.out.println(sqlcmd);
        }
        try {
            Statement stmt = con.createStatement();
            stmt.executeUpdate(sqlcmd);
            if (debug) {
                System.out.println("Table " + tablename + " dropped");
            }
        }
        catch (SQLException sqle) {
            System.out.println("Unable to drop table " + tablename);
            sqle.printStackTrace();
        }
    }

    public void setDBProperties(String dbhost, String dbinst, String dbport, String dbuser, String dbpasswd) {
        this.setProperty("hostname", dbhost);
        this.setProperty("instance", dbinst);
        this.setProperty("port", dbport);
        this.setProperty("user", dbuser);
        this.setProperty("passwd", dbpasswd);
    }

    public void setDBHost(String dbhost) {
        this.setProperty("hostname", dbhost);
    }

    public void setDBInst(String dbinst) {
        this.setProperty("instance", dbinst);
    }

    public void setDBPort(String dbport) {
        this.setProperty("port", dbport);
    }

    public void setDBUser(String dbuser) {
        this.setProperty("user", dbuser);
    }

    public void setDBPass(String dbpass) {
        this.setProperty("passwd", dbpass);
    }

    public String getDBHost(String dbhost) {
        return this.getProperty("hostname");
    }

    public String getDBInst(String dbinst) {
        return this.getProperty("instance");
    }

    public String getDBPort(String dbport) {
        return this.getProperty("port");
    }

    public String getDBUser(String dbuser) {
        return this.getProperty("user");
    }

    public String getDBPass(String dbpass) {
        return this.getProperty("passwd");
    }

    public void storeProperties(String filename) {
        File propfile = new File(filename);
        this.storeProps(propfile);
    }

    private void storeProperties() {
        File propfile = new File("mysqlprops");
        this.storeProps(propfile);
    }

    private void storeProps(File propfile) {
        try {
            FileOutputStream fos = new FileOutputStream(propfile);
            this.store(fos, "MySql database properties for servlet adapter");
            fos.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        catch (ClassCastException ce) {
            System.out.println("Object not a string");
            ce.printStackTrace();
        }
    }

    public void loadProperties(String filename) {
        File propfile = new File(filename);
        this.loadProps(propfile);
    }

    private void loadProperties() {
        File propfile = new File("mysqlprops");
        this.loadProps(propfile);
    }

    private void loadProps(File propfile) {
        try {
            FileInputStream fis = new FileInputStream(propfile);
            this.load(fis);
            fis.close();
        }
        catch (IOException ioe) {
            System.out.println("Problem with property input file");
            ioe.printStackTrace();
        }
    }

    private static void test() {
        MysqlDBHandler dbh = new MysqlDBHandler();
        dbh.setDBHost("127.0.0.1");
        dbh.setDBInst("localhost");
        dbh.setDBPort("3306");
        dbh.setDBUser("jxtasearch");
        dbh.setDBPass("gonesilent");
        if (TestDBHandler.test((MysqlDBHandler)dbh)) {
            System.out.println("Passed MysqlDBHandler unit tests");
        } else {
            System.out.println("Failed MysqlDBHandler unit tests");
        }
    }

    public static void main(String[] args) {
        MysqlDBHandler.test();
    }
}

