/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.rce.talon.implementations;

import org.openprivacy.sierra.factories.ReputationFactory;
import org.openprivacy.sierra.nym.talon.components.Nym;
import org.openprivacy.sierra.query.talon.components.RCEQuery;
import org.openprivacy.sierra.query.talon.implementations.ReferenceRCEQuery;
import org.openprivacy.sierra.rce.talon.components.RCE;
import org.openprivacy.sierra.rce.talon.implementations.BaseRCE;
import org.openprivacy.sierra.rce.talon.implementations.util.ReputationReferenceMap;
import org.openprivacy.sierra.reputation.talon.components.Reference;
import org.openprivacy.sierra.reputation.talon.components.Reputation;
import org.openprivacy.sierra.reputation.talon.implementations.OverallMarkupPayload;
import org.openprivacy.sierra.util.ReputationNotFoundException;
import org.openprivacy.sierra.util.SierraException;
import talon.ComponentFactory;
import talon.TalonException;
import talon.components.Logger;

public class WeightedRCE
extends BaseRCE
implements RCE {
    ReputationReferenceMap map = new ReputationReferenceMap();
    private Nym nym = null;
    private Logger logger = null;
    static /* synthetic */ Class class$org$openprivacy$sierra$reputation$talon$implementations$OverallMarkupPayload;
    static /* synthetic */ Class class$org$openprivacy$sierra$query$talon$implementations$ReferenceRCEQuery;

    public void init() {
        this.logger = this.getLogger();
    }

    public Reputation getReputation(RCEQuery query) throws SierraException, ReputationNotFoundException {
        if (query instanceof ReferenceRCEQuery) {
            Reference reference = ((ReferenceRCEQuery)query).getReference();
            Reputation[] reps = this.map.getReputations(reference);
            float total = 0.0f;
            int i = 0;
            while (i < reps.length) {
                OverallMarkupPayload omp = (OverallMarkupPayload)reps[i].getPayload(OverallMarkupPayload.IDENTIFIER);
                total += omp.getOption();
                ++i;
            }
            float computed = 0.0f;
            computed = reps.length != 0 ? total / (float)reps.length : -1.0f;
            Reputation rep = ReputationFactory.getInstance();
            rep.setReference(reference);
            rep.setNym(this.getNym());
            try {
                OverallMarkupPayload omp = (OverallMarkupPayload)ComponentFactory.getInstance((Class)(class$org$openprivacy$sierra$reputation$talon$implementations$OverallMarkupPayload == null ? (class$org$openprivacy$sierra$reputation$talon$implementations$OverallMarkupPayload = WeightedRCE.class$("org.openprivacy.sierra.reputation.talon.implementations.OverallMarkupPayload")) : class$org$openprivacy$sierra$reputation$talon$implementations$OverallMarkupPayload));
                omp.setOption(computed);
                rep.addPayload(omp);
            }
            catch (TalonException te) {
                throw new SierraException(te);
            }
            return rep;
        }
        throw new SierraException("Query type not supported: " + query.getTypeReference().toString());
    }

    public Reputation getReputation(Reference reference) throws SierraException, ReputationNotFoundException {
        try {
            ReferenceRCEQuery query = (ReferenceRCEQuery)ComponentFactory.getInstance((Class)(class$org$openprivacy$sierra$query$talon$implementations$ReferenceRCEQuery == null ? (class$org$openprivacy$sierra$query$talon$implementations$ReferenceRCEQuery = WeightedRCE.class$("org.openprivacy.sierra.query.talon.implementations.ReferenceRCEQuery")) : class$org$openprivacy$sierra$query$talon$implementations$ReferenceRCEQuery));
            query.setReference(reference);
            return this.getReputation(query);
        }
        catch (TalonException e) {
            throw new SierraException(e);
        }
    }

    public void putReputation(Reputation reputation) throws SierraException {
        this.logger.debug((Object)("Putting reputation in store engine: " + reputation.toString()));
        this.getStoreEngine().put(reputation);
        this.map.putReputation(reputation);
    }

    public Nym getNym() {
        return this.nym;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

