/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class MimeMail
extends Task {
    private boolean failOnError = true;
    private String from = null;
    private String mailhost = "localhost";
    private String message = null;
    private File messageFile = null;
    private String toList = null;
    protected String ccList = null;
    protected String bccList = null;
    private String subject = null;
    private Vector filesets = new Vector();
    private String messageMimeType = "text/plain";

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setToList(String toList) {
        this.toList = toList;
    }

    public void setCcList(String ccList) {
        this.ccList = ccList;
    }

    public void setBccList(String bccList) {
        this.bccList = bccList;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setMailhost(String mailhost) {
        this.mailhost = mailhost;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessageFile(File messageFile) {
        this.messageFile = messageFile;
    }

    public void setMessageMimeType(String type) {
        this.messageMimeType = type;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void validate() {
        if (this.from == null) {
            throw new BuildException("Attribute \"from\" is required.");
        }
        if (this.toList == null && this.ccList == null && this.bccList == null) {
            throw new BuildException("Attribute \"toList\", \"ccList\" or \"bccList\" is required.");
        }
        if (this.message == null && this.filesets.isEmpty() && this.messageFile == null) {
            throw new BuildException("FileSet, \"message\", or \"messageFile\" is required.");
        }
        if (this.message != null && this.messageFile != null) {
            throw new BuildException("Only one of \"message\" or \"messageFile\" may be specified.");
        }
    }

    public void execute() throws BuildException {
        try {
            this.validate();
            this.doMail();
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new BuildException((Throwable)e);
            }
            String text = e.toString();
            this.log(text, 0);
        }
    }

    private static void addRecipients(MimeMessage msg, Message.RecipientType recipType, String addrUserName, String addrList) throws MessagingException, BuildException {
        if (null == addrList || addrList.trim().length() <= 0) {
            return;
        }
        try {
            InternetAddress[] addrArray = InternetAddress.parse((String)addrList);
            if (null == addrArray || 0 == addrArray.length) {
                throw new BuildException("Empty " + addrUserName + " recipients list was specified");
            }
            msg.setRecipients(recipType, (Address[])addrArray);
        }
        catch (AddressException ae) {
            throw new BuildException("Invalid " + addrUserName + " recipient list");
        }
    }

    public void doMail() throws MessagingException, AddressException, BuildException {
        Properties props = new Properties();
        ((Hashtable)props).put("mail.smtp.host", this.mailhost);
        Session sesh = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(sesh);
        this.log("message sender: " + this.from, 3);
        msg.setFrom((Address)new InternetAddress(this.from));
        MimeMail.addRecipients(msg, Message.RecipientType.TO, "To", this.toList);
        MimeMail.addRecipients(msg, Message.RecipientType.CC, "Cc", this.ccList);
        MimeMail.addRecipients(msg, Message.RecipientType.BCC, "Bcc", this.bccList);
        if (this.subject != null) {
            this.log("subject: " + this.subject, 3);
            msg.setSubject(this.subject);
        }
        MimeMultipart attachments = new MimeMultipart();
        if (this.messageFile != null) {
            int size = (int)this.messageFile.length();
            byte[] data = new byte[size];
            try {
                FileInputStream inStream = new FileInputStream(this.messageFile);
                inStream.read(data);
                inStream.close();
                this.message = new String(data);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        if (this.message != null) {
            MimeBodyPart textbody = new MimeBodyPart();
            textbody.setContent((Object)this.message, this.messageMimeType);
            attachments.addBodyPart((BodyPart)textbody);
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            if (fs != null) {
                DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
                String[] dsfiles = ds.getIncludedFiles();
                File baseDir = ds.getBasedir();
                int j = 0;
                while (j < dsfiles.length) {
                    File file = new File(baseDir, dsfiles[j]);
                    MimeBodyPart body = new MimeBodyPart();
                    if (!file.exists() || !file.canRead()) {
                        throw new BuildException("File \"" + file.getAbsolutePath() + "\" does not exist or is not readable.");
                    }
                    this.log("Attaching " + file.toString() + " - " + file.length() + " bytes", 3);
                    FileDataSource fileData = new FileDataSource(file);
                    DataHandler fileDataHandler = new DataHandler((DataSource)fileData);
                    body.setDataHandler(fileDataHandler);
                    body.setFileName(file.getName());
                    attachments.addBodyPart((BodyPart)body);
                    ++j;
                }
            }
            ++i;
        }
        msg.setContent((Multipart)attachments);
        this.log("sending email ");
        Transport.send((Message)msg);
    }
}

