/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.ImportCodeSpec;
import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.Project;
import com.ibm.ivj.util.base.Type;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;
import org.apache.tools.ant.types.FileSet;

public class VAJImport
extends Task {
    protected Vector filesets = new Vector();
    protected boolean importSources = true;
    protected boolean importResources = true;
    protected boolean importClasses = false;
    protected String importProject = null;
    protected Project vajproject = null;

    public void setVajproject(String projectName) {
        this.importProject = projectName;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setImportClasses(boolean importClasses) {
        this.importClasses = importClasses;
    }

    public void setImportResources(boolean importResources) {
        this.importResources = importResources;
    }

    public void setImportSources(boolean importSources) {
        this.importSources = importSources;
    }

    public void execute() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("At least one fileset is required!");
        }
        if (this.importProject == null || "".equals(this.importProject)) {
            throw new BuildException("The VisualAge for Java Project name is required!");
        }
        this.vajproject = this.getVAJProject();
        if (this.vajproject == null) {
            try {
                this.vajproject = VAJUtil.getWorkspace().createProject(this.importProject, true);
            }
            catch (IvjException e) {
                throw VAJUtil.createBuildException("Error while creating Project " + this.importProject + ": ", e);
            }
        }
        Enumeration e = this.filesets.elements();
        while (e.hasMoreElements()) {
            this.importFileset((FileSet)e.nextElement());
        }
    }

    protected Project getVAJProject() {
        Project found = null;
        Project[] currentProjects = VAJUtil.getWorkspace().getProjects();
        int i = 0;
        while (i < currentProjects.length) {
            Project p = currentProjects[i];
            if (p.getName().equals(this.importProject)) {
                found = p;
                break;
            }
            ++i;
        }
        return found;
    }

    protected void importFileset(FileSet fileset) {
        DirectoryScanner ds = fileset.getDirectoryScanner(((ProjectComponent)this).project);
        if (ds.getIncludedFiles().length == 0) {
            return;
        }
        Vector classes = new Vector();
        Vector sources = new Vector();
        Vector resources = new Vector();
        Object[] classesArr = null;
        Object[] sourcesArr = null;
        Object[] resourcesArr = null;
        StringBuffer msg = new StringBuffer();
        msg.append("Importing ");
        String connector = "";
        ImportCodeSpec importSpec = new ImportCodeSpec();
        importSpec.setDefaultProject(this.vajproject);
        this.scan(fileset.getDir(((ProjectComponent)this).project), ds.getIncludedFiles(), classes, sources, resources);
        if (this.importClasses) {
            classesArr = new String[classes.size()];
            classes.copyInto(classesArr);
            importSpec.setClassFiles((String[])classesArr);
            if (classesArr.length > 0) {
                this.logFiles(classes, "class");
                msg.append(classesArr.length);
                msg.append(" class ");
                msg.append(classesArr.length > 1 ? "files" : "file");
                connector = ", ";
            }
        }
        if (this.importSources) {
            sourcesArr = new String[sources.size()];
            sources.copyInto(sourcesArr);
            importSpec.setJavaFiles((String[])sourcesArr);
            if (sourcesArr.length > 0) {
                this.logFiles(sources, "source");
                msg.append(connector);
                msg.append(sourcesArr.length);
                msg.append(" source ");
                msg.append(sourcesArr.length > 1 ? "files" : "file");
                connector = ", ";
            }
        }
        if (this.importResources) {
            String resourcePath = fileset.getDir(((ProjectComponent)this).project).getAbsolutePath();
            resourcesArr = new String[resources.size()];
            resources.copyInto(resourcesArr);
            importSpec.setResourcePath(resourcePath);
            importSpec.setResourceFiles((String[])resourcesArr);
            if (resourcesArr.length > 0) {
                this.logFiles(resources, "resource");
                this.log("  (relative to resource path '" + resourcePath + "')", 3);
                msg.append(connector);
                msg.append(resourcesArr.length);
                msg.append(" resource ");
                msg.append(resourcesArr.length > 1 ? "files" : "file");
            }
        }
        msg.append(" into the ");
        msg.append(this.importProject);
        msg.append(" project.");
        this.log(msg.toString());
        try {
            Type[] importedTypes = VAJUtil.getWorkspace().importData(importSpec);
            if (importedTypes == null) {
                throw new BuildException("Unable to import into Workspace!");
            }
        }
        catch (IvjException ivje) {
            throw VAJUtil.createBuildException("Error while importing into Workspace: ", ivje);
        }
    }

    protected void scan(File dir, String[] files, Vector classes, Vector sources, Vector resources) {
        int i = 0;
        while (i < files.length) {
            String file = new File(dir, files[i]).getAbsolutePath();
            if (file.endsWith(".java") || file.endsWith(".JAVA")) {
                sources.addElement(file);
            } else if (file.endsWith(".class") || file.endsWith(".CLASS")) {
                classes.addElement(file);
            } else {
                resources.addElement(files[i]);
            }
            ++i;
        }
    }

    protected void logFiles(Vector fileNames, String fileType) {
        this.log(fileType + " files found for import:", 3);
        Enumeration e = fileNames.elements();
        while (e.hasMoreElements()) {
            this.log("    " + e.nextElement(), 3);
        }
    }
}

