/*
 * Decompiled with CFR 0.152.
 */
package org.jxta.bridge.tests;

import junit.framework.TestCase;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import org.jxta.bridge.ServiceDescriptor;
import org.jxta.bridge.bootstrap.JXTABootstrap;
import org.jxta.bridge.jxta.SOAPService;
import org.jxta.bridge.tests.HelloService;
import org.jxta.bridge.tests.TestThread;

public class TestJXTA
extends TestCase {
    public TestJXTA(String name) {
        super(name);
    }

    public void testJXTAService() throws Exception {
        PeerGroup platform = JXTABootstrap.getInstance().getPlatform();
        PeerGroup netPeerGroup = PeerGroupFactory.newNetPeerGroup((PeerGroup)platform);
        SOAPService service = new SOAPService();
        service.getRunData().setPeerGroup(platform);
        ServiceDescriptor descriptor = HelloService.DESCRIPTOR;
        service.init(platform, netPeerGroup, descriptor);
        TestThread testThread = new TestThread(descriptor, service.getRunData());
        testThread.start();
        service.accept(service.getRunData().getInputPipe());
        testThread.assertSuccess();
    }

    public void testJXTAServiceWithNewPeerGroup() throws Exception {
        PeerGroup platform = JXTABootstrap.getInstance().getPlatform();
        PeerGroup netPeerGroup = PeerGroupFactory.newNetPeerGroup((PeerGroup)platform);
        SOAPService service = new SOAPService();
        ServiceDescriptor descriptor = HelloService.DESCRIPTOR;
        descriptor.setPeerGroupID("urn:jxta:uuid-393F58BDA78E409E9D7B868B054D535002");
        service.init(platform, netPeerGroup, descriptor);
        TestThread testThread = new TestThread(descriptor, service.getRunData());
        testThread.start();
        service.accept(service.getRunData().getInputPipe());
        testThread.assertSuccess();
    }

    public void testJXTACallAutoDiscovery() throws Exception {
        PeerGroup platform = JXTABootstrap.getInstance().getPlatform();
        PeerGroup netPeerGroup = PeerGroupFactory.newNetPeerGroup((PeerGroup)platform);
        SOAPService service = new SOAPService();
        ServiceDescriptor descriptor = HelloService.DESCRIPTOR;
        descriptor.setPeerGroupID("urn:jxta:uuid-393F58BDA78E409E9D7B868B054D535002");
        service.init(platform, netPeerGroup, descriptor);
        TestThread testThread = new TestThread(descriptor, platform.getPeerID(), service.getRunData());
        testThread.start();
        service.accept(service.getRunData().getInputPipe());
        testThread.assertSuccess();
    }
}

