/*
 * Decompiled with CFR 0.152.
 */
package org.jxta.bridge.jxta.transport;

import java.io.ByteArrayInputStream;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.jxta.bridge.JXTAUtils;
import org.jxta.bridge.ServiceDescriptor;

public class JXTASOAPTransportSender
extends BasicHandler {
    static int nextNum = 1;

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            PeerGroup peergroup = (PeerGroup)msgContext.getProperty("peergroup");
            PipeAdvertisement advert = (PipeAdvertisement)msgContext.getProperty("advertisement");
            ServiceDescriptor descriptor = (ServiceDescriptor)msgContext.getProperty("descriptor");
            OutputPipe output = (OutputPipe)msgContext.getProperty("outputpipe");
            if (output == null) {
                output = peergroup.getPipeService().createOutputPipe(advert, descriptor.getTimeout());
            }
            PipeAdvertisement pipeadv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
            PeerGroupID pgid = peergroup.getPeerGroupID();
            pipeadv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)pgid));
            pipeadv.setName("remote-input-pipe");
            if (descriptor.isSecure()) {
                pipeadv.setType("JxtaUnicastSecure");
            } else {
                pipeadv.setType("JxtaUnicast");
            }
            InputPipe remoteInputPipe = peergroup.getPipeService().createInputPipe(pipeadv);
            MessageImpl message = new MessageImpl();
            message.setBytes("message", msgContext.getRequestMessage().getSOAPPart().getAsBytes());
            message.setBytes("remote-input-pipe", JXTAUtils.toString((Advertisement)pipeadv).getBytes());
            output.send((net.jxta.endpoint.Message)message);
            output.close();
            net.jxta.endpoint.Message msg = remoteInputPipe.waitForMessage();
            String result = msg.getString("message");
            msgContext.setResponseMessage(new Message((Object)new ByteArrayInputStream(result.getBytes())));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new AxisFault(t.getMessage());
        }
    }
}

