/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.UnsupportedEncodingException;

class XMLEncoder {
    XMLEncoder() {
    }

    public static String encode(String s) throws UnsupportedEncodingException {
        return XMLEncoder.encode(s, false);
    }

    public static String encode(String s, boolean attributes) throws UnsupportedEncodingException {
        String encoding = "UTF-8";
        StringBuffer result = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < s.length()) {
            char current = s.charAt(i);
            if (XMLEncoder.isSafe(current, attributes)) {
                result.append(s.charAt(i));
            } else {
                switch (current) {
                    case '<': {
                        result.append("&lt;");
                        break;
                    }
                    case '>': {
                        result.append("&gt;");
                        break;
                    }
                    case '\"': {
                        result.append("&quot;");
                        break;
                    }
                    case '&': {
                        result.append("&amp;");
                        break;
                    }
                    default: {
                        result.append(current);
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static String encodeUTF8(String s) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            System.out.println("input: " + s);
            dos.writeUTF(s);
            String result = bos.toString("UTF-8");
            System.out.println("output: " + result);
            return result;
        }
        catch (Throwable t) {
            return s;
        }
    }

    private static boolean isSafe(char c, boolean attributes) {
        if (attributes) {
            return c < '\u007f' && c >= ' ' && c != '<' && c != '>' && c != '&' && c != '\"';
        }
        return c < '\u007f' && c >= ' ' && c != '<' && c != '>' && c != '&';
    }
}

