/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;
import org.mortbay.util.UnixCrypt;

public class Password {
    private String _pw;
    private char[] _pwc;
    private String _cs;

    private void setPassword(String realm, String password) {
        this._pw = password;
        while (this._pw != null && this._pw.startsWith("EXEC:")) {
            this._pw = this.expand(realm, this._pw.substring(5).trim());
        }
        while (this._pw != null && this._pw.startsWith("OBF:")) {
            this._pw = Password.deobfuscate(this._pw);
        }
        if (this._pw.startsWith("CHK:")) {
            this._cs = this._pw;
            this._pw = null;
            this._pwc = null;
        } else if (this._pw.startsWith("CRYPT:")) {
            this._cs = this._pw;
            this._pw = null;
            this._pwc = null;
        } else {
            this._pwc = this._pw.toCharArray();
            this._cs = Password.checksum(this._pw);
        }
    }

    private String expand(String realm, String pass) {
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec(pass);
                OutputStream out = process.getOutputStream();
                out.write((realm + "\n").getBytes());
                out.flush();
                InputStream in = process.getInputStream();
                byte[] buf = new byte[512];
                int len = in.read(buf);
                pass = new String(buf, 0, len).trim();
            }
            catch (Exception e) {
                Code.warning(e);
                Object var5_10 = null;
                if (process != null) {
                    process.destroy();
                }
            }
            Object var5_9 = null;
            if (process != null) {
                process.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (process != null) {
                process.destroy();
            }
            throw throwable;
        }
        System.err.println("PW=" + pass);
        return pass;
    }

    public String toString() {
        return this._pw == null ? this._cs : this._pw;
    }

    public String toStarString() {
        if (this._pw == null) {
            return null;
        }
        return "********************************************************************************".substring(0, this._pw.length());
    }

    public char[] getCharArray() {
        if (this._pwc == null) {
            return null;
        }
        return this._pwc;
    }

    public String getChecksum() {
        return this._cs;
    }

    public boolean check(String passwd) {
        Password pw = new Password("password", passwd);
        if (this._pw != null && pw._pw != null) {
            return this._pw.equals(pw._pw);
        }
        if (this._cs.startsWith("CRYPT:")) {
            return this._cs.endsWith(UnixCrypt.crypt(passwd, this._cs.substring("CRYPT:".length())));
        }
        return this.getChecksum().equals(pw.getChecksum());
    }

    public boolean equals(Object o) {
        Password pw = null;
        if (o instanceof Password) {
            pw = (Password)o;
            if (this._pw != null) {
                return this._pw.equals(pw._pw);
            }
            if (this._cs != null && pw._pw == null) {
                return this._cs.equals(pw._cs);
            }
        }
        return false;
    }

    public void zero() {
        this._pw = null;
        if (this._pwc != null) {
            Arrays.fill(this._pwc, '\u0000');
        }
        this._pwc = null;
    }

    public static String obfuscate(String s) {
        StringBuffer buf = new StringBuffer();
        byte[] b = s.getBytes();
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            buf.append("OBF:");
            int i = 0;
            while (i < b.length) {
                byte b1 = b[i];
                byte b2 = b[s.length() - (i + 1)];
                int i1 = b1 + b2 + 127;
                int i2 = b1 - b2 + 127;
                int i0 = i1 * 256 + i2;
                String x = Integer.toString(i0, 36);
                switch (x.length()) {
                    case 1: {
                        buf.append('0');
                    }
                    case 2: {
                        buf.append('0');
                    }
                    case 3: {
                        buf.append('0');
                    }
                }
                buf.append(x);
                ++i;
            }
            String string = buf.toString();
            Object var4_12 = null;
            return string;
        }
    }

    public static String deobfuscate(String s) {
        if (s.startsWith("OBF:")) {
            s = s.substring(4);
        }
        byte[] b = new byte[s.length() / 2];
        int l = 0;
        int i = 0;
        while (i < s.length()) {
            String x = s.substring(i, i + 4);
            int i0 = Integer.parseInt(x, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            b[l++] = (byte)((i1 + i2 - 254) / 2);
            i += 4;
        }
        return new String(b, 0, l);
    }

    public static String checksum(String s) {
        StringBuffer buf;
        byte[] b = null;
        try {
            b = s.getBytes(StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            Code.fail(e);
        }
        CRC32 crc32 = new CRC32();
        Adler32 adler32 = new Adler32();
        crc32.update(b);
        adler32.update(b);
        StringBuffer stringBuffer = buf = new StringBuffer();
        synchronized (stringBuffer) {
            buf.append("CHK:");
            buf.append(Long.toString(crc32.getValue(), 32));
            buf.append(Long.toString(adler32.getValue(), 32));
            String string = buf.toString();
            Object var6_8 = null;
            return string;
        }
    }

    public static String crypt(String user, String pw) {
        return "CRYPT:" + UnixCrypt.crypt(pw, user);
    }

    public static void main(String[] arg) {
        if (arg.length != 1 && arg.length != 2) {
            System.err.println("Usage - java c.m.U.Password [<user>] <password>");
            System.err.println("If the password is ?, the user will be prompted for the password");
            System.exit(1);
        }
        String p = arg[arg.length == 1 ? 0 : 1];
        Password pw = "?".equals(p) ? new Password("password") : new Password("password", p);
        System.err.println(pw.toString());
        System.err.println(Password.obfuscate(pw.toString()));
        System.err.println(Password.checksum(pw.toString()));
        if (arg.length == 2) {
            System.err.println(Password.crypt(arg[0], pw.toString()));
        }
    }

    public Password() {
    }

    public Password(String realm) {
        this(realm, "", null);
    }

    public Password(String realm, String passwd) {
        this.setPassword(realm, passwd);
    }

    public Password(String realm, String dft, String promptDft) {
        String passwd = System.getProperty(realm, dft);
        if (passwd == null || passwd.length() == 0) {
            try {
                System.out.print(realm + (promptDft != null && promptDft.length() > 0 ? " [dft]" : "") + " : ");
                System.out.flush();
                byte[] buf = new byte[512];
                int len = System.in.read(buf);
                passwd = new String(buf, 0, len).trim();
            }
            catch (IOException e) {
                Code.warning(e);
            }
            if (passwd == null || passwd.length() == 0) {
                passwd = promptDft;
            }
        }
        this.setPassword(realm, passwd);
    }
}

