/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.mortbay.util.Code;

public class LineInput
extends FilterInputStream {
    private static final int LF = 10;
    private static final int CR = 13;
    private byte[] _buf;
    private ByteBuffer _byteBuffer;
    private InputStreamReader _reader;
    private int _mark = -1;
    private int _pos;
    private int _avail;
    private int _contents;
    private int _byteLimit = -1;
    private boolean _newByteLimit;
    private LineBuffer _lineBuffer;
    private String _encoding;
    private boolean _eof = false;
    private boolean _lastCr = false;

    public void setByteLimit(int bytes) {
        this._byteLimit = bytes;
        if (bytes >= 0) {
            this._newByteLimit = true;
            this._byteLimit -= this._contents - this._pos;
            if (this._byteLimit < 0) {
                this._avail += this._byteLimit;
                this._byteLimit = 0;
            }
        } else {
            this._newByteLimit = false;
            this._avail = this._contents;
            this._eof = false;
        }
    }

    public int getByteLimit() {
        if (this._byteLimit < 0) {
            return this._byteLimit;
        }
        return this._byteLimit + this._avail - this._pos;
    }

    public synchronized String readLine() throws IOException {
        int len = this.fillLine(this._buf.length);
        if (len < 0) {
            return null;
        }
        String s = null;
        if (this._encoding == null) {
            s = new String(this._buf, this._mark, len);
        } else {
            try {
                s = new String(this._buf, this._mark, len, this._encoding);
            }
            catch (UnsupportedEncodingException e) {
                Code.warning(e);
            }
        }
        this._mark = -1;
        return s;
    }

    public int readLine(char[] c, int off, int len) throws IOException {
        int blen = this.fillLine(len);
        if (blen < 0) {
            return -1;
        }
        if (blen == 0) {
            return 0;
        }
        this._byteBuffer.setStream(this._mark, blen);
        len = this._reader.read(c, off, len);
        this._mark = -1;
        return len;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        if ((len = this.fillLine(len)) < 0) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        System.arraycopy(this._buf, this._mark, b, off, len);
        this._mark = -1;
        return len;
    }

    public LineBuffer readLineBuffer() throws IOException {
        return this.readLineBuffer(this._buf.length);
    }

    public LineBuffer readLineBuffer(int len) throws IOException {
        if ((len = this.fillLine(len > 0 ? len : this._buf.length)) < 0) {
            return null;
        }
        if (len == 0) {
            this._lineBuffer.size = 0;
            return this._lineBuffer;
        }
        this._byteBuffer.setStream(this._mark, len);
        this._lineBuffer.size = this._reader.read(this._lineBuffer.buffer, 0, this._lineBuffer.buffer.length);
        this._mark = -1;
        return this._lineBuffer;
    }

    public synchronized int read() throws IOException {
        int b;
        if (this._pos >= this._avail) {
            this.fill();
        }
        if (this._pos >= this._avail) {
            int n = -1;
        } else {
            b = this._buf[this._pos++] & 0xFF;
        }
        return b;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int avail = this._avail - this._pos;
        if (avail <= 0) {
            this.fill();
            avail = this._avail - this._pos;
        }
        if (avail <= 0) {
            len = -1;
        } else {
            len = avail < len ? avail : len;
            System.arraycopy(this._buf, this._pos, b, off, len);
            this._pos += len;
        }
        return len;
    }

    public long skip(long n) throws IOException {
        int avail = this._avail - this._pos;
        if (avail <= 0) {
            this.fill();
            avail = this._avail - this._pos;
        }
        if (avail <= 0) {
            n = 0L;
        } else {
            n = (long)avail < n ? (long)avail : n;
            this._pos = (int)((long)this._pos + n);
        }
        return n;
    }

    public synchronized int available() throws IOException {
        int in_stream = this.in.available();
        if (this._byteLimit >= 0 && in_stream > this._byteLimit) {
            in_stream = this._byteLimit;
        }
        return this._avail - this._pos + in_stream;
    }

    public synchronized void mark(int limit) throws IllegalArgumentException {
        if (limit > this._buf.length) {
            throw new IllegalArgumentException("limit larger than buffer");
        }
        this._mark = this._pos;
    }

    public synchronized void reset() throws IOException {
        if (this._mark < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        if (this._byteLimit >= 0) {
            this._byteLimit += this._pos - this._mark;
        }
        this._pos = this._mark;
        this._mark = -1;
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void fill() throws IOException {
        block21: {
            if (this._mark > 0) {
                saved = this._contents - this._mark;
                System.arraycopy(this._buf, this._mark, this._buf, 0, saved);
                this._pos -= this._mark;
                this._avail -= this._mark;
                this._contents = saved;
                this._mark = 0;
            } else if (this._mark < 0 && this._pos > 0) {
                saved = this._contents - this._pos;
                System.arraycopy(this._buf, this._pos, this._buf, 0, saved);
                this._avail -= this._pos;
                this._contents = saved;
                this._pos = 0;
            } else if (this._mark == 0 && this._pos > 0 && this._contents == this._buf.length) {
                this._mark = -1;
                this.fill();
                return;
            }
            n = 0;
            this._eof = false;
            if (this._byteLimit != 0) ** GOTO lbl52
            this._eof = true;
            break block21;
lbl-1000:
            // 1 sources

            {
                space = this._buf.length - this._contents;
                n = this.in.read(this._buf, this._contents, space);
                if (n <= 0) {
                    if (n == 0) {
                        Thread.yield();
                        b = this.in.read();
                        if (b >= 0) {
                            n = 1;
                            this._buf[this._contents++] = (byte)b;
                        } else {
                            this._eof = true;
                        }
                    } else {
                        this._eof = true;
                    }
                } else {
                    this._contents += n;
                }
                this._avail = this._contents;
                if (this._byteLimit <= 0) continue;
                if (this._contents - this._pos >= this._byteLimit) {
                    this._avail = this._byteLimit + this._pos;
                }
                if (n > this._byteLimit) {
                    this._byteLimit = 0;
                    continue;
                }
                if (n >= 0) {
                    this._byteLimit -= n;
                    continue;
                }
                if (n != -1) continue;
                throw new IOException("Premature EOF");
lbl52:
                // 5 sources

                ** while (!this._eof && n == 0 && this._buf.length > this._contents)
            }
        }
        if (this._avail - this._pos > 0 && this._lastCr && this._buf[this._pos] == 10) {
            ++this._pos;
            if (this._mark >= 0) {
                ++this._mark;
            }
            this._lastCr = false;
            if (this._byteLimit >= 0 && this._newByteLimit) {
                if (this._avail < this._contents) {
                    ++this._avail;
                } else {
                    ++this._byteLimit;
                }
            }
            if (this._pos == this._avail) {
                this.fill();
            }
        }
        this._newByteLimit = false;
    }

    /*
     * Unable to fully structure code
     */
    private int fillLine(int maxLen) throws IOException {
        this._mark = this._pos;
        if (this._pos >= this._avail) {
            this.fill();
        }
        if (this._pos >= this._avail) {
            return -1;
        }
        cr = this._lastCr;
        lf = false;
        this._lastCr = false;
        len = 0;
        ** GOTO lbl58
        {
            if (this._eof || this._mark == 0 && this._contents == this._buf.length) {
                this._lastCr = this._eof == false && this._buf[this._avail - 1] == 13;
                cr = true;
                lf = true;
                break;
            }
            if (cr && this.in.available() == 0) {
                this._lastCr = true;
                cr = true;
                lf = true;
                break;
            }
            this._pos = this._mark;
            this.fill();
            this._pos = len;
            cr = false;
            block5: do {
                if (this._pos == this._avail) continue block4;
                b = this._buf[this._pos++];
                switch (b) {
                    case 10: {
                        lf = true;
                        break block4;
                    }
                    case 13: {
                        if (cr && this._pos > 1) {
                            --this._pos;
                            break block4;
                        }
                        cr = true;
                        break;
                    }
                    default: {
                        if (cr) {
                            if (this._pos == 1) {
                                cr = false;
                            } else {
                                --this._pos;
                                break block4;
                            }
                        }
                        if (++len != maxLen) continue block5;
                        if (this._mark != 0 && this._pos + 2 >= this._avail && this._avail < this._buf.length) {
                            this.fill();
                        }
                        if (this._pos < this._avail && this._buf[this._pos] == 13) {
                            cr = true;
                            ++this._pos;
                        }
                        if (this._pos < this._avail && this._buf[this._pos] == 10) {
                            lf = true;
                            ++this._pos;
                        }
                        if (cr || lf) break block4;
                        lf = true;
                        cr = true;
                        break block4;
                    }
                }
lbl58:
                // 3 sources

            } while (this._pos <= this._avail);
        }
        if (!cr && !lf && len == 0) {
            len = -1;
        }
        return len;
    }

    public LineInput(InputStream in) {
        this(in, 0);
    }

    public LineInput(InputStream in, int bufferSize) {
        super(in);
        if (bufferSize == 0) {
            bufferSize = 2048;
        }
        this._buf = new byte[bufferSize];
        this._byteBuffer = new ByteBuffer(this._buf);
        this._lineBuffer = new LineBuffer(bufferSize);
        this._reader = new InputStreamReader(this._byteBuffer);
    }

    public LineInput(InputStream in, int bufferSize, String encoding) throws UnsupportedEncodingException {
        super(in);
        if (bufferSize == 0) {
            bufferSize = 2048;
        }
        this._buf = new byte[bufferSize];
        this._byteBuffer = new ByteBuffer(this._buf);
        this._lineBuffer = new LineBuffer(bufferSize);
        this._reader = new InputStreamReader((InputStream)this._byteBuffer, encoding);
        this._encoding = encoding;
    }

    private static class ByteBuffer
    extends ByteArrayInputStream {
        void setStream(int offset, int length) {
            this.pos = offset;
            this.count = offset + length;
            this.mark = -1;
        }

        ByteBuffer(byte[] buffer) {
            super(buffer);
        }
    }

    public static class LineBuffer {
        public char[] buffer;
        public int size;

        public String toString() {
            return new String(this.buffer, 0, this.size);
        }

        public LineBuffer(int maxLineLength) {
            this.buffer = new char[maxLineLength];
        }
    }
}

