/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.mortbay.util.Resource;

class FileResource
extends Resource {
    private static boolean __checkAliases = "true".equalsIgnoreCase(System.getProperty("org.mortbay.util.FileResource.checkAliases", File.separatorChar == '/' ? "false" : "true"));
    private File _file;
    private String _alias = null;

    public boolean exists() {
        return this._file.exists() && this._alias == null;
    }

    public long lastModified() {
        return this._file.lastModified();
    }

    public boolean isDirectory() {
        return this._file.isDirectory() && this._alias == null;
    }

    public long length() {
        return this._file.length();
    }

    public String getName() {
        return this._file.getAbsolutePath();
    }

    public File getFile() {
        if (this._alias != null) {
            return null;
        }
        return this._file;
    }

    public InputStream getInputStream() throws IOException {
        if (this._alias != null) {
            throw new FileNotFoundException(this._alias);
        }
        return new FileInputStream(this._file);
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        if (this._alias != null) {
            throw new FileNotFoundException(this._alias);
        }
        return new FileOutputStream(this._file);
    }

    public boolean delete() throws SecurityException {
        if (this._alias != null) {
            throw new SecurityException(this._alias);
        }
        return this._file.delete();
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        if (this._alias != null) {
            throw new SecurityException(this._alias);
        }
        if (dest instanceof FileResource) {
            return this._file.renameTo(((FileResource)dest)._file);
        }
        return false;
    }

    public String[] list() {
        return this._file.list();
    }

    public boolean equals(Object o) {
        return o instanceof FileResource && this._file.equals(((FileResource)o)._file);
    }

    FileResource(URL url, URLConnection connection, File file) {
        super(url, connection);
        this._file = file;
        if (__checkAliases) {
            try {
                String abs = this._file.getAbsolutePath();
                String can = this._file.getCanonicalPath();
                if (!abs.equals(can)) {
                    this._alias = abs + " is alias of " + can;
                }
                if (this._alias != null && Code.debug()) {
                    Code.debug((Object)"ALIAS abs=", (Object)abs);
                    Code.debug((Object)"ALIAS can=", (Object)can);
                }
            }
            catch (IOException e) {
                Code.ignore(e);
            }
        }
    }

    static {
        if (__checkAliases) {
            Log.event("Checking Resource aliases");
        }
    }
}

