/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.mortbay.util.Code;

public class DateCache {
    private String formatString;
    private SimpleDateFormat minuteFormat;
    private SimpleDateFormat format;
    private boolean millis = false;
    private long lastMinutes = -1L;
    private long lastSeconds = -1L;
    private String lastResult = null;

    private String mFormat(String format) {
        int i = format.indexOf("ss.SSS");
        int l = 6;
        if (i >= 0) {
            this.millis = true;
        } else {
            l = 2;
            i = format.indexOf("ss");
        }
        Code.assert(i >= 0, "No seconds in format");
        String ss1 = format.substring(0, i);
        String ss2 = format.substring(i + l);
        String mFormat = (i > 0 ? "@" + ss1 + "@" : "") + (l == 2 ? "'ss'" : "'ss.SSS'") + (ss2.length() > 0 ? "@" + ss2 + "@" : "");
        return mFormat;
    }

    public synchronized String format(Date inDate) {
        return this.format(inDate.getTime());
    }

    public synchronized String format(long inDate) {
        long seconds = inDate / 1000L;
        if (this.lastSeconds == seconds && !this.millis) {
            return this.lastResult;
        }
        Date d = new Date(inDate);
        long minutes = seconds / 60L;
        if (this.lastMinutes != minutes) {
            this.format = new SimpleDateFormat(this.minuteFormat.format(d).replace('@', '\''));
            this.lastMinutes = minutes;
        }
        this.lastSeconds = seconds;
        this.lastResult = this.format.format(d);
        return this.lastResult;
    }

    public SimpleDateFormat getFormat() {
        return this.minuteFormat;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setTimeZone(TimeZone tz) {
        this.minuteFormat.setTimeZone(tz);
        if (this.format != null) {
            this.format.setTimeZone(tz);
        }
    }

    public DateCache() {
        this("EEE MMM dd HH:mm:ss zzz yyyy");
        this.getFormat().setTimeZone(TimeZone.getDefault());
    }

    public DateCache(String format) {
        this.formatString = format;
        this.minuteFormat = new SimpleDateFormat(this.mFormat(format));
    }

    public DateCache(String format, Locale l) {
        this.formatString = format;
        this.minuteFormat = new SimpleDateFormat(this.mFormat(format), l);
    }

    public DateCache(String format, DateFormatSymbols s) {
        this.formatString = format;
        this.minuteFormat = new SimpleDateFormat(this.mFormat(format), s);
    }
}

