/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;

public class ByteArrayISO8859Writer
extends Writer {
    private byte[] _buf;
    private int _size;
    private ByteArrayOutputStream2 _bout = null;
    private OutputStreamWriter _writer = null;

    public int capacity() {
        return this._buf.length;
    }

    public int length() {
        return this._size;
    }

    public byte[] getBuf() {
        return this._buf;
    }

    public int getCapacity() {
        return this._buf.length;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buf, 0, this._size);
    }

    public void write(char c) throws IOException {
        this.ensureCapacity(1);
        if (c >= '\u0000' && c <= '\u007f') {
            this._buf[this._size++] = (byte)c;
        } else {
            char[] ca = new char[]{c};
            this.writeEncoded(ca, 0, 1);
        }
    }

    public void write(char[] ca) throws IOException {
        this.ensureCapacity(ca.length);
        int i = 0;
        while (i < ca.length) {
            char c = ca[i];
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(ca, i, ca.length - i);
                break;
            }
            this._buf[this._size++] = (byte)c;
            ++i;
        }
    }

    public void write(char[] ca, int offset, int length) throws IOException {
        this.ensureCapacity(length);
        int i = 0;
        while (i < length) {
            char c = ca[offset + i];
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(ca, offset + i, length - i);
                break;
            }
            this._buf[this._size++] = (byte)c;
            ++i;
        }
    }

    public void write(String s) throws IOException {
        int length = s.length();
        this.ensureCapacity(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(s.toCharArray(), i, length - i);
                break;
            }
            this._buf[this._size++] = (byte)c;
            ++i;
        }
    }

    public void write(String s, int offset, int length) throws IOException {
        this.ensureCapacity(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(offset + i);
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(s.toCharArray(), offset + i, length - i);
                break;
            }
            this._buf[this._size++] = (byte)c;
            ++i;
        }
    }

    private void writeEncoded(char[] ca, int offset, int length) throws IOException {
        if (this._bout == null) {
            Code.debug((Object)"Using OutputStreamWriter for ", (Object)ca);
            this._bout = new ByteArrayOutputStream2(2 * length);
            this._writer = new OutputStreamWriter((OutputStream)this._bout, StringUtil.__ISO_8859_1);
        } else {
            this._bout.reset();
        }
        this._writer.write(ca, offset, length);
        this._writer.flush();
        this.ensureCapacity(this._bout.getCount());
        System.arraycopy(this._bout.getBuf(), 0, this._buf, this._size, this._bout.getCount());
        this._size += this._bout.getCount();
    }

    public void flush() {
    }

    public void reset() {
        this._size = 0;
    }

    public void close() {
    }

    public void ensureCapacity(int n) {
        if (this._size + n > this._buf.length) {
            byte[] buf = new byte[(this._buf.length + n) * 4 / 3];
            System.arraycopy(this._buf, 0, buf, 0, this._size);
            this._buf = buf;
        }
    }

    public ByteArrayISO8859Writer() {
        this(4096);
    }

    public ByteArrayISO8859Writer(int capacity) {
        this._buf = new byte[capacity];
    }
}

