/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpFields;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.LineInput;
import org.mortbay.util.StringUtil;

public class CGI
extends HttpServlet {
    protected File _docRoot;
    protected String _path;

    public void init() throws ServletException {
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp == null) {
            tmp = this.getServletContext().getRealPath("/");
        }
        Code.debug("CGI: CGI bin " + tmp);
        if (tmp == null) {
            Code.warning("CGI: no CGI bin !");
            throw new ServletException();
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            Code.warning("CGI: CGI bin does not exist - " + dir);
            throw new ServletException();
        }
        if (!dir.canRead()) {
            Code.warning("CGI: CGI bin is not readable - " + dir);
            throw new ServletException();
        }
        if (!dir.isDirectory()) {
            Code.warning("CGI: CGI bin is not a directory - " + dir);
            throw new ServletException();
        }
        try {
            this._docRoot = dir.getCanonicalFile();
            Code.debug("CGI: CGI bin accepted - " + this._docRoot);
        }
        catch (IOException e) {
            Code.warning("CGI: CGI bin failed - " + dir);
            e.printStackTrace();
            throw new ServletException();
        }
        this._path = this.getInitParameter("Path");
        Code.debug("CGI: PATH accepted - " + this._path);
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String both;
        Code.debug((Object)"CGI: req.getContextPath() : ", (Object)req.getContextPath());
        Code.debug((Object)"CGI: req.getServletPath() : ", (Object)req.getServletPath());
        Code.debug((Object)"CGI: req.getPathInfo()    : ", (Object)req.getPathInfo());
        Code.debug("CGI: System.Properties : " + ((Hashtable)System.getProperties()).toString());
        String first = both = req.getPathInfo();
        String last = "";
        File exe = new File(this._docRoot, first);
        while ((first.endsWith("/") || !exe.exists()) && first.length() >= 0) {
            int index = first.lastIndexOf(47);
            first = first.substring(0, index);
            last = both.substring(index, both.length());
            exe = new File(this._docRoot, first);
        }
        if (first.length() == 0 || !exe.exists()) {
            res.sendError(404);
        }
        exe = exe.getCanonicalFile();
        Code.debug("CGI: script is " + exe);
        Code.debug("CGI: pathInfo is " + last);
        this.exec(exe.toString(), last, req, res);
    }

    private void exec(String path, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        Code.debug("CGI: execing : " + path);
        String[] env = new String[]{"AUTH_TYPE=" + StringUtil.nonNull(req.getAuthType()), "CONTENT_LENGTH=" + req.getContentLength(), "CONTENT_TYPE=" + StringUtil.nonNull(req.getContentType()), "GATEWAY_INTERFACE=CGI/1.1", "PATH_INFO=" + StringUtil.nonNull(pathInfo), "PATH_TRANSLATED=" + StringUtil.nonNull(req.getPathTranslated()), "QUERY_STRING=" + StringUtil.nonNull(req.getQueryString()), "REMOTE_ADDR=" + req.getRemoteAddr(), "REMOTE_HOST=" + req.getRemoteHost(), "REMOTE_USER=" + StringUtil.nonNull(req.getRemoteUser()), "REQUEST_METHOD=" + req.getMethod(), "SCRIPT_NAME=" + req.getRequestURI().substring(0, req.getRequestURI().length() - pathInfo.length()), "SERVER_NAME=" + req.getServerName(), "SERVER_PORT=" + req.getServerPort(), "SERVER_PROTOCOL=" + req.getProtocol(), "SERVER_SOFTWARE=" + this.getServletContext().getServerInfo(), "HTTP_ACCEPT=" + StringUtil.nonNull(req.getHeader("Accept")), "HTTP_ACCEPT_CHARSET=" + StringUtil.nonNull(req.getHeader("Accept-Charset")), "HTTP_ACCEPT_ENCODING=" + StringUtil.nonNull(req.getHeader("Accept-Encoding")), "HTTP_ACCEPT_LANGUAGE=" + StringUtil.nonNull(req.getHeader("Accept-Language")), "HTTP_FORWARDED=" + StringUtil.nonNull(req.getHeader("Forwarded")), "HTTP_HOST=" + StringUtil.nonNull(req.getHeader("Host")), "HTTP_PROXY_AUTHORIZATION=" + StringUtil.nonNull(req.getHeader("Proxy-Authorization")), "HTTP_REFERRER=" + StringUtil.nonNull(req.getHeader("Referer")), "HTTP_USER_AGENT=" + StringUtil.nonNull(req.getHeader("User-Agent")), "HTTP_PRAGMA=" + StringUtil.nonNull(req.getHeader("Pragma")), "HTTP_COOKIE=" + StringUtil.nonNull(req.getHeader("Cookie")), "HTTPS=" + (req.isSecure() ? "ON" : "OFF"), "PATH=" + this._path};
        Process p = Runtime.getRuntime().exec(path, env);
        ServletInputStream inFromReq = req.getInputStream();
        OutputStream outToCgi = p.getOutputStream();
        int inputLength = req.getContentLength();
        new Thread(new Runnable(this, inputLength, (InputStream)inFromReq, outToCgi){
            private final /* synthetic */ CGI this$0;
            private final /* synthetic */ int val$inputLength;
            private final /* synthetic */ InputStream val$inFromReq;
            private final /* synthetic */ OutputStream val$outToCgi;

            public void run() {
                try {
                    if (this.val$inputLength > 0) {
                        IO.copy(this.val$inFromReq, this.val$outToCgi, (long)this.val$inputLength);
                    }
                    this.val$outToCgi.close();
                }
                catch (IOException e) {
                    Code.ignore(e);
                }
            }
            {
                this.val$inputLength = val$inputLength;
                this.val$inFromReq = val$inFromReq;
                this.val$outToCgi = val$outToCgi;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(CGI cGI) {
            }
        }).start();
        try {
            LineInput li = new LineInput(p.getInputStream());
            HttpFields fields = new HttpFields();
            fields.read(li);
            String ContentStatus = "Status";
            String location = fields.get("Content-Location");
            String status = fields.get(ContentStatus);
            if (status != null) {
                Code.debug("Found a Status header - setting status on response");
                fields.remove(ContentStatus);
                int i = status.indexOf(32);
                if (i > 0) {
                    status = status.substring(0, i);
                }
                res.setStatus(Integer.parseInt(status));
            }
            Enumeration headers = fields.getFieldNames();
            while (headers.hasMoreElements()) {
                String key = headers.nextElement().toString();
                String val = fields.get(key).toString();
                res.setHeader(key, val);
            }
            IO.copy(li, (OutputStream)res.getOutputStream());
        }
        catch (IOException e) {
            Code.debug("CGI: Client closed connection!");
            p.destroy();
        }
    }
}

