/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import org.mortbay.http.HandlerContext;
import org.mortbay.http.HttpServer;
import org.mortbay.jetty.servlet.ServletHandlerContext;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.Code;
import org.mortbay.util.Log;
import org.mortbay.util.Resource;
import org.mortbay.xml.XmlConfiguration;

public class Server
extends HttpServer {
    private String _configuration;
    private static /* synthetic */ Class class$Ljava$lang$Thread;
    private static /* synthetic */ Class class$Ljava$lang$Runtime;

    public void configure(String configuration) throws IOException {
        if (this._configuration != null) {
            throw new IllegalStateException("Already configured with " + this._configuration);
        }
        URL url = Resource.newResource(configuration).getURL();
        this._configuration = url.toString();
        try {
            XmlConfiguration config = new XmlConfiguration(url);
            config.configure(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IOException("Jetty configuration problem: " + e);
        }
    }

    public String getConfiguration() {
        return this._configuration;
    }

    protected HandlerContext newHandlerContext(String contextPathSpec) {
        return new ServletHandlerContext(this, contextPathSpec);
    }

    public WebApplicationContext addWebApplication(String contextPathSpec, String webApp, String defaults) throws IOException {
        return this.addWebApplication(null, contextPathSpec, webApp, defaults, false);
    }

    public WebApplicationContext addWebApplication(String contextPathSpec, String webApp, String defaults, boolean extractWar) throws IOException {
        return this.addWebApplication(null, contextPathSpec, webApp, defaults, extractWar);
    }

    public WebApplicationContext addWebApplication(String host, String contextPathSpec, String webApp, String defaults, boolean extractWar) throws IOException {
        WebApplicationContext appContext = new WebApplicationContext(this, contextPathSpec, webApp, defaults, extractWar);
        this.addContext(host, appContext);
        Log.event("Web Application " + appContext + " added");
        return appContext;
    }

    public static void main(String[] arg) {
        String[] dftConfig = new String[]{"etc/jetty.xml"};
        if (arg.length == 0) {
            System.err.println("Using default configuration: etc/jetty.xml");
            arg = dftConfig;
        }
        Server[] servers = new Server[arg.length];
        int i = 0;
        while (i < arg.length) {
            try {
                servers[i] = new Server(arg[i]);
                servers[i].start();
            }
            catch (Exception e) {
                Code.warning(e);
            }
            ++i;
        }
        Thread hook = new Thread(servers){
            private final /* synthetic */ Server[] val$servers;

            public void run() {
                Log.event("Shutdown hook executing");
                int i = 0;
                while (i < this.val$servers.length) {
                    try {
                        this.val$servers[i].stop();
                    }
                    catch (Exception e) {
                        Code.warning(e);
                    }
                    ++i;
                }
            }
            {
                this.val$servers = val$servers;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        try {
            Method shutdownhook = (class$Ljava$lang$Runtime != null ? class$Ljava$lang$Runtime : (class$Ljava$lang$Runtime = Server.class$("java.lang.Runtime"))).getMethod("addShutdownHook", class$Ljava$lang$Thread != null ? class$Ljava$lang$Thread : (class$Ljava$lang$Thread = Server.class$("java.lang.Thread")));
            shutdownhook.invoke((Object)Runtime.getRuntime(), hook);
        }
        catch (Exception e) {
            Code.debug("No shutdown hook", e);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Server() {
    }

    public Server(String configuration) throws IOException {
        this(Resource.newResource(configuration).getURL());
    }

    public Server(Resource configuration) throws IOException {
        this(configuration.getURL());
    }

    public Server(URL configuration) throws IOException {
        this._configuration = configuration.toString();
        try {
            XmlConfiguration config = new XmlConfiguration(configuration);
            config.configure(this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Code.warning(e);
            throw new IOException("Jetty configuration problem: " + e);
        }
    }
}

