/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.http.handler.NullHandler;
import org.mortbay.util.B64Code;
import org.mortbay.util.Code;
import org.mortbay.util.StringUtil;

public class SecurityHandler
extends NullHandler {
    public static final String __BASIC_AUTH = "BASIC";
    public static final String __FORM_AUTH = "FORM";
    public static final String __ATTR = "org.mortbay.J.H.SecurityHandler";
    PathMap _constraintMap = new PathMap();
    String _authMethod = "BASIC";
    Map _authRealmMap;
    String _realmName;
    UserRealm _realm;
    String _formLoginPage;
    String _formErrorPage;
    FormAuthenticator _formAuthenticator;

    public UserRealm getUserRealm() {
        return this._realm;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
        if (this.isStarted()) {
            throw new IllegalStateException("Handler started");
        }
        this._realmName = realmName;
    }

    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String method) {
        if (this.isStarted()) {
            throw new IllegalStateException("Handler started");
        }
        if (!__BASIC_AUTH.equals(method) && !__FORM_AUTH.equals(method)) {
            throw new IllegalArgumentException("Not supported: " + method);
        }
        this._authMethod = method;
    }

    public String getLoginPage() {
        return this._formLoginPage;
    }

    public void setLoginPage(String page) {
        if (!page.startsWith("/")) {
            page = "/" + page;
        }
        this._formLoginPage = page;
    }

    public String getErrorPage() {
        return this._formErrorPage;
    }

    public void setErrorPage(String page) {
        if (!page.startsWith("/")) {
            page = "/" + page;
        }
        this._formErrorPage = page;
    }

    public void addSecurityConstraint(String pathSpec, SecurityConstraint sc) {
        ArrayList<SecurityConstraint> scs = (ArrayList<SecurityConstraint>)this._constraintMap.get(pathSpec);
        if (scs == null) {
            scs = new ArrayList<SecurityConstraint>(2);
            this._constraintMap.put(pathSpec, scs);
        }
        scs.add(sc);
        Code.debug((Object)"added ", sc, (Object)" at ", pathSpec);
    }

    public void start() throws Exception {
        if (this._realmName != null && this._realmName.length() > 0) {
            this._realm = this.getHandlerContext().getHttpServer().getRealm(this._realmName);
            super.start();
            if (this._realm == null) {
                Code.warning("Unknown realm: " + this._realmName + " for " + this);
            }
        } else if (this._constraintMap.size() > 0) {
            Iterator i = this._constraintMap.values().iterator();
            while (i.hasNext()) {
                Iterator j = ((AbstractList)((ArrayList)i.next())).iterator();
                while (j.hasNext()) {
                    SecurityConstraint sc = (SecurityConstraint)j.next();
                    if (!sc.isAuthenticated()) continue;
                    Code.warning("No Realm set for " + this);
                    super.start();
                    return;
                }
            }
        }
        if (__FORM_AUTH.equals(this._authMethod)) {
            if (this._formLoginPage == null || this._formLoginPage.equals("") || this._formErrorPage == null || this._formErrorPage.equals("") || this._realm == null) {
                Code.warning("Form realm, login and/or error page not set correctly");
            } else {
                try {
                    Iterator iter = this.getHandlerContext().getHandlers().iterator();
                    while (iter.hasNext()) {
                        HttpHandler handler = (HttpHandler)iter.next();
                        if (!(handler instanceof FormAuthenticator)) continue;
                        this._formAuthenticator = (FormAuthenticator)((Object)handler);
                        Code.debug((Object)"FormAuthenticator=", (Object)this._formAuthenticator);
                        break;
                    }
                }
                catch (Exception e) {
                    Code.warning("Failed to initialize FORM auth", e);
                }
                if (this._formAuthenticator == null) {
                    Code.warning("FormAuthenticator HttpHandler is required for FORM authentication");
                }
            }
        }
        super.start();
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        List scss = this._constraintMap.getMatches(pathInContext);
        if (scss != null) {
            Code.debug((Object)"Security Constraint on ", pathInContext, (Object)" against ", scss);
            int m = 0;
            while (m < scss.size()) {
                Map.Entry entry = (Map.Entry)scss.get(m);
                if (Code.verbose()) {
                    Code.debug((Object)"Check ", pathInContext, (Object)" against ", entry);
                }
                List scs = (List)entry.getValue();
                int c = 0;
                while (c < scs.size()) {
                    SecurityConstraint sc = (SecurityConstraint)scs.get(c);
                    if (sc.forMethod(request.getMethod())) {
                        if (!sc.isAuthenticated() && !sc.hasDataConstraint()) {
                            response.sendError(403);
                            return;
                        }
                        if (sc.isAuthenticated() && !sc.hasRole("NONE") && !this.authenticatedInRole(pathInContext, pathParams, request, response, sc.roles())) {
                            return;
                        }
                        if (!sc.hasDataConstraint() || "https".equalsIgnoreCase(request.getScheme())) break;
                        response.sendError(403);
                        return;
                    }
                    ++c;
                }
                ++m;
            }
        }
        if (this._formAuthenticator != null && pathInContext.endsWith("j_security_check")) {
            Code.debug("FORM j_security_check");
            this._formAuthenticator.formAuthenticated(this, pathInContext, pathParams, request, response);
        }
    }

    private boolean authenticatedInRole(String pathInContext, String pathParams, HttpRequest request, HttpResponse response, Iterator roles) throws IOException {
        boolean userAuth = false;
        if (__BASIC_AUTH.equals(this._authMethod)) {
            userAuth = this.basicAuthenticated(request, response);
        } else {
            if (__FORM_AUTH.equals(this._authMethod)) {
                if (this._formAuthenticator == null) {
                    response.sendError(500);
                    return false;
                }
                return this._formAuthenticator.formAuthenticated(this, pathInContext, pathParams, request, response);
            }
            response.setField("WWW-Authenticate", "basic realm=\"" + this._realmName + "\"");
            response.sendError(401);
        }
        if (!userAuth) {
            return false;
        }
        boolean inRole = false;
        while (roles.hasNext()) {
            String role = roles.next().toString();
            if (!request.isUserInRole(role)) continue;
            inRole = true;
            break;
        }
        if (!inRole) {
            Code.warning("AUTH FAILURE: role for " + request.getUserPrincipal().getName());
            if (__BASIC_AUTH.equals(this._authMethod)) {
                response.setField("WWW-Authenticate", "basic realm=\"" + this._realmName + "\"");
                response.sendError(401);
            } else if (__FORM_AUTH.equals(this._authMethod)) {
                response.sendRedirect(this._formErrorPage);
            } else {
                response.sendError(403);
            }
            return false;
        }
        return userAuth && inRole;
    }

    private boolean basicAuthenticated(HttpRequest request, HttpResponse response) throws IOException {
        String credentials = request.getField("Authorization");
        if (credentials != null) {
            Code.debug("Credentials: " + credentials);
            credentials = credentials.substring(credentials.indexOf(32) + 1);
            credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1);
            int i = credentials.indexOf(58);
            String username = credentials.substring(0, i);
            String password = credentials.substring(i + 1);
            if (this._realm != null) {
                UserPrincipal user = this._realm.getUser(username, request);
                if (user != null && user.authenticate(password)) {
                    request.setAttribute("org.mortbay.http.HttpRequest.AuthType", __BASIC_AUTH);
                    request.setAttribute("org.mortbay.http.HttpRequest.AuthUser", username);
                    request.setAttribute("org.mortbay.http.UserPrincipal", user);
                    return true;
                }
                Code.warning("AUTH FAILURE: user " + username);
            }
        }
        Code.debug("Unauthorized in " + this._realmName);
        response.setField("WWW-Authenticate", "basic realm=\"" + this._realmName + "\"");
        response.sendError(401);
        return false;
    }

    public synchronized void addUser(String username, String password) {
        Code.warning("addUser deprecated, use HttpServer.addRealm()");
    }

    public static interface FormAuthenticator {
        public static final String __J_SECURITY_CHECK = "j_security_check";
        public static final String __J_USERNAME = "j_username";
        public static final String __J_PASSWORD = "j_password";

        public boolean formAuthenticated(SecurityHandler var1, String var2, String var3, HttpRequest var4, HttpResponse var5) throws IOException;
    }
}

