/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.NullHandler;
import org.mortbay.util.B64Code;
import org.mortbay.util.Code;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;
import org.mortbay.util.UnixCrypt;

public class HTAccessHandler
extends NullHandler {
    String _default = "./etc/htaccess";
    String _accessFile = ".htaccess";
    HashMap _htCache = new HashMap();

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block16: {
            String user = null;
            String password = null;
            boolean doCheck = false;
            boolean IPValid = true;
            boolean l_ret = false;
            boolean _requireUser = false;
            Code.debug((Object)"HTAccessHandler pathInContext=", (Object)pathInContext);
            String credentials = request.getField("Authorization");
            if (credentials != null) {
                credentials = credentials.substring(credentials.indexOf(32) + 1);
                credentials = B64Code.decode(credentials, StringUtil.__ISO_8859_1);
                int i = credentials.indexOf(58);
                user = credentials.substring(0, i);
                password = credentials.substring(i + 1);
                Code.debug("User=" + user + ", password=" + password);
            }
            HTAccess ht = null;
            try {
                Resource baseResource = this.getHandlerContext().getBaseResource();
                if (baseResource == null) {
                    return;
                }
                Resource reqResource = baseResource.addPath(pathInContext);
                Resource resource = reqResource;
                if (!resource.isDirectory()) {
                    pathInContext = URI.parentPath(pathInContext);
                } else if (!pathInContext.endsWith("/")) {
                    pathInContext = pathInContext + "/";
                }
                while (pathInContext != null) {
                    resource = baseResource.addPath(pathInContext + this._accessFile);
                    Code.debug((Object)"pathInContext=", pathInContext, (Object)" resource=", resource);
                    if (resource.exists() && !resource.isDirectory()) break;
                    resource = null;
                    pathInContext = URI.parentPath(pathInContext);
                }
                if (resource == null && this._default != null && (!(resource = Resource.newResource(this._default)).exists() || resource.isDirectory())) {
                    return;
                }
                Code.debug((Object)"HTACCESS=", (Object)resource);
                ht = (HTAccess)this._htCache.get(resource);
                if (ht == null || ht.getLastModified() != resource.lastModified()) {
                    Code.debug("HTCache Miss");
                    ht = new HTAccess(resource);
                    this._htCache.put(resource, ht);
                }
                if (!ht.getMethods().containsKey(request.getMethod())) {
                    return;
                }
                int satisfy = ht.getSatisfy();
                IPValid = ht.checkAccess("", request.getRemoteAddr());
                Code.debug("IPValid = " + IPValid);
                if (IPValid && satisfy == 0) {
                    return;
                }
                if (!IPValid && satisfy == 1) {
                    response.sendError(403);
                    request.setHandled(true);
                    return;
                }
                if (!ht.checkAuth(user, password)) {
                    Code.debug("Auth Failed");
                    _requireUser = true;
                    response.setField("WWW-Authenticate", "basic realm=" + ht.getName());
                    response.sendError(401);
                    response.commit();
                    request.setHandled(true);
                    return;
                }
                if (user != null) {
                    request.setAttribute("org.mortbay.http.HttpRequest.AuthType", "BASIC");
                    request.setAttribute("org.mortbay.http.HttpRequest.AuthUser", user);
                }
                if (reqResource.equals(resource) || reqResource.equals(ht.getUserResource()) || reqResource.equals(ht.getGroupResource())) {
                    response.sendError(403);
                    request.setHandled(true);
                    return;
                }
            }
            catch (Exception ex) {
                Code.warning(ex);
                if (ht == null) break block16;
                response.sendError(500);
                request.setHandled(true);
            }
        }
    }

    public void setDefault(String dir) {
        this._default = dir;
    }

    public void setAccessFile(String anArg) {
        this._accessFile = anArg == null ? new String(".htaccess") : new String(anArg);
    }

    private static class HTAccess {
        static final int ANY = 0;
        static final int ALL = 1;
        static final String USER = "user";
        static final String GROUP = "group";
        static final String VALID_USER = "valid-user";
        String _userFile;
        Resource _userResource;
        HashMap _users = null;
        long _userModified;
        String _groupFile;
        Resource _groupResource;
        HashMap _groups = null;
        long _groupModified;
        int _satisfy = 0;
        String _type;
        String _name;
        HashMap _methods = new HashMap();
        HashMap _requireEntities = new HashMap();
        String _requireName;
        int _order;
        ArrayList _allowList = new ArrayList();
        ArrayList _denyList = new ArrayList();
        long _lastModified;

        public HashMap getMethods() {
            return this._methods;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public Resource getUserResource() {
            return this._userResource;
        }

        public Resource getGroupResource() {
            return this._groupResource;
        }

        public int getSatisfy() {
            return this._satisfy;
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public boolean checkAccess(String host, String ip) {
            char c;
            String elm;
            boolean alp = false;
            boolean dep = false;
            if (this._allowList.size() == 0 && this._denyList.size() == 0) {
                return true;
            }
            int i = 0;
            while (i < this._allowList.size()) {
                elm = (String)this._allowList.get(i);
                if (elm.equals("all")) {
                    alp = true;
                    break;
                }
                c = elm.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (ip.startsWith(elm)) {
                        alp = true;
                        break;
                    }
                } else if (host.endsWith(elm)) {
                    alp = true;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this._denyList.size()) {
                elm = (String)this._denyList.get(i);
                if (elm.equals("all")) {
                    dep = true;
                    break;
                }
                c = elm.charAt(0);
                if (c >= '0' && c <= '9') {
                    if (ip.startsWith(elm)) {
                        dep = true;
                        break;
                    }
                } else if (host.endsWith(elm)) {
                    dep = true;
                    break;
                }
                ++i;
            }
            if (this._order != 0) {
                if (this._order > 0) {
                    return alp && !dep;
                }
                return !dep || alp;
            }
            return alp && !dep;
        }

        public boolean checkAuth(String user, String pass) {
            String code;
            if (this._requireName == null) {
                return true;
            }
            if (this._requireName.equals(USER)) {
                Iterator i = this._requireEntities.keySet().iterator();
                while (i.hasNext()) {
                    if (!user.equals((String)i.next())) continue;
                    String code2 = this.getUserCode(user);
                    if (code2 == null) break;
                    if (code2.equals("") && pass.equals("")) {
                        return true;
                    }
                    if (code2.equals(UnixCrypt.crypt(pass, code2))) {
                        return true;
                    }
                    break;
                }
            } else if (this._requireName.equals(GROUP)) {
                ArrayList gps = this.getUserGroups(user);
                if (gps != null) {
                    Iterator i = this._requireEntities.keySet().iterator();
                    while (i.hasNext()) {
                        if (!gps.contains(i.next())) continue;
                        String code3 = this.getUserCode(user);
                        if (code3 != null) {
                            if (code3.equals("") && pass.equals("")) {
                                return true;
                            }
                            if (code3.equals(UnixCrypt.crypt(pass, code3))) {
                                return true;
                            }
                        }
                        break;
                    }
                }
            } else if (this._requireName.equals(VALID_USER) && (code = this.getUserCode(user)) != null) {
                if (code.equals("") && pass.equals("")) {
                    return true;
                }
                if (code.equals(UnixCrypt.crypt(pass, code))) {
                    return true;
                }
            }
            return false;
        }

        public boolean isAccessLimited() {
            return this._allowList.size() > 0 || this._denyList.size() > 0;
        }

        public boolean isAuthLimited() {
            return this._requireName != null;
        }

        /*
         * Loose catch block
         */
        private String getUserCode(String user) {
            block14: {
                if (this._userResource == null) {
                    return null;
                }
                if (this._users == null || this._userModified != this._userResource.lastModified()) {
                    String line;
                    Code.debug((Object)"LOAD ", (Object)this._userResource);
                    this._users = new HashMap();
                    DataInputStream ufin = null;
                    ufin = new DataInputStream(this._userResource.getInputStream());
                    this._userModified = this._userResource.lastModified();
                    while ((line = ufin.readLine()) != null) {
                        int spos;
                        String string;
                        if ((string = string.trim()).startsWith("#") || (spos = string.indexOf(58)) < 0) continue;
                        String u = string.substring(0, spos).trim();
                        String p = string.substring(spos + 1).trim();
                        this._users.put(u, p);
                    }
                    Object var4_10 = null;
                    try {
                        if (ufin != null) {
                            ufin.close();
                        }
                        break block14;
                    }
                    catch (IOException e2) {
                        Code.warning(e2);
                    }
                    break block14;
                    {
                        catch (IOException e) {
                            Code.warning(e);
                            Object var4_11 = null;
                            try {
                                if (ufin != null) {
                                    ufin.close();
                                }
                                break block14;
                            }
                            catch (IOException e2) {
                                Code.warning(e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_12 = null;
                        try {
                            if (ufin != null) {
                                ufin.close();
                            }
                        }
                        catch (IOException e2) {
                            Code.warning(e2);
                        }
                        throw throwable;
                    }
                }
            }
            return (String)this._users.get(user);
        }

        /*
         * Unable to fully structure code
         */
        private ArrayList getUserGroups(String group) {
            block15: {
                if (this._groupResource == null) {
                    return null;
                }
                if (this._groups != null && this._groupModified == this._groupResource.lastModified()) break block15;
                Code.debug((Object)"LOAD ", (Object)this._groupResource);
                this._groups = new HashMap<K, V>();
                ufin = null;
                ufin = new DataInputStream(this._groupResource.getInputStream());
                this._groupModified = this._groupResource.lastModified();
                while ((line = ufin.readLine()) != null) {
                    if ((var6_3 = var6_3.trim()).startsWith("#") || var6_3.length() == 0 || !(tok = new StringTokenizer(var6_3, ": \t")).hasMoreTokens()) continue;
                    g = tok.nextToken();
                    if (tok.hasMoreTokens()) ** GOTO lbl24
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        u = tok.nextToken();
                        gl = (ArrayList<String>)this._groups.get(u);
                        if (gl == null) {
                            gl = new ArrayList<String>();
                            this._groups.put(u, gl);
                        }
                        gl.add(g);
lbl24:
                        // 2 sources

                        ** while (tok.hasMoreTokens())
                    }
lbl25:
                    // 1 sources

                }
                var4_11 = null;
                try {
                    if (ufin != null) {
                        ufin.close();
                    }
                    break block15;
                }
                catch (IOException e2) {
                    Code.warning(e2);
                }
                break block15;
                {
                    catch (IOException e) {
                        Code.warning(e);
                        var4_12 = null;
                        try {
                            if (ufin != null) {
                                ufin.close();
                            }
                            break block15;
                        }
                        catch (IOException e2) {
                            Code.warning(e2);
                        }
                    }
                }
                catch (Throwable var3_14) {
                    var4_13 = null;
                    try {
                        if (ufin != null) {
                            ufin.close();
                        }
                    }
                    catch (IOException e2) {
                        Code.warning(e2);
                    }
                    throw var3_14;
                }
            }
            return (ArrayList)this._groups.get(group);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("AuthUserFile = ");
            buf.append(this._userFile);
            buf.append("AuthGroupFile = ");
            buf.append(this._groupFile);
            buf.append("AuthName = ");
            buf.append(this._name);
            buf.append("AuthType = ");
            buf.append(this._type);
            buf.append("satisfy=");
            buf.append(this._satisfy);
            if (this._order < 0) {
                buf.append("order = deny,allow");
            } else if (this._order > 0) {
                buf.append("order = allow,deny");
            } else {
                buf.append("order = mutual-failure");
            }
            buf.append("Allow from = ");
            buf.append(this._allowList);
            buf.append("deny from = ");
            buf.append(this._denyList);
            buf.append("requireName = ");
            buf.append(this._requireName);
            return buf.toString();
        }

        public void parse(DataInputStream htin) throws IOException {
            String line;
            block0: while ((line = htin.readLine()) != null) {
                String string;
                if ((string = string.trim()).startsWith("#")) continue;
                if (string.startsWith("AuthUserFile")) {
                    this._userFile = string.substring(13).trim();
                    continue;
                }
                if (string.startsWith("AuthGroupFile")) {
                    this._groupFile = string.substring(14).trim();
                    continue;
                }
                if (string.startsWith("AuthName")) {
                    this._name = string.substring(8).trim();
                    continue;
                }
                if (string.startsWith("AuthType")) {
                    this._type = string.substring(8).trim();
                    continue;
                }
                if (!string.startsWith("<Limit")) continue;
                int limit = string.length();
                int endp = string.indexOf(62);
                if (endp < 0) {
                    endp = limit;
                }
                StringTokenizer tkns = new StringTokenizer(string.substring(6, endp));
                while (tkns.hasMoreTokens()) {
                    this._methods.put(tkns.nextToken(), Boolean.TRUE);
                }
                while ((string = htin.readLine()) != null) {
                    int pos2;
                    int pos1;
                    if ((string = string.trim()).startsWith("#")) continue;
                    if (string.startsWith("satisfy")) {
                        pos1 = 7;
                        limit = string.length();
                        while (pos1 < limit && string.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        pos2 = pos1;
                        while (pos2 < limit && string.charAt(pos2) > ' ') {
                            ++pos2;
                        }
                        String l_string = string.substring(pos1, pos2);
                        if (l_string.equals("all")) {
                            this._satisfy = 1;
                            continue;
                        }
                        if (!l_string.equals("any")) continue;
                        this._satisfy = 0;
                        continue;
                    }
                    if (string.startsWith("require")) {
                        pos1 = 7;
                        limit = string.length();
                        while (pos1 < limit && string.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        pos2 = pos1;
                        while (pos2 < limit && string.charAt(pos2) > ' ') {
                            ++pos2;
                        }
                        this._requireName = string.substring(pos1, pos2).toLowerCase();
                        if (USER.equals(this._requireName)) {
                            this._requireName = USER;
                        } else if (GROUP.equals(this._requireName)) {
                            this._requireName = GROUP;
                        } else if (VALID_USER.equals(this._requireName)) {
                            this._requireName = VALID_USER;
                        }
                        pos1 = pos2 + 1;
                        if (pos1 >= limit) continue;
                        while (pos1 < limit && string.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        tkns = new StringTokenizer(string.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._requireEntities.put(tkns.nextToken(), Boolean.TRUE);
                        }
                        continue;
                    }
                    if (string.startsWith("order")) {
                        Code.debug("orderline=" + string + "order=" + this._order);
                        if (string.indexOf("allow,deny") > 0) {
                            Code.debug("==>allow,deny");
                            this._order = 1;
                            continue;
                        }
                        if (string.indexOf("deny,allow") > 0) {
                            Code.debug("==>deny,allow");
                            this._order = -1;
                            continue;
                        }
                        if (string.indexOf("mutual-failure") <= 0) continue;
                        Code.debug("==>mutual");
                        this._order = 0;
                        continue;
                    }
                    if (string.startsWith("allow from")) {
                        pos1 = 10;
                        limit = string.length();
                        while (pos1 < limit && string.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        Code.debug("allow process:" + string.substring(pos1));
                        tkns = new StringTokenizer(string.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._allowList.add(tkns.nextToken());
                        }
                        continue;
                    }
                    if (string.startsWith("deny from")) {
                        pos1 = 9;
                        limit = string.length();
                        while (pos1 < limit && string.charAt(pos1) <= ' ') {
                            ++pos1;
                        }
                        Code.debug("deny process:" + string.substring(pos1));
                        tkns = new StringTokenizer(string.substring(pos1));
                        while (tkns.hasMoreTokens()) {
                            this._denyList.add(tkns.nextToken());
                        }
                        continue;
                    }
                    if (string.startsWith("</Limit>")) continue block0;
                }
            }
        }

        public HTAccess(Resource resource) {
            try {
                DataInputStream htin = new DataInputStream(resource.getInputStream());
                this.parse(htin);
                this._lastModified = resource.lastModified();
                Resource base = Resource.newResource(URI.parentPath(resource.toString()));
                if (this._userFile != null) {
                    this._userResource = this._userFile.charAt(0) == File.separatorChar ? Resource.newResource(this._userFile) : base.addPath(this._userFile);
                }
                if (this._groupFile != null) {
                    this._groupResource = this._groupFile.charAt(0) == File.separatorChar ? Resource.newResource(this._groupFile) : base.addPath(this._groupFile);
                }
            }
            catch (IOException e) {
                Code.warning(e);
            }
        }
    }
}

