/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.util.Map;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.handler.NullHandler;
import org.mortbay.util.Code;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;

public class ForwardHandler
extends NullHandler {
    PathMap _forward = new PathMap();
    String _root;
    boolean _handleQueries = false;

    public void addForward(String pathSpecInContext, String newPath) {
        this._forward.put(pathSpecInContext, newPath);
    }

    public void setRootForward(String newPath) {
        this._root = newPath;
    }

    public void setHandleQueries(boolean b) {
        this._handleQueries = b;
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (Code.verbose()) {
            Code.debug("Look for " + pathInContext + " in " + this._forward);
        }
        String newPath = null;
        String query = null;
        if (this._root != null && ("/".equals(pathInContext) || pathInContext.startsWith("/;"))) {
            newPath = this._root;
        } else {
            Map.Entry entry = this._forward.getMatch(pathInContext);
            if (entry != null) {
                int hook;
                String match = (String)entry.getValue();
                if (this._handleQueries && (hook = match.indexOf(63)) != -1) {
                    query = match.substring(hook + 1);
                    match = match.substring(0, hook);
                }
                String info = PathMap.pathInfo((String)entry.getKey(), pathInContext);
                Code.debug("Forward: match:\"", match, "\" info:", info, "\" query:", query);
                String string = newPath = info == null ? match : URI.addPaths(match, info);
            }
        }
        if (newPath != null) {
            Code.debug((Object)"Forward from ", pathInContext, (Object)" to ", newPath);
            int last = request.setState(0);
            String context = this.getHandlerContext().getContextPath();
            if (context.length() == 1) {
                request.setPath(newPath);
            } else {
                request.setPath(this.getHandlerContext().getContextPath() + newPath);
            }
            if (this._handleQueries && query != null) {
                UrlEncoded.decodeTo(query, request.getParameters());
            }
            request.setState(last);
            this.getHandlerContext().getHttpServer().service(request, response);
            return;
        }
    }

    public ForwardHandler() {
    }

    public ForwardHandler(String rootForward) {
        this._root = rootForward;
    }
}

