/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mortbay.util.Code;

public class SecurityConstraint
implements Cloneable {
    public static final int DC_NONE = 0;
    public static final int DC_INTEGRAL = 1;
    public static final int DC_CONFIDENTIAL = 2;
    public static final String NONE = "NONE";
    private String _name;
    private List _methods;
    private List _roles;
    private int _dataConstraint = 0;

    public void setName(String name) {
        this._name = name;
    }

    public synchronized void addMethod(String method) {
        if (this._methods == null) {
            this._methods = new ArrayList(3);
        }
        this._methods.add(method);
    }

    public boolean forMethod(String method) {
        if (this._methods == null) {
            return true;
        }
        return this._methods.contains(method);
    }

    public synchronized void addRole(String role) {
        if (this._roles == null) {
            this._roles = new ArrayList(3);
        }
        this._roles.add(role);
    }

    public Iterator roles() {
        if (this._roles == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this._roles.iterator();
    }

    public boolean hasRole(String role) {
        return this._roles != null && this._roles.contains(role);
    }

    public boolean isAuthenticated() {
        return this._roles != null && this._roles.size() > 0;
    }

    public void setDataConstraint(int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException("Constraint out of range");
        }
        this._dataConstraint = c;
    }

    public int getDataConstraint() {
        return this._dataConstraint;
    }

    public boolean hasDataConstraint() {
        return this._dataConstraint != 0;
    }

    public Object clone() {
        SecurityConstraint sc = null;
        try {
            sc = (SecurityConstraint)super.clone();
            if (this._methods != null) {
                sc._methods = new ArrayList(this._methods);
            }
            if (this._roles != null) {
                sc._roles = new ArrayList(this._roles);
            }
        }
        catch (CloneNotSupportedException e) {
            Code.fail("Oh yes it does");
        }
        return sc;
    }

    public String toString() {
        return "SC{" + this._name + "," + this._methods + "," + this._roles + "," + (this._dataConstraint == 0 ? "NONE}" : (this._dataConstraint == 1 ? "INTEGRAL}" : "CONFIDENTIAL}"));
    }

    public SecurityConstraint() {
    }

    public SecurityConstraint(String name, String role) {
        this.setName(name);
        this.addRole(role);
    }
}

