/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.mortbay.http.ChunkableInputStream;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserPrincipal;
import org.mortbay.util.Code;
import org.mortbay.util.LazyList;
import org.mortbay.util.LineInput;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.URI;
import org.mortbay.util.UrlEncoded;

public class HttpRequest
extends HttpMessage {
    public static final String __GET = "GET";
    public static final String __POST = "POST";
    public static final String __HEAD = "HEAD";
    public static final String __PUT = "PUT";
    public static final String __OPTIONS = "OPTIONS";
    public static final String __DELETE = "DELETE";
    public static final String __TRACE = "TRACE";
    public static final String __CONNECT = "CONNECT";
    public static final String __MOVE = "MOVE";
    public static final StringMap __methodCache = new StringMap(true);
    public static final StringMap __versionCache = new StringMap(true);
    public static final String __AuthType = "org.mortbay.http.HttpRequest.AuthType";
    public static final String __AuthUser = "org.mortbay.http.HttpRequest.AuthUser";
    private static Cookie[] __noCookies;
    private String _method = null;
    private URI _uri = null;
    private String _host;
    private int _port;
    private List _te;
    private MultiMap _parameters;
    private boolean _paramsExtracted;
    private boolean _handled;
    private Cookie[] _cookies;
    private Map _attributes;

    public HttpResponse getResponse() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getResponse();
    }

    public boolean isHandled() {
        if (this._handled) {
            return true;
        }
        HttpResponse response = this.getResponse();
        return response != null && response.getState() != HttpMessage.__MSG_EDITABLE;
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public void readHeader(ChunkableInputStream in) throws IOException {
        LineInput.LineBuffer line_buffer;
        this._state = 1;
        LineInput line_input = (LineInput)in.getRawStream();
        do {
            if ((line_buffer = line_input.readLineBuffer()) != null) continue;
            throw new InterruptedIOException("EOF");
        } while (line_buffer.size == 0);
        if (line_buffer.size == ChunkableInputStream.__maxLineLength) {
            throw new HttpException(414);
        }
        this.decodeRequestLine(line_buffer.buffer, line_buffer.size);
        if ("HTTP/1.1".equals(this._version)) {
            this._dotVersion = 1;
            this._version = "HTTP/1.1";
            this._header.read(line_input);
            this.setMimeAndEncoding(this._header.get("Content-Type"));
        } else if ("HTTP/0.9".equals(this._version)) {
            this._dotVersion = -1;
            this._version = "HTTP/0.9";
        } else {
            this._dotVersion = 0;
            this._version = "HTTP/1.0";
            this._header.read(line_input);
            this.setMimeAndEncoding(this._header.get("Content-Type"));
        }
        this._handled = false;
        this._state = 2;
    }

    public void writeHeader(Writer writer) throws IOException {
        if (this._state != 0) {
            throw new IllegalStateException("Not MSG_EDITABLE");
        }
        this._state = 1;
        Writer writer2 = writer;
        synchronized (writer2) {
            writer.write(this._method);
            writer.write(32);
            writer.write(this._uri != null ? this._uri.toString() : "null");
            writer.write(32);
            writer.write(this._version);
            writer.write(HttpFields.__CRLF);
            this._header.write(writer);
        }
        this._state = 3;
    }

    public String getRequestLine() {
        return this._method + " " + this._uri + " " + this._version;
    }

    public void appendRequestLine(StringBuffer buf) {
        buf.append(this._method);
        buf.append(' ');
        buf.append(this._uri);
        buf.append(' ');
        buf.append(this._version);
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) throws IllegalStateException {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._method = method;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url;
        StringBuffer stringBuffer = url = new StringBuffer();
        synchronized (stringBuffer) {
            String scheme = this.getScheme();
            int port = this.getPort();
            url.append(scheme);
            url.append("://");
            url.append(this.getHost());
            if (port > 0 && (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443)) {
                url.append(':');
                url.append(port);
            }
            url.append(this.getPath());
            StringBuffer stringBuffer2 = url;
            Object var3_6 = null;
            return stringBuffer2;
        }
    }

    public URI getURI() {
        return (URI)this._uri.clone();
    }

    public void setURI(URI uri) {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._uri = uri;
    }

    public String getScheme() {
        String scheme = this._uri.getScheme();
        if (scheme == null && this._connection != null) {
            scheme = this._connection.getDefaultScheme();
        }
        return scheme == null ? "http" : scheme;
    }

    public void setScheme(String scheme) {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        if (!this._uri.isAbsolute()) {
            this._uri.setHost(this.getHost());
            this._uri.setPort(this.getPort());
        }
        this._uri.setScheme(scheme);
    }

    public String getHost() {
        if (this._host != null) {
            return this._host;
        }
        this._host = this._uri.getHost();
        this._port = this._uri.getPort();
        if (this._host != null) {
            return this._host;
        }
        this._host = this._header.get("Host");
        this._port = 0;
        if (this._host != null) {
            int colon = this._host.indexOf(58);
            if (colon >= 0) {
                if (colon < this._host.length()) {
                    try {
                        this._port = Integer.parseInt(this._host.substring(colon + 1));
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                    }
                }
                this._host = this._host.substring(0, colon);
            }
            return this._host;
        }
        if (this._connection != null) {
            this._host = this._connection.getHost();
            this._port = this._connection.getPort();
            return this._host;
        }
        try {
            this._host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Code.ignore(e);
        }
        return this._host;
    }

    public void setHost(String host) throws IllegalStateException {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._host = host;
        if (this._uri.isAbsolute()) {
            this._uri.setHost(host);
        }
        this.getPort();
        if (this._port > 0) {
            this._header.put("Host", host + ":" + this._port);
        } else {
            this._header.put("Host", host);
        }
    }

    public int getPort() {
        if (this._port > 0) {
            return this._port;
        }
        if (this._host != null) {
            return 0;
        }
        if (this._uri.isAbsolute()) {
            this._port = this._uri.getPort();
        } else if (this._connection != null) {
            this._port = this._connection.getPort();
        }
        return this._port;
    }

    public void setPort(int port) throws IllegalStateException {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._port = port;
        if (this._uri.isAbsolute()) {
            this._uri.setPort(port);
        }
        this.getHost();
        if (this._port > 0) {
            this._header.put("Host", this._host + ":" + this._port);
        } else {
            this._header.put("Host", this._host);
        }
    }

    public String getPath() {
        return this._uri.getPath();
    }

    public void setPath(String path) {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._uri.setPath(path);
    }

    public String getQuery() {
        return this._uri.getQuery();
    }

    public void setQuery(String query) {
        if (this._state != 0) {
            throw new IllegalStateException("Not EDITABLE");
        }
        this._uri.setQuery(query);
    }

    public String getRemoteAddr() {
        HttpConnection connection = this.getHttpConnection();
        if (connection != null) {
            return connection.getRemoteHost();
        }
        return "127.0.0.1";
    }

    /*
     * Unable to fully structure code
     */
    void decodeRequestLine(char[] buf, int len) throws IOException {
        s1 = -1;
        s2 = -1;
        s3 = -1;
        state = 0;
        i = 0;
        block12: while (i < len) {
            c = buf[i];
            switch (state) {
                case 0: {
                    if (c == ' ') ** GOTO lbl25
                    state = 1;
                    s1 = i;
                }
                case 1: {
                    if (c == ' ') {
                        state = 2;
                    } else {
                        s2 = i;
                        if (c >= 'a' && c <= 'z') {
                            buf[i] = (char)(c - 97 + 65);
                        } else {
                            ** GOTO lbl21
                        }
                    }
                }
                {
lbl21:
                    // 3 sources

                    ** GOTO lbl25
                }
                case 2: {
                    s3 = i;
                    if (c != ' ') break block12;
                }
lbl25:
                // 5 sources

                default: {
                    ++i;
                }
            }
        }
        e1 = -1;
        e2 = -1;
        e3 = -1;
        state = 0;
        i = len;
        block13: while (i-- > 0) {
            c = buf[i];
            switch (state) {
                case 0: {
                    if (c == ' ') ** GOTO lbl50
                    state = 1;
                    e1 = i;
                }
                case 1: {
                    if (c == ' ') {
                        state = 2;
                    } else {
                        e2 = i;
                    }
                }
                {
                    ** GOTO lbl50
                }
                case 2: {
                    e3 = i;
                    if (c != ' ') break block13;
                }
lbl50:
                // 5 sources

                default: {
                    continue block13;
                }
            }
        }
        if (s3 < 0 || e1 < 0 || e3 < s2) {
            throw new IOException("Bad Request: " + new String(buf, 0, len));
        }
        method = HttpRequest.__methodCache.getEntry(buf, s1, s2 - s1 + 1);
        this._method = method != null ? (String)method.getKey() : new String(buf, s1, s2 - s1 + 1).toUpperCase();
        if (s2 != e3 || s3 != e2) {
            version = HttpRequest.__versionCache.getEntry(buf, e2, e1 - e2 + 1);
            if (version != null) {
                this._version = (String)version.getKey();
            } else {
                i = e2;
                while (i <= e1) {
                    if (buf[i] >= 'a' && buf[i] <= 'z') {
                        buf[i] = (char)(buf[i] - 97 + 65);
                    }
                    ++i;
                }
                this._version = new String(buf, e2, e1 - e2 + 1);
            }
        } else {
            this._version = "HTTP/0.9";
            e3 = e1;
        }
        try {
            this._uri = new URI(new String(buf, s3, e3 - s3 + 1));
        }
        catch (IllegalArgumentException e) {
            Code.ignore(e);
            throw new HttpException(400, new String(buf, s3, e3 - s3 + 1));
        }
    }

    public Object forceRemoveField(String name) {
        if (Code.verbose(99)) {
            Code.debug((Object)"force remove ", (Object)name);
        }
        int saved_state = this._state;
        try {
            this._state = 0;
            String string = this.removeField(name);
            Object var4_4 = null;
            this._state = saved_state;
            return string;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this._state = saved_state;
            throw throwable;
        }
    }

    public List getAcceptableTransferCodings() {
        if (this._dotVersion < 1) {
            return null;
        }
        if (this._te != null) {
            return this._te;
        }
        Enumeration tenum = this.getFieldValues("TE", ", \t");
        if (tenum != null) {
            List te = HttpFields.qualityList(tenum);
            int size = te.size();
            if (size > 0) {
                LazyList acceptable = null;
                ListIterator iter = te.listIterator();
                while (iter.hasNext()) {
                    String coding = StringUtil.asciiToLowerCase(HttpFields.valueParameters(iter.next().toString(), null));
                    if ("trailer".equals(coding)) {
                        HttpResponse response = this.getResponse();
                        if (response == null) continue;
                        response.setAcceptTrailer(true);
                        continue;
                    }
                    if ("chunked".equals(coding)) continue;
                    acceptable = LazyList.add(acceptable, size, coding);
                }
                this._te = LazyList.getList(acceptable);
            } else {
                this._te = Collections.EMPTY_LIST;
            }
        } else {
            this._te = Collections.EMPTY_LIST;
        }
        return this._te;
    }

    private void extractParameters() {
        String content_type;
        if (this._paramsExtracted) {
            return;
        }
        this._paramsExtracted = true;
        if (this._parameters == null) {
            this._parameters = new MultiMap(this._uri.getUnmodifiableParameters());
        } else {
            this._parameters.putAll(this._uri.getUnmodifiableParameters());
        }
        if (this._state == 2 && (content_type = this.getField("Content-Type")) != null && content_type.length() > 0) {
            content_type = StringUtil.asciiToLowerCase(content_type);
            if ("application/x-www-form-urlencoded".equals(content_type = HttpFields.valueParameters(content_type, null)) && __POST.equals(this.getMethod())) {
                int content_length = this.getIntField("Content-Length");
                if (content_length < 0) {
                    Code.warning("No contentLength for application/x-www-form-urlencoded");
                } else if (content_length == 0) {
                    Code.debug("No form content");
                } else {
                    try {
                        byte[] content = new byte[content_length];
                        ChunkableInputStream in = this.getInputStream();
                        int offset = 0;
                        int len = 0;
                        while (content_length - offset > 0) {
                            len = ((InputStream)in).read(content, offset, content_length - offset);
                            if (len <= 0) {
                                throw new IOException("Premature EOF reading params");
                            }
                            offset += len;
                        }
                        String encoding = this.getCharacterEncoding();
                        if (encoding == null) {
                            encoding = StringUtil.__ISO_8859_1;
                        }
                        String contentStr = new String(content, 0, content_length, encoding);
                        Code.debug("Form content='", contentStr, "'");
                        UrlEncoded.decodeTo(contentStr, this._parameters);
                    }
                    catch (IOException e) {
                        if (Code.debug()) {
                            Code.warning(e);
                        }
                        Code.warning(e.toString());
                    }
                }
            }
        }
    }

    public MultiMap getParameters() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters;
    }

    public Set getParameterNames() {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.keySet();
    }

    public String getParameter(String name) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return (String)this._parameters.getValue(name, 0);
    }

    public List getParameterValues(String name) {
        if (!this._paramsExtracted) {
            this.extractParameters();
        }
        return this._parameters.getValues(name);
    }

    public Cookie[] getCookies() {
        if (this._cookies != null) {
            return this._cookies;
        }
        try {
            if (!this._header.containsKey("Cookie")) {
                this._cookies = __noCookies;
                return this._cookies;
            }
            ArrayList<Cookie> cookies = new ArrayList<Cookie>(4);
            int version = 0;
            Cookie cookie = null;
            Enumeration enumeration = this._header.getValues("Cookie", ";");
            while (enumeration.hasMoreElements()) {
                try {
                    String v;
                    String n;
                    String c = enumeration.nextElement().toString().trim();
                    int e = c.indexOf(61);
                    if (e > 0) {
                        n = c.substring(0, e).trim();
                        String string = c.substring(e + 1).trim();
                    } else {
                        n = c.trim();
                        v = "";
                    }
                    if (version > 0) {
                        v = StringUtil.unquote(v);
                    }
                    if (n.startsWith("$")) {
                        if ("$version".equalsIgnoreCase(n)) {
                            int coma = v.indexOf(44);
                            if (coma < 0) continue;
                            version = Integer.parseInt(StringUtil.unquote(v.substring(0, coma)));
                            e = (v = v.substring(coma + 1)).indexOf(61);
                            if (e > 0) {
                                n = v.substring(0, e).trim();
                                v = v.substring(e + 1).trim();
                                v = StringUtil.unquote(v);
                            } else {
                                n = v.trim();
                                v = "";
                            }
                        } else {
                            if ("$path".equalsIgnoreCase(n) && cookie != null) {
                                cookie.setPath(v);
                                continue;
                            }
                            if (!"$domain".equalsIgnoreCase(n) || cookie == null) continue;
                            cookie.setDomain(v);
                            continue;
                        }
                    }
                    v = UrlEncoded.decodeString(v);
                    cookie = new Cookie(n, v);
                    if (version > 0) {
                        cookie.setVersion(version);
                    }
                    cookies.add(cookie);
                }
                catch (Exception e) {
                    Code.ignore(e);
                    Code.warning("Bad Cookie received: " + e.toString());
                }
            }
            this._cookies = new Cookie[cookies.size()];
            if (cookies.size() > 0) {
                cookies.toArray(this._cookies);
            }
        }
        catch (Exception e) {
            Code.warning(e);
        }
        return this._cookies;
    }

    public Object getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    public Object setAttribute(String name, Object attribute) {
        if (this._attributes == null) {
            this._attributes = new HashMap(11);
        }
        return this._attributes.put(name, attribute);
    }

    public Collection getAttributeNames() {
        if (this._attributes == null) {
            return Collections.EMPTY_LIST;
        }
        return this._attributes.keySet();
    }

    public void removeAttribute(String name) {
        if (this._attributes != null) {
            this._attributes.remove(name);
        }
    }

    public boolean isUserInRole(String role) {
        Principal principal = this.getUserPrincipal();
        if (principal != null && principal instanceof UserPrincipal) {
            return ((UserPrincipal)principal).isUserInRole(role);
        }
        return false;
    }

    public Principal getUserPrincipal() {
        return (Principal)this.getAttribute("org.mortbay.http.UserPrincipal");
    }

    public void recycle(HttpConnection connection) {
        super.recycle(connection);
        this._method = null;
        this._uri = null;
        this._host = null;
        this._port = 0;
        this._te = null;
        if (this._parameters != null) {
            this._parameters.clear();
        }
        this._paramsExtracted = false;
        this._handled = false;
        this._cookies = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
    }

    public void destroy() {
        this._method = null;
        this._uri = null;
        this._version = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        super.destroy();
    }

    public HttpRequest() {
    }

    public HttpRequest(HttpConnection connection) {
        super(connection);
    }

    static {
        __methodCache.put(__GET, null);
        __methodCache.put(__POST, null);
        __methodCache.put(__HEAD, null);
        __methodCache.put(__PUT, null);
        __methodCache.put(__OPTIONS, null);
        __methodCache.put(__DELETE, null);
        __methodCache.put(__TRACE, null);
        __methodCache.put(__CONNECT, null);
        __methodCache.put(__MOVE, null);
        __versionCache.put("HTTP/1.1", null);
        __versionCache.put("HTTP/1.0", null);
        __versionCache.put("HTTP/0.9", null);
        __noCookies = new Cookie[0];
    }
}

