/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.mortbay.http.ContextLoader;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.http.handler.SecurityHandler;
import org.mortbay.util.Code;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.Log;
import org.mortbay.util.LogSink;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;
import org.mortbay.util.StringUtil;

public class HandlerContext
implements LifeCycle {
    private static final Map __dftMimeMap = new HashMap();
    private static final Map __encodings = new HashMap();
    private HttpServer _httpServer;
    private List _handlers = new ArrayList(3);
    private String _classPath;
    private ClassLoader _parent;
    private ClassLoader _loader;
    private Resource _resourceBase;
    private boolean _started;
    private LogSink _logSink;
    private LogSink _useLogSink;
    private Map _attributes = new HashMap(11);
    private Map _initParams = new HashMap(11);
    private List _hosts = new ArrayList(2);
    private String _contextPath;
    private String _name;
    private boolean _redirectNullPath = true;
    private boolean _httpServerAccess = false;
    private Map _mimeMap;
    private Map _encodingMap;
    private Map _resourceAliases;
    private Map _errorPages;
    private PermissionCollection _permissions;
    private boolean _statsOn = false;
    int _requests;
    int _responses1xx;
    int _responses2xx;
    int _responses3xx;
    int _responses4xx;
    int _responses5xx;
    private static /* synthetic */ Class class$Lorg$mortbay$http$handler$ResourceHandler;
    private static /* synthetic */ Class class$Lorg$mortbay$http$handler$SecurityHandler;

    public void setInitParameter(String param, String value) {
        this._initParams.put(param, value);
    }

    public String getInitParameter(String param) {
        return (String)this._initParams.get(param);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public synchronized void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public synchronized void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void registerHost(String hostname) {
        this._httpServer.addContext(hostname, this);
    }

    void addHost(String host) {
        this._hosts.add(host);
        this._name = null;
    }

    public List getHosts() {
        return this._hosts;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public String getClassPath() {
        return this._classPath;
    }

    public void setClassPath(String classPath) {
        this._classPath = classPath;
        if (this.isStarted()) {
            Code.warning("classpath set while started");
        }
    }

    public void setClassPaths(Resource lib, boolean append) {
        if (this.isStarted()) {
            Code.warning("classpaths set while started");
        }
        if (lib.exists() && lib.isDirectory()) {
            StringBuffer classPath = new StringBuffer();
            String[] files = lib.list();
            int f = 0;
            while (files != null && f < files.length) {
                try {
                    Resource fn = lib.addPath(files[f]);
                    String fnlc = fn.getName().toLowerCase();
                    if (fnlc.endsWith(".jar") || fnlc.endsWith(".zip")) {
                        classPath.append(classPath.length() > 0 ? "," : "");
                        classPath.append(fn.toString());
                    }
                }
                catch (Exception ex) {
                    Code.warning(ex);
                }
                ++f;
            }
            if (classPath.length() > 0) {
                if (append && this.getClassPath() != null) {
                    classPath.append(",").append(this._classPath);
                }
                this._classPath = classPath.toString();
            }
        }
    }

    public void setClassPaths(String lib, boolean append) throws IOException {
        this.setClassPaths(Resource.newResource(lib), append);
    }

    public synchronized ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this._parent = loader;
        if (this.isStarted()) {
            Code.warning("classpath set while started");
        }
    }

    public String getResourceBase() {
        if (this._resourceBase == null) {
            return null;
        }
        return this._resourceBase.toString();
    }

    public void setResourceBase(String resourceBase) {
        try {
            this._resourceBase = Resource.newResource(resourceBase);
            Code.debug((Object)"resourceBase=", this._resourceBase, (Object)" for ", this);
        }
        catch (IOException e) {
            Code.debug(e);
            throw new IllegalArgumentException(resourceBase + ":" + e.toString());
        }
    }

    public Resource getResource(String path) throws IOException {
        if (this._resourceBase == null) {
            return null;
        }
        if (path == null) {
            return this._resourceBase;
        }
        return this._resourceBase.addPath(path);
    }

    public Resource getBaseResource() {
        return this._resourceBase;
    }

    public void setBaseResource(Resource base) {
        this._resourceBase = base;
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public String getResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.get(alias);
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return (String)this._resourceAliases.remove(alias);
    }

    public void setErrorPage(String error, String uriInContext) {
        if (this._errorPages == null) {
            this._errorPages = new HashMap(5);
        }
        this._errorPages.put(error, uriInContext);
    }

    public String getErrorPage(String error) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.get(error);
    }

    public Resource getErrorPageResource(String error) {
        if (this._errorPages == null || this._resourceBase == null) {
            return null;
        }
        String page = (String)this._errorPages.get(error);
        if (page == null) {
            return null;
        }
        try {
            Resource resource = this._resourceBase.addPath(page);
            if (resource.exists()) {
                return resource;
            }
        }
        catch (IOException e) {
            Code.ignore(e);
        }
        return null;
    }

    public String removeErrorPage(String error) {
        if (this._errorPages == null) {
            return null;
        }
        return (String)this._errorPages.remove(error);
    }

    public void setHttpServerAccess(boolean access) {
        this._httpServerAccess = access;
    }

    public boolean getHttpServerAccess() {
        return this._httpServerAccess;
    }

    public List getHandlers() {
        return this._handlers;
    }

    public int getHandlerSize() {
        return this._handlers.size();
    }

    public synchronized void addHandler(int i, HttpHandler handler) {
        this._handlers.add(i, handler);
        handler.initialize(this);
    }

    public synchronized void addHandler(HttpHandler handler) {
        this.addHandler(this._handlers.size(), handler);
    }

    public HttpHandler getHandler(int i) {
        return (HttpHandler)this._handlers.get(i);
    }

    public synchronized HttpHandler getHandler(Class handlerClass) {
        int h = 0;
        while (h < this._handlers.size()) {
            HttpHandler handler = (HttpHandler)this._handlers.get(h);
            if (handlerClass.isInstance(handler)) {
                return handler;
            }
            ++h;
        }
        return null;
    }

    public synchronized HttpHandler removeHandler(int i) {
        HttpHandler handler = this.getHandler(i);
        if (handler.isStarted()) {
            throw new IllegalStateException("Handler is started");
        }
        return (HttpHandler)this._handlers.remove(i);
    }

    public synchronized void removeHandler(HttpHandler handler) {
        if (handler.isStarted()) {
            throw new IllegalStateException("Handler is started");
        }
        this._handlers.remove(handler);
    }

    public ResourceHandler getResourceHandler() {
        ResourceHandler resourceHandler = (ResourceHandler)this.getHandler(class$Lorg$mortbay$http$handler$ResourceHandler != null ? class$Lorg$mortbay$http$handler$ResourceHandler : (class$Lorg$mortbay$http$handler$ResourceHandler = HandlerContext.class$("org.mortbay.http.handler.ResourceHandler")));
        if (resourceHandler == null) {
            resourceHandler = new ResourceHandler();
            this.addHandler(resourceHandler);
        }
        return resourceHandler;
    }

    public SecurityHandler getSecurityHandler() {
        SecurityHandler securityHandler = (SecurityHandler)this.getHandler(class$Lorg$mortbay$http$handler$SecurityHandler != null ? class$Lorg$mortbay$http$handler$SecurityHandler : (class$Lorg$mortbay$http$handler$SecurityHandler = HandlerContext.class$("org.mortbay.http.handler.SecurityHandler")));
        if (securityHandler == null) {
            securityHandler = new SecurityHandler();
            this.addHandler(0, securityHandler);
        }
        return securityHandler;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void setServingResources(boolean serve) {
        block3: {
            handler = (ResourceHandler)this.getHandler(HandlerContext.class$Lorg$mortbay$http$handler$ResourceHandler != null ? HandlerContext.class$Lorg$mortbay$http$handler$ResourceHandler : (HandlerContext.class$Lorg$mortbay$http$handler$ResourceHandler = HandlerContext.class$("org.mortbay.http.handler.ResourceHandler")));
            if (!serve) ** GOTO lbl10
            if (handler != null) break block3;
            this.getResourceHandler();
            break block3;
lbl-1000:
            // 1 sources

            {
                this._handlers.remove(handler);
                handler = (ResourceHandler)this.getHandler(HandlerContext.class$Lorg$mortbay$http$handler$ResourceHandler != null ? HandlerContext.class$Lorg$mortbay$http$handler$ResourceHandler : HandlerContext.class$("org.mortbay.http.handler.ResourceHandler"));
lbl10:
                // 2 sources

                ** while (handler != null)
            }
        }
    }

    public boolean isServingResources() {
        return this.getHandler(class$Lorg$mortbay$http$handler$ResourceHandler != null ? class$Lorg$mortbay$http$handler$ResourceHandler : (class$Lorg$mortbay$http$handler$ResourceHandler = HandlerContext.class$("org.mortbay.http.handler.ResourceHandler"))) != null;
    }

    public void setRealm(String realmName) {
        SecurityHandler sh = this.getSecurityHandler();
        sh.setRealmName(realmName);
    }

    public String getRealm() {
        SecurityHandler handler = (SecurityHandler)this.getHandler(class$Lorg$mortbay$http$handler$SecurityHandler != null ? class$Lorg$mortbay$http$handler$SecurityHandler : (class$Lorg$mortbay$http$handler$SecurityHandler = HandlerContext.class$("org.mortbay.http.handler.SecurityHandler")));
        if (handler != null) {
            return handler.getRealmName();
        }
        return null;
    }

    public void addSecurityConstraint(String pathSpec, SecurityConstraint sc) {
        SecurityHandler sh = this.getSecurityHandler();
        sh.addSecurityConstraint(pathSpec, sc);
    }

    public void addAuthConstraint(String pathSpec, String role) {
        SecurityHandler sh = this.getSecurityHandler();
        sh.addSecurityConstraint(pathSpec, new SecurityConstraint(role, role));
    }

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map mimeMap) {
        this._mimeMap = mimeMap;
    }

    public String getMimeByExtension(String filename) {
        String type = null;
        if (filename != null) {
            int i = -1;
            while (type == null) {
                if ((i = filename.indexOf(".", i + 1)) < 0 || i >= filename.length()) break;
                String ext = StringUtil.asciiToLowerCase(filename.substring(i + 1));
                if (this._mimeMap != null) {
                    type = (String)this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = (String)__dftMimeMap.get(ext);
            }
        }
        return type;
    }

    public void setMimeMapping(String extension, String type) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(extension, type);
    }

    public synchronized Map getEncodingMap() {
        if (this._encodingMap == null) {
            this._encodingMap = Collections.unmodifiableMap(__encodings);
        }
        return this._encodingMap;
    }

    public void setEncodingMap(Map encodingMap) {
        this._encodingMap = encodingMap;
    }

    public String getEncodingByMimeType(String type) {
        String encoding = null;
        if (type != null) {
            encoding = (String)this._encodingMap.get(type);
        }
        return encoding;
    }

    public void setTypeEncoding(String mimeType, String encoding) {
        this.getEncodingMap().put(mimeType, encoding);
    }

    public void setRedirectNullPath(boolean b) {
        this._redirectNullPath = b;
    }

    public boolean isRedirectNullPath() {
        return this._redirectNullPath;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public void addPermission(Permission permission) {
        if (this._permissions == null) {
            this._permissions = new Permissions();
        }
        this._permissions.add(permission);
    }

    public boolean handle(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (!this._started) {
            return false;
        }
        String pathInContext = request.getPath();
        String contextPath = null;
        if (this._contextPath.length() > 1) {
            contextPath = this._contextPath;
            pathInContext = pathInContext.substring(this._contextPath.length());
        }
        if (this._redirectNullPath && (pathInContext == null || pathInContext.length() == 0)) {
            StringBuffer buf = request.getRequestURL();
            buf.append("/");
            String q = request.getQuery();
            if (q != null && q.length() != 0) {
                buf.append("?" + q);
            }
            response.setField("Location", buf.toString());
            if (Code.debug()) {
                Code.warning(this + " consumed all of path " + request.getPath() + ", redirect to " + buf.toString());
            }
            response.sendError(302);
            return true;
        }
        String pathParams = null;
        int semi = pathInContext.indexOf(59);
        if (semi >= 0) {
            pathParams = pathInContext.substring(semi + 1);
            pathInContext = pathInContext.substring(0, semi);
        }
        return this.handle(pathInContext, pathParams, request, response);
    }

    public boolean handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        boolean bl;
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        HandlerContext lastHandlerContext = response.getHandlerContext();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            response.setHandlerContext(this);
            List handlers = this.getHandlers();
            int k = 0;
            while (k < handlers.size()) {
                HttpHandler handler = (HttpHandler)handlers.get(k);
                if (!handler.isStarted()) {
                    Code.debug(handler, " not started in ", this);
                } else {
                    if (Code.debug()) {
                        Code.debug((Object)"Try handler ", (Object)handler);
                    }
                    handler.handle(pathInContext, pathParams, request, response);
                    if (request.isHandled()) {
                        if (Code.debug()) {
                            Code.debug((Object)"Handled by ", (Object)handler);
                        }
                        response.complete();
                        boolean bl2 = true;
                        Object var9_13 = null;
                        thread.setContextClassLoader(lastContextLoader);
                        response.setHandlerContext(lastHandlerContext);
                        return bl2;
                    }
                }
                ++k;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            thread.setContextClassLoader(lastContextLoader);
            response.setHandlerContext(lastHandlerContext);
            throw throwable;
        }
        Object var9_14 = null;
        thread.setContextClassLoader(lastContextLoader);
        response.setHandlerContext(lastHandlerContext);
        return bl;
    }

    protected String getHandlerContextName() {
        if (this._name == null) {
            this._name = (this._hosts.size() > 1 ? this._hosts.toString() + ":" : "") + this._contextPath;
        }
        return this._name;
    }

    public String toString() {
        return "HandlerContext[" + this.getHandlerContextName() + "]";
    }

    public String toString(boolean detail) {
        return "HandlerContext[" + this.getHandlerContextName() + "]" + (detail ? "=" + this._handlers : "");
    }

    public synchronized void start() throws Exception {
        if (this._httpServer == null) {
            throw new IllegalStateException("No server for " + this);
        }
        MultiException mx = new MultiException();
        if (this._logSink == null) {
            this._useLogSink = this._httpServer.getLogSink();
        } else {
            this._useLogSink = this._logSink;
            if (!this._logSink.isStarted()) {
                try {
                    this._logSink.start();
                }
                catch (Exception e) {
                    mx.add(e);
                }
            }
        }
        this._started = true;
        this.getMimeMap();
        this.getEncodingMap();
        if (this._httpServerAccess) {
            this.setAttribute("org.mortbay.http.HttpServer", this._httpServer);
        } else {
            this.removeAttribute("org.mortbay.http.HttpServer");
        }
        this._loader = null;
        if (this._parent != null || this._classPath != null || this.getClass().getClassLoader() != null) {
            if (this._parent == null) {
                this._parent = Thread.currentThread().getContextClassLoader();
            }
            if (this._parent == null) {
                this._parent = this.getClass().getClassLoader();
            }
            Code.debug("Init classloader from ", this._classPath, ", ", this._parent, " for ", this);
            this._loader = this._classPath == null || this._classPath.length() == 0 ? this._parent : new ContextLoader(this._classPath, this._parent, this._permissions);
        }
        Thread thread = Thread.currentThread();
        ClassLoader lastContextLoader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            Iterator handlers = this._handlers.iterator();
            while (handlers.hasNext()) {
                HttpHandler handler = (HttpHandler)handlers.next();
                if (handler.isStarted()) continue;
                try {
                    handler.start();
                }
                catch (Exception e) {
                    mx.add(e);
                }
            }
        }
        finally {
            Object var5_8 = null;
            thread.setContextClassLoader(lastContextLoader);
        }
        mx.ifExceptionThrow();
    }

    public synchronized boolean isStarted() {
        return this._started;
    }

    public synchronized void stop() throws InterruptedException {
        ClassLoader lastContextLoader;
        Thread thread;
        block6: {
            this._started = false;
            thread = Thread.currentThread();
            lastContextLoader = thread.getContextClassLoader();
            try {
                if (this._loader != null) {
                    thread.setContextClassLoader(this._loader);
                }
                Iterator handlers = this._handlers.iterator();
                while (handlers.hasNext()) {
                    HttpHandler handler = (HttpHandler)handlers.next();
                    if (!handler.isStarted()) continue;
                    try {
                        handler.stop();
                    }
                    catch (Exception e) {
                        Code.warning(e);
                    }
                }
                this._useLogSink = null;
                if (this._logSink == null) break block6;
                this._logSink.stop();
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                thread.setContextClassLoader(lastContextLoader);
                throw throwable;
            }
        }
        Object var4_6 = null;
        thread.setContextClassLoader(lastContextLoader);
        this._loader = null;
    }

    public synchronized void destroy() {
        ClassLoader lastContextLoader;
        Thread thread;
        block7: {
            this._started = false;
            if (this._httpServer != null) {
                this._httpServer.removeContext(this);
            }
            thread = Thread.currentThread();
            lastContextLoader = thread.getContextClassLoader();
            try {
                if (this._loader != null) {
                    thread.setContextClassLoader(this._loader);
                }
                Iterator handlers = this._handlers.iterator();
                while (handlers.hasNext()) {
                    HttpHandler handler = (HttpHandler)handlers.next();
                    try {
                        handler.destroy();
                    }
                    catch (Exception e) {
                        Code.warning(e);
                    }
                }
                if (this._httpServer == null || this._logSink == null) break block7;
                this._httpServer.remove(this._logSink);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                thread.setContextClassLoader(lastContextLoader);
                throw throwable;
            }
        }
        Object var4_6 = null;
        thread.setContextClassLoader(lastContextLoader);
        this._httpServer = null;
        this._handlers.clear();
        this._handlers = null;
        this._classPath = null;
        this._parent = null;
        this._loader = null;
        this._resourceBase = null;
        this._attributes.clear();
        this._attributes = null;
        this._initParams.clear();
        this._initParams = null;
        this._mimeMap = null;
        this._encodingMap = null;
        this._hosts.clear();
        this._hosts = null;
        this._contextPath = null;
        this._name = null;
        this._redirectNullPath = false;
        this._logSink = null;
    }

    public synchronized boolean isDestroyed() {
        return this._handlers == null;
    }

    public void setStatsOn(boolean on) {
        Log.event("setStatsOn " + on + " for " + this);
        this._statsOn = on;
    }

    public boolean getStatsOn() {
        return this._statsOn;
    }

    public synchronized void statsReset() {
        this._requests = 0;
        this._responses1xx = 0;
        this._responses2xx = 0;
        this._responses3xx = 0;
        this._responses4xx = 0;
        this._responses5xx = 0;
    }

    public int getRequests() {
        return this._requests;
    }

    public int getResponses1xx() {
        return this._responses1xx;
    }

    public int getResponses2xx() {
        return this._responses2xx;
    }

    public int getResponses3xx() {
        return this._responses3xx;
    }

    public int getResponses4xx() {
        return this._responses4xx;
    }

    public int getResponses5xx() {
        return this._responses5xx;
    }

    public synchronized LogSink getLogSink() {
        return this._logSink;
    }

    public synchronized void setLogSink(LogSink logSink) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._httpServer != null && this._logSink != null) {
            this._httpServer.remove(this._logSink);
        }
        this._logSink = logSink;
        if (this._httpServer != null && this._logSink != null) {
            this._httpServer.add(this._logSink);
        }
    }

    void log(HttpRequest request, HttpResponse response, int length) {
        if (this._statsOn) {
            HandlerContext handlerContext = this;
            synchronized (handlerContext) {
                ++this._requests;
                if (response != null) {
                    switch (response.getStatus() / 100) {
                        case 1: {
                            ++this._responses1xx;
                            break;
                        }
                        case 2: {
                            ++this._responses2xx;
                            break;
                        }
                        case 3: {
                            ++this._responses3xx;
                            break;
                        }
                        case 4: {
                            ++this._responses4xx;
                            break;
                        }
                        case 5: {
                            ++this._responses5xx;
                            break;
                        }
                    }
                }
            }
        }
        if (this._useLogSink != null && request != null && response != null) {
            StringBuffer buf;
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                buf.setLength(0);
                buf.append(request.getRemoteAddr());
                buf.append(" - ");
                String user = (String)request.getAttribute("org.mortbay.http.HttpRequest.AuthUser");
                buf.append(user == null ? "-" : user);
                buf.append(" [");
                buf.append(response.getField("Date"));
                buf.append("] \"");
                request.appendRequestLine(buf);
                buf.append("\" ");
                buf.append(response.getStatus());
                if (length >= 0) {
                    buf.append(' ');
                    buf.append(length);
                    buf.append(' ');
                } else {
                    buf.append(" - ");
                }
                String referer = request.getField("Referer");
                if (referer == null) {
                    buf.append("- ");
                } else {
                    buf.append('\"');
                    buf.append(referer);
                    buf.append("\" ");
                }
                String agent = request.getField("User-Agent");
                if (agent == null) {
                    buf.append('-');
                } else {
                    buf.append('\"');
                    buf.append(agent);
                    buf.append('\"');
                }
                this._useLogSink.log(buf.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected HandlerContext(HttpServer httpServer, String contextPathSpec) {
        if (contextPathSpec == null || contextPathSpec.indexOf(44) >= 0 || contextPathSpec.startsWith("*")) {
            new IllegalArgumentException("Illegal context spec:" + contextPathSpec);
        }
        if (!contextPathSpec.startsWith("/")) {
            contextPathSpec = "/" + contextPathSpec;
        }
        if (contextPathSpec.endsWith("/*")) {
            this._contextPath = contextPathSpec.substring(0, contextPathSpec.length() - 2);
        } else if (contextPathSpec.length() > 1) {
            this._contextPath = contextPathSpec.endsWith("/") ? contextPathSpec.substring(0, contextPathSpec.length() - 1) : contextPathSpec;
            Code.warning("Unsuitable contextPathSpec " + contextPathSpec + ", Assuming: " + this._contextPath + "/*");
        } else {
            this._contextPath = "/";
        }
        this._httpServer = httpServer;
        this._name = null;
    }

    static {
        ResourceBundle mime = ResourceBundle.getBundle("org/mortbay/http/mime");
        Enumeration<String> i = mime.getKeys();
        while (i.hasMoreElements()) {
            String ext = i.nextElement();
            __dftMimeMap.put(ext, mime.getString(ext));
        }
        ResourceBundle encoding = ResourceBundle.getBundle("org/mortbay/http/encoding");
        i = mime.getKeys();
        while (i.hasMoreElements()) {
            String type = i.nextElement();
            __encodings.put(type, mime.getString(type));
        }
    }
}

