/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.Resource;

public class ContextLoader
extends URLClassLoader {
    private static HashMap __infoMap = new HashMap(3);
    private PathInfo _info;
    private String _path;
    private PermissionCollection _permissions;
    private boolean _jspWarned = false;

    private static URL[] decodePath(String classPath) {
        HashMap hashMap = __infoMap;
        synchronized (hashMap) {
            PathInfo info = (PathInfo)__infoMap.get(classPath);
            if (info != null && info._urls != null) {
                URL[] uRLArray = info._urls;
                Object var2_5 = null;
                return uRLArray;
            }
            info = new PathInfo();
            try {
                StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
                info._urls = new URL[tokenizer.countTokens()];
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    Resource resource = Resource.newResource(tokenizer.nextToken());
                    info._classPath = info._classPath == null ? resource.toString() : info._classPath + File.pathSeparator + resource.toString();
                    File pfile = resource.getFile();
                    if (pfile == null) {
                        info._unresolved = true;
                        info._fileClassPath = info._fileClassPath == null ? resource.toString() : info._fileClassPath + File.pathSeparator + resource.toString();
                    } else {
                        String string = info._fileClassPath = info._fileClassPath == null ? pfile.getCanonicalPath() : info._fileClassPath + File.pathSeparator + pfile.getAbsolutePath();
                    }
                    if (resource.isDirectory() || pfile != null) {
                        info._urls[i++] = resource.getURL();
                        continue;
                    }
                    InputStream in = resource.getInputStream();
                    File file = File.createTempFile("Jetty-", ".jar");
                    file.deleteOnExit();
                    Code.debug((Object)"Extract ", resource, (Object)" to ", file);
                    FileOutputStream out = new FileOutputStream(file);
                    IO.copy(in, out);
                    out.close();
                    info._urls[i++] = file.toURL();
                }
            }
            catch (Exception e) {
                Code.warning(e);
                info = null;
            }
            catch (Error e) {
                Code.warning(e);
                info = null;
            }
            if (info == null) {
                info = new PathInfo();
            }
            if (info._urls == null) {
                info._urls = new URL[0];
            }
            __infoMap.put(classPath, info);
            URL[] uRLArray = info._urls;
            Object var2_6 = null;
            return uRLArray;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (Code.verbose()) {
            Code.debug((Object)"findClass(", name, (Object)") from ", this._path);
        }
        try {
            return super.findClass(name);
        }
        catch (RuntimeException e) {
            Code.warning("Could not find class : " + name, e);
            throw e;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (Code.verbose()) {
            Code.debug("loadClass(", name, "," + resolve, ") from ", this._path);
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (RuntimeException e) {
            Code.warning("Could not load class : " + name, e);
            throw e;
        }
    }

    public String getFileClassPath() {
        if (this._info._unresolved && !this._jspWarned) {
            this._jspWarned = true;
            Code.warning("Non file CLASSPATH " + this._path + ". If JSP compiles are affected, try extracting WARs");
        }
        return this._info._fileClassPath;
    }

    public String toString() {
        return "org.mortbay.http.ContextLoader(" + this._path + ") / " + this.getParent();
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc = this._permissions == null ? super.getPermissions(cs) : this._permissions;
        Code.debug("loader.getPermissions(" + cs + ")=" + pc);
        return pc;
    }

    public ContextLoader(String classPath, ClassLoader parent, PermissionCollection permisions) {
        super(ContextLoader.decodePath(classPath), parent);
        this._info = (PathInfo)__infoMap.get(classPath);
        this._path = this._info._classPath;
        this._permissions = permisions;
        Code.debug("ContextLoader: ", this._path, ",", parent, " == ", this._info._fileClassPath);
        Code.debug((Object)"Permissions=", (Object)this._permissions);
    }

    private static class PathInfo {
        URL[] _urls = null;
        String _classPath = null;
        String _fileClassPath = null;
        boolean _unresolved = false;

        PathInfo() {
        }
    }
}

