/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mortbay.http.HttpFields;
import org.mortbay.util.Code;
import org.mortbay.util.LineInput;
import org.mortbay.util.StringUtil;

public class ChunkableInputStream
extends FilterInputStream {
    public static int __maxLineLength = 4096;
    public static final Class[] __filterArg = new Class[]{class$Ljava$io$InputStream != null ? class$Ljava$io$InputStream : (class$Ljava$io$InputStream = ChunkableInputStream.class$("java.io.InputStream"))};
    private static ClosedStream __closedStream = new ClosedStream();
    private DeChunker _deChunker;
    private LineInput _realIn;
    private boolean _chunking;
    private int _filters;
    private static /* synthetic */ Class class$Ljava$io$InputStream;

    public InputStream getRawStream() {
        return this._realIn;
    }

    public boolean isChunking() {
        return this._chunking;
    }

    public void setChunking() throws IllegalStateException {
        if (this._realIn.getByteLimit() >= 0) {
            throw new IllegalStateException("Has Content-Length");
        }
        if (this._deChunker == null) {
            this._deChunker = new DeChunker();
        }
        this.in = this._deChunker;
        this._chunking = true;
        this._deChunker._trailer = null;
    }

    public void resetStream() throws IllegalStateException {
        if (this._deChunker != null && this._deChunker._chunkSize > 0 || this._realIn.getByteLimit() > 0) {
            throw new IllegalStateException("Unread input");
        }
        if (Code.verbose()) {
            Code.debug("resetStream()");
        }
        this.in = this._realIn;
        this._filters = 0;
        if (this._deChunker != null) {
            this._deChunker._trailer = null;
        }
        this._chunking = false;
        this._realIn.setByteLimit(-1);
    }

    public void close() throws IOException {
        this.in = __closedStream;
    }

    public void insertFilter(Constructor filter, Object[] args) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        if (args == null || args.length < 1) {
            args = new Object[]{this.in};
        }
        this.in = (InputStream)filter.newInstance(args);
        ++this._filters;
    }

    public void setContentLength(int len) {
        if (this._chunking && len >= 0) {
            throw new IllegalStateException("Chunking");
        }
        this._realIn.setByteLimit(len);
    }

    public int getContentLength() {
        return this._realIn.getByteLimit();
    }

    public HttpFields getTrailer() {
        return this._deChunker._trailer;
    }

    static /* synthetic */ InputStream access$0(ChunkableInputStream chunkableInputStream) {
        return chunkableInputStream.in;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ChunkableInputStream(InputStream in) {
        super(null);
        try {
            this._realIn = new LineInput(in, 0, StringUtil.__ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            Code.fail(e);
        }
        this.in = this._realIn;
    }

    private static class ClosedStream
    extends InputStream {
        public int read() throws IOException {
            return -1;
        }

        ClosedStream() {
        }
    }

    private class DeChunker
    extends InputStream {
        int _chunkSize = 0;
        HttpFields _trailer = null;

        public int read() throws IOException {
            int b = -1;
            if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
                return -1;
            }
            b = ChunkableInputStream.this._realIn.read();
            this._chunkSize = b < 0 ? -1 : this._chunkSize - 1;
            return b;
        }

        public int read(byte[] b) throws IOException {
            int len = b.length;
            if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
                return -1;
            }
            if (len > this._chunkSize) {
                len = this._chunkSize;
            }
            this._chunkSize = (len = ChunkableInputStream.this._realIn.read(b, 0, len)) < 0 ? -1 : this._chunkSize - len;
            return len;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
                return -1;
            }
            if (len > this._chunkSize) {
                len = this._chunkSize;
            }
            this._chunkSize = (len = ChunkableInputStream.this._realIn.read(b, off, len)) < 0 ? -1 : this._chunkSize - len;
            return len;
        }

        public long skip(long len) throws IOException {
            if (this._chunkSize <= 0 && this.getChunkSize() <= 0) {
                return -1L;
            }
            if (len > (long)this._chunkSize) {
                len = this._chunkSize;
            }
            this._chunkSize = (len = ChunkableInputStream.this._realIn.skip(len)) < 0L ? -1 : this._chunkSize - (int)len;
            return len;
        }

        public int available() throws IOException {
            int len = ChunkableInputStream.this._realIn.available();
            if (len <= this._chunkSize) {
                return len;
            }
            return this._chunkSize;
        }

        public void close() throws IOException {
            Code.debug("Close");
            this._chunkSize = -1;
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() {
            Code.notImplemented();
        }

        public void mark(int readlimit) {
            Code.notImplemented();
        }

        private int getChunkSize() throws IOException {
            if (this._chunkSize < 0) {
                return -1;
            }
            this._trailer = null;
            this._chunkSize = -1;
            LineInput.LineBuffer line_buffer = ChunkableInputStream.this._realIn.readLineBuffer();
            while (line_buffer != null && line_buffer.size == 0) {
                line_buffer = ChunkableInputStream.this._realIn.readLineBuffer();
            }
            if (line_buffer == null) {
                Code.warning("EOF");
                return -1;
            }
            String line = new String(line_buffer.buffer, 0, line_buffer.size);
            int i = line.indexOf(59);
            if (i > 0) {
                line = line.substring(0, i).trim();
            }
            this._chunkSize = Integer.parseInt(line, 16);
            if (this._chunkSize == 0) {
                this._chunkSize = -1;
                this._trailer = new HttpFields();
                this._trailer.read(ChunkableInputStream.this._realIn);
            }
            return this._chunkSize;
        }
    }
}

