/*
 * Decompiled with CFR 0.152.
 */
package org.jxta.bridge.jxta;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeService;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import org.jxta.bridge.Acceptor;
import org.jxta.bridge.ServiceDescriptor;
import org.jxta.bridge.bootstrap.AXISBootstrap;
import org.jxta.bridge.deploy.DeploySOAPService;
import org.jxta.bridge.jxta.JXTARunData;
import org.jxta.bridge.jxta.Request;
import org.jxta.bridge.jxta.Response;

public abstract class Service
implements Acceptor {
    private JXTARunData runData = new JXTARunData();
    private ServiceDescriptor serviceDescriptor = null;
    private DiscoveryService ds = null;
    private PipeService ps = null;
    private PeerGroup platform = null;
    private PeerGroup netPeerGroup = null;

    public void init(PeerGroup platform, PeerGroup netPeerGroup, ServiceDescriptor descriptor) throws Exception {
        this.platform = platform;
        this.netPeerGroup = netPeerGroup;
        this.setServiceDescriptor(descriptor);
        AXISBootstrap.getInstance().bootstrap();
        JXTARunData rundata = this.getRunData();
        if (rundata.getPeerGroup() == null && descriptor.getPeerGroupID() == null) {
            throw new Exception("Must specify either a PeerGroup or a PeerGroup ID to join.");
        }
        if (rundata.getPeerGroup() == null && descriptor.getPeerGroupID() != null) {
            this.createOrJoinPeerGroup(descriptor);
        }
        this.ds = rundata.getPeerGroup().getDiscoveryService();
        this.ps = rundata.getPeerGroup().getPipeService();
        PipeAdvertisement pipeadv = this.advertisePipe();
        ModuleClassID mcID = this.advertiseModuleClass();
        this.advertiseModuleSpec(mcID, pipeadv);
        new DeploySOAPService(descriptor).deploy();
    }

    private void createOrJoinPeerGroup(ServiceDescriptor descriptor) throws Exception {
        JXTARunData rundata = this.getRunData();
        System.out.println("CREATING (or) JOINING NEW GROUP: " + descriptor.getPeerGroupID());
        PeerGroupID pgid = (PeerGroupID)IDFactory.fromURL((URL)new URL(descriptor.getPeerGroupID()));
        boolean created = this.isCreatedPeerGroup(descriptor.getPeerGroupID());
        String name = descriptor.getPeerGroupName();
        String description = descriptor.getPeerGroupDescription();
        if (!created) {
            System.out.println("CREATING GROUP FOR THE FIRST TIME. ");
            ModuleImplAdvertisement impladv = this.platform.getAllPurposePeerGroupImplAdvertisement();
            PeerGroup peergroup = this.platform.newGroup(pgid, (Advertisement)impladv, name, description);
            this.advertisePeerGroup(peergroup.getPeerGroupAdvertisement());
            rundata.setPeerGroup(peergroup);
        } else {
            System.out.println("JOINING AN EXISTING GROUP");
            Advertisement advert = this.getPeerGroupAdvertisement(descriptor.getPeerGroupID());
            PeerGroup peergroup = this.platform.newGroup(advert);
            rundata.setPeerGroup(peergroup);
        }
    }

    private void advertisePeerGroup(PeerGroupAdvertisement pga) throws Exception {
        DiscoveryService pds = this.platform.getDiscoveryService();
        DiscoveryService npgds = this.netPeerGroup.getDiscoveryService();
        pds.publish((Advertisement)pga, 1);
        pds.remotePublish((Advertisement)pga, 1);
        npgds.publish((Advertisement)pga, 1);
        npgds.remotePublish((Advertisement)pga, 1);
    }

    private boolean isCreatedPeerGroup(String pgid) throws Exception {
        DiscoveryService pds = this.platform.getDiscoveryService();
        DiscoveryService npgds = this.netPeerGroup.getDiscoveryService();
        Enumeration pds_enum = pds.getLocalAdvertisements(1, "GID", pgid);
        Enumeration npgds_enum = npgds.getLocalAdvertisements(1, "GID", pgid);
        return pds_enum.hasMoreElements() || npgds_enum.hasMoreElements();
    }

    private Advertisement getPeerGroupAdvertisement(String pgid) throws Exception {
        Enumeration enumeration = this.platform.getDiscoveryService().getLocalAdvertisements(1, "GID", pgid);
        return (Advertisement)enumeration.nextElement();
    }

    public abstract Response service(Request var1) throws Exception;

    public void accept(InputPipe pipe) throws Exception {
        Message msg = pipe.waitForMessage();
        String message = msg.getString("message");
        String remoteInputPipeAdvertisement = msg.getString("remote-input-pipe");
        if (message == null) {
            throw new Exception("Server: error could not find the tag");
        }
        PipeAdvertisement rpa = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((MimeMediaType)new MimeMediaType("text/xml"), (InputStream)new ByteArrayInputStream(remoteInputPipeAdvertisement.getBytes()));
        OutputPipe output = this.getRunData().getPeerGroup().getPipeService().createOutputPipe(rpa, this.serviceDescriptor.getTimeout());
        Request request = new Request();
        request.setMessage(message);
        Response response = this.service(request);
        MessageImpl returnMessage = new MessageImpl();
        returnMessage.setBytes("message", response.getMessage().getBytes());
        output.send((Message)returnMessage);
        output.close();
    }

    private PipeAdvertisement advertisePipe() throws Exception {
        PipeAdvertisement pipeadv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        PeerGroupID pgid = this.getRunData().getPeerGroup().getPeerGroupID();
        pipeadv.setPipeID((ID)IDFactory.newPipeID((PeerGroupID)pgid));
        pipeadv.setName(this.getServiceDescriptor().getName());
        if (this.serviceDescriptor.isSecure()) {
            pipeadv.setType("JxtaUnicastSecure");
        } else {
            pipeadv.setType("JxtaUnicast");
        }
        this.getRunData().setInputPipe(this.ps.createInputPipe(pipeadv));
        this.ds.publish((Advertisement)pipeadv, 2);
        this.ds.remotePublish((Advertisement)pipeadv, 2);
        this.getRunData().setInputPipeAdvertisement(pipeadv);
        return pipeadv;
    }

    private ModuleClassID advertiseModuleClass() throws Exception {
        ModuleClassAdvertisement mcadv = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement((String)ModuleClassAdvertisement.getAdvertisementType());
        mcadv.setName(this.getServiceDescriptor().getName());
        mcadv.setDescription(this.getServiceDescriptor().getDescription());
        ModuleClassID mcID = IDFactory.newModuleClassID();
        mcadv.setModuleClassID(mcID);
        this.ds.publish((Advertisement)mcadv, 2);
        this.ds.remotePublish((Advertisement)mcadv, 2);
        return mcID;
    }

    private void advertiseModuleSpec(ModuleClassID mcID, PipeAdvertisement pipeadv) throws Exception {
        ModuleSpecAdvertisement msadv = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement((String)ModuleSpecAdvertisement.getAdvertisementType());
        msadv.setName(this.getServiceDescriptor().getName());
        msadv.setVersion(this.getServiceDescriptor().getVersion());
        msadv.setCreator(this.getServiceDescriptor().getCreator());
        msadv.setModuleSpecID(IDFactory.newModuleSpecID((ModuleClassID)mcID));
        msadv.setSpecURI(this.getServiceDescriptor().getSpecURI());
        msadv.setPipeAdvertisement(pipeadv);
        StructuredTextDocument param = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)new MimeMediaType("text/xml"), (String)"Parm");
        TextElement element = param.createElement("peer-id", this.platform.getPeerID().toString());
        ((LiteXMLDocument)param).appendChild(element);
        msadv.setParam((StructuredDocument)param);
        this.ds.publish((Advertisement)msadv, 2);
        this.ds.remotePublish((Advertisement)msadv, 2);
    }

    public void setServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public void setRunData(JXTARunData runData) {
        this.runData = runData;
    }

    public JXTARunData getRunData() {
        return this.runData;
    }
}

