/*
 * Decompiled with CFR 0.152.
 */
package org.jxta.bridge.jxta;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.StructuredDocument;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.impl.document.LiteXMLElement;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.jxta.bridge.ServiceDescriptor;
import org.jxta.bridge.deploy.DeploySOAPService;
import org.jxta.bridge.jxta.MSAdvertisementComparator;
import org.jxta.bridge.jxta.transport.JXTASOAPTransport;

public class CallFactory {
    private static CallFactory instance = null;
    private Hashtable services = new Hashtable();

    public Call createCall(ServiceDescriptor descriptor, PeerID peerid, PeerGroup peergroup) throws Exception {
        ModuleSpecAdvertisement[] advs = this.getModuleSpecAdvertisements(descriptor, peerid, peergroup);
        OutputPipe outputpipe = null;
        PipeAdvertisement pipeadv = null;
        int i = 0;
        while (i < advs.length) {
            try {
                outputpipe = peergroup.getPipeService().createOutputPipe(advs[i].getPipeAdvertisement(), descriptor.getTimeout());
                pipeadv = advs[i].getPipeAdvertisement();
                break;
            }
            catch (Throwable t) {
                ++i;
            }
        }
        if (outputpipe == null) {
            throw new Exception("Unable to find a valid output pipe for service");
        }
        Call call = this.createCall(descriptor, pipeadv, peergroup);
        call.setProperty("outputpipe", (Object)outputpipe);
        return call;
    }

    private ModuleSpecAdvertisement[] getModuleSpecAdvertisements(ServiceDescriptor descriptor, PeerID peerid, PeerGroup peergroup) throws Exception {
        Vector<ModuleSpecAdvertisement> v = new Vector<ModuleSpecAdvertisement>();
        DiscoveryService ds = peergroup.getDiscoveryService();
        Enumeration enumeration = ds.getLocalAdvertisements(2, "Name", descriptor.getName());
        while (enumeration.hasMoreElements()) {
            Enumeration penum;
            ModuleSpecAdvertisement msa;
            StructuredDocument sd;
            Advertisement current = (Advertisement)enumeration.nextElement();
            if (!(current instanceof ModuleSpecAdvertisement) || (sd = (msa = (ModuleSpecAdvertisement)current).getParam()) == null || !(penum = ((LiteXMLDocument)sd).getChildren("peer-id")).hasMoreElements()) continue;
            String speerid = ((LiteXMLElement)penum.nextElement()).getTextValue();
            if (!peerid.toString().equals(speerid)) continue;
            v.addElement(msa);
        }
        Object[] result = new ModuleSpecAdvertisement[v.size()];
        v.copyInto(result);
        Arrays.sort(result, new MSAdvertisementComparator());
        return result;
    }

    public Call createCall(ServiceDescriptor descriptor, PipeAdvertisement advert, PeerGroup peergroup) throws Exception {
        Call call = this.createCall(descriptor);
        call.setTransport((Transport)new JXTASOAPTransport());
        call.setProperty("peergroup", (Object)peergroup);
        call.setProperty("advertisement", (Object)advert);
        call.setProperty("descriptor", (Object)descriptor);
        call.getMessageContext().setTargetService(descriptor.getName());
        return call;
    }

    private Call createCall(ServiceDescriptor descriptor) throws Exception {
        Service service = (Service)this.services.get(descriptor);
        if (service == null) {
            service = new DeploySOAPService(descriptor).getService();
            this.services.put(descriptor, service);
        }
        Call call = (Call)service.createCall();
        return call;
    }

    public static CallFactory getInstance() {
        if (instance == null) {
            instance = new CallFactory();
        }
        return instance;
    }
}

