/*
 * Decompiled with CFR 0.152.
 */
package org.jxta.bridge.deploy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.XMLStringProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.XMLUtils;
import org.jxta.bridge.ServiceDescriptor;
import org.jxta.bridge.bootstrap.AXISBootstrap;
import org.w3c.dom.Document;

public class DeploySOAPService {
    private ServiceDescriptor descriptor = null;

    public DeploySOAPService(ServiceDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void deploy() throws Exception {
        System.out.println("Deploying SOAP service...");
        Admin admin = new Admin();
        AxisServer server = AXISBootstrap.getInstance().getAxisServer();
        MessageContext context = new MessageContext((AxisEngine)server);
        String wsdd = this.getWSDD();
        Document doc = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(wsdd.getBytes()));
        admin.process(context, doc.getDocumentElement());
        System.out.println("Deploying SOAP service...done");
    }

    public Service getService() {
        Service service = new Service((EngineConfiguration)new XMLStringProvider(this.getWSDD()));
        return service;
    }

    private String getWSDD() {
        return "<deployment xmlns=\"http://xml.apache.org/axis/wsdd/\"             xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">\n    <handler name=\"JXTASOAPTransportSender\" type=\"java:org.jxta.bridge.jxta.transport.JXTASOAPTransportSender\"/>\n    <transport name=\"JXTASOAPTransport\" pivot=\"JXTASOAPTransportSender\"/>\n     <service name=\"" + this.descriptor.getName() + "\" provider=\"java:RPC\">\n" + "         <parameter name=\"allowedMethods\" value=\"*\"/>\n" + "         <parameter name=\"className\" value=\"" + this.descriptor.getClassname() + "\"/>\n" + "     </service>\n" + "</deployment>";
    }
}

