/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.JCEDHPrivateKey;
import org.bouncycastle.jce.provider.JCEDHPublicKey;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import org.bouncycastle.jce.provider.JCERSAPrivateKey;
import org.bouncycastle.jce.provider.JCERSAPublicKey;
import org.bouncycastle.jce.provider.JDKDSAPrivateKey;
import org.bouncycastle.jce.provider.JDKDSAPublicKey;

public abstract class JDKKeyFactory
extends KeyFactorySpi {
    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        throw new RuntimeException("not implemented");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return new JCERSAPublicKey((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new JCERSAPrivateCrtKey((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new JCERSAPrivateKey((RSAPrivateKey)key);
        }
        if (key instanceof DHPublicKey) {
            return new JCEDHPublicKey((DHPublicKey)key);
        }
        if (key instanceof DHPrivateKey) {
            return new JCEDHPrivateKey((DHPrivateKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return new JDKDSAPublicKey((DSAPublicKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return new JDKDSAPrivateKey((DSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    static PublicKey createPublicKeyFromDERStream(InputStream inputStream) throws IOException {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(new SubjectPublicKeyInfo((DERConstructedSequence)new DERInputStream(inputStream).readObject()));
    }

    static PublicKey createPublicKeyFromPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithmId();
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption) || algorithmIdentifier.getObjectId().equals(X509ObjectIdentifiers.id_ea_rsa)) {
            return new JCERSAPublicKey(subjectPublicKeyInfo);
        }
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            return new JCEDHPublicKey(subjectPublicKeyInfo);
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.dhpublicnumber)) {
            return new JCEDHPublicKey(subjectPublicKeyInfo);
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_dsa)) {
            return new JDKDSAPublicKey(subjectPublicKeyInfo);
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPublicKey(subjectPublicKeyInfo);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }

    static PrivateKey createPrivateKeyFromDERStream(InputStream inputStream) throws IOException {
        return JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo(new PrivateKeyInfo((DERConstructedSequence)new DERInputStream(inputStream).readObject()));
    }

    static PrivateKey createPrivateKeyFromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getAlgorithmId();
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            return new JCERSAPrivateCrtKey(privateKeyInfo);
        }
        if (algorithmIdentifier.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            return new JCEDHPrivateKey(privateKeyInfo);
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_dsa)) {
            return new JDKDSAPrivateKey(privateKeyInfo);
        }
        if (algorithmIdentifier.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPrivateKey(privateKeyInfo);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

